/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

public class JobExceptionHandler
implements Synchronization,
Command<Object> {
    private static final long serialVersionUID = 219531695187147766L;
    private static final Logger LOG = Logger.getLogger(JobExceptionHandler.class.getName());
    protected transient CommandService commandService;
    protected long jobId;
    protected Throwable exception;

    public JobExceptionHandler(long jobId, Throwable exception, CommandService commandService) {
        this.commandService = commandService;
        this.jobId = jobId;
        this.exception = exception;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        LOG.severe("starting new transaction for handling job exception");
        this.commandService.execute(this);
        LOG.severe("completed transaction for handling job exception");
    }

    @Override
    public Object execute(Environment environment) throws Exception {
        Execution execution;
        StringWriter sw = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(sw));
        Job job = EnvTool.getEventService().getJob(this.jobId);
        if (job.getExecutionUUID() != null && (execution = EnvTool.getJournal().getExecutionWithEventUUID(job.getExecutionUUID())) != null) {
            if (!"active".equals(execution.getState())) {
                execution.unlock();
            }
            execution.lock(execution.getState());
        }
        int decrementedRetries = job.getRetries() - 1;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Decrementing retries on job: " + job + ": " + decrementedRetries);
        }
        job.setRetries(decrementedRetries);
        job.setException(sw.toString());
        job.unlock();
        EnvTool.getEventExecutor().refreshJobExecutor();
        return null;
    }
}

