/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.hibernate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;
import org.hibernate.usertype.ParameterizedType;
import org.ow2.bonita.type.Converter;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.ReflectUtil;

public class ConverterType
extends ImmutableType
implements ParameterizedType {
    private static final long serialVersionUID = 1L;
    private Map<Class<?>, String> converterNames = null;
    private Map<String, Converter> converters = null;

    public Object fromStringValue(String arg0) throws HibernateException {
        return null;
    }

    public Object get(ResultSet resultSet, String name) throws HibernateException, SQLException {
        String converterName = resultSet.getString(name);
        return this.converters.get(converterName);
    }

    public void set(PreparedStatement stmt, Object value, int index) throws HibernateException, SQLException {
        String converterName = value != null ? this.converterNames.get(value.getClass()) : null;
        stmt.setString(index, converterName);
    }

    public int sqlType() {
        return 12;
    }

    public String toString(Object arg0) throws HibernateException {
        return null;
    }

    public String getName() {
        return "converter";
    }

    public Class<?> getReturnedClass() {
        return Converter.class;
    }

    public void setParameterValues(Properties properties) {
        this.converterNames = new HashMap();
        this.converters = new HashMap<String, Converter>();
        for (Object key : properties.keySet()) {
            String converterClassName = (String)key;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> converterClass = ReflectUtil.loadClass(classLoader, converterClassName);
                String converterName = properties.getProperty(converterClassName);
                this.converterNames.put(converterClass, converterName);
                Converter converter = (Converter)converterClass.newInstance();
                this.converters.put(converterName, converter);
            }
            catch (Exception e) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_CT_1", converterClassName);
                throw new BonitaRuntimeException(message, e);
            }
        }
    }
}

