/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.tx;

import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.exception.BonitaWrapperException;
import org.ow2.bonita.facade.exception.UnRollbackableException;
import org.ow2.bonita.runtime.tx.StandardTransaction;
import org.ow2.bonita.services.impl.Interceptor;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

public class StandardTransactionInterceptor
extends Interceptor {
    @Override
    public <T> T execute(Command<T> command) {
        StandardTransaction standardTransaction = EnvTool.getTransaction();
        standardTransaction.begin();
        try {
            T t = this.next.execute(command);
            return t;
        }
        catch (UnRollbackableException e) {
            Throwable originalCause = e.getCause();
            if (originalCause instanceof BonitaWrapperException) {
                BonitaWrapperException wrapper = (BonitaWrapperException)originalCause;
                throw wrapper;
            }
            throw new BonitaWrapperException(originalCause);
        }
        catch (BonitaInternalException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnRollbackableException) {
                Throwable originalCause = cause.getCause();
                if (originalCause instanceof RuntimeException) {
                    throw (RuntimeException)originalCause;
                }
                throw new BonitaWrapperException(originalCause);
            }
            standardTransaction.setRollbackOnly();
            throw e;
        }
        catch (RuntimeException e) {
            standardTransaction.setRollbackOnly();
            throw e;
        }
        finally {
            standardTransaction.complete();
        }
    }
}

