/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.search;

import java.io.Serializable;
import java.util.List;
import org.ow2.bonita.search.QueryFormatter;
import org.ow2.bonita.search.SearchQueryBuilder;

public class Criteria
implements Serializable {
    private static final long serialVersionUID = 3605699586653944501L;
    private SearchQueryBuilder builder;
    private List<String> fieldNames;
    private String value;
    private String operator;

    public Criteria(List<String> fieldNames, SearchQueryBuilder builder) {
        this.fieldNames = fieldNames;
        this.operator = "OR";
        this.builder = builder;
    }

    public Criteria union() {
        this.operator = "OR";
        return this;
    }

    public Criteria inclusion() {
        this.operator = "AND";
        return this;
    }

    public Criteria startsWith(String value) {
        this.value = QueryFormatter.startsWith(value);
        return this;
    }

    public Criteria equalsTo(String value) {
        this.value = QueryFormatter.equals(value);
        return this;
    }

    public Criteria ranges(String from, String to, boolean exclusive) {
        this.value = QueryFormatter.ranges(from, to, exclusive);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int fields = this.fieldNames.size();
        for (int i = 0; i < fields - 1; ++i) {
            String fieldName = this.fieldNames.get(i);
            String field = QueryFormatter.field(fieldName, this.value);
            builder.append(field).append(" ").append(this.operator).append(" ");
        }
        String lastFieldName = this.fieldNames.get(fields - 1);
        String lastField = QueryFormatter.field(lastFieldName, this.value);
        builder.append(lastField);
        return builder.toString();
    }

    public SearchQueryBuilder rightParenthesis() {
        this.builder.rightParenthesis();
        return this.builder;
    }

    public SearchQueryBuilder or() {
        this.builder.or();
        return this.builder;
    }

    public SearchQueryBuilder and() {
        this.builder.and();
        return this.builder;
    }
}

