/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services;

import java.util.Date;
import java.util.List;
import org.ow2.bonita.facade.exception.DocumentAlreadyExistsException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.impl.SearchResult;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.services.Document;

public interface DocumentationManager {
    public Document createDocument(String var1, ProcessDefinitionUUID var2) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(String var1, ProcessDefinitionUUID var2, ProcessInstanceUUID var3) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(String var1, ProcessDefinitionUUID var2, String var3, String var4, byte[] var5) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(String var1, ProcessDefinitionUUID var2, ProcessInstanceUUID var3, String var4, String var5, byte[] var6) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(String var1, ProcessDefinitionUUID var2, ProcessInstanceUUID var3, String var4, String var5, byte[] var6, String var7, Date var8, Date var9) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createMetaDocument(ProcessDefinitionUUID var1, String var2, String var3, String var4, byte[] var5) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createMetaDocument(ProcessDefinitionUUID var1, String var2, String var3, String var4, byte[] var5, String var6, Date var7, Date var8) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document getDocument(String var1) throws DocumentNotFoundException;

    public void deleteDocument(String var1, boolean var2) throws DocumentNotFoundException;

    public byte[] getContent(Document var1) throws DocumentNotFoundException;

    public List<Document> getMetaDocuments(ProcessDefinitionUUID var1);

    public List<Document> getVersionsOfDocument(String var1) throws DocumentNotFoundException;

    public Document createVersion(String var1, boolean var2) throws DocumentationCreationException;

    public Document createVersion(String var1, boolean var2, String var3, String var4, byte[] var5) throws DocumentationCreationException;

    public Document createVersion(String var1, boolean var2, String var3, String var4, byte[] var5, String var6, Date var7, Date var8) throws DocumentationCreationException;

    public List<Document> getDocuments(ProcessInstanceUUID var1, int var2, int var3);

    public List<Document> getDocuments(ProcessInstanceUUID var1, String var2, int var3, int var4);

    public long getNbOfDocuments(ProcessInstanceUUID var1, String var2);

    public List<Document> getDocuments(ProcessDefinitionUUID var1, String var2, int var3, int var4);

    public List<Document> getDocumentsOfProcessDefinitionWithoutInstances(ProcessDefinitionUUID var1, int var2, int var3);

    public SearchResult search(DocumentSearchBuilder var1, int var2, int var3);

    public void clear() throws DocumentNotFoundException;

    public void attachDocumentTo(ProcessDefinitionUUID var1, ProcessInstanceUUID var2, String var3) throws DocumentNotFoundException;

    public void deleteDocuments(ProcessDefinitionUUID var1) throws DocumentNotFoundException;
}

