/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import com.thoughtworks.xstream.XStream;
import java.util.Date;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.util.xml.XStreamUtil;

public class DocumentImpl
implements Document {
    private String id;
    private final String name;
    private String author;
    private Date creationDate;
    private String lastModifiedBy;
    private Date lastModificationDate;
    private boolean latestVersion;
    private boolean majorVersion;
    private String versionLabel;
    private String versionSeriesId;
    private String contentMimeType;
    private String contentFileName;
    private long contentSize;
    private ProcessInstanceUUID processInstanceUUID;
    private ProcessDefinitionUUID processDefinitionUUID;
    private String contentStorageId;

    public DocumentImpl(String name, String author, Date creationDate, Date lastModificationDate, boolean latestVersion, boolean majorVersion, String versionLabel, String versionSeriesId, String contentFileName, String contentMimeType, long contentSize, ProcessDefinitionUUID processDefinitionUUID, ProcessInstanceUUID processInstanceUUID, String contentStorageId) {
        this(name, author, creationDate, lastModificationDate, latestVersion, majorVersion, versionLabel, versionSeriesId, contentFileName, contentMimeType, contentSize, processDefinitionUUID, processInstanceUUID, contentStorageId, null);
    }

    public DocumentImpl(String name, String author, Date creationDate, Date lastModificationDate, boolean latestVersion, boolean majorVersion, String versionLabel, String versionSeriesId, String contentFileName, String contentMimeType, long contentSize, ProcessDefinitionUUID processDefinitionUUID, ProcessInstanceUUID processInstanceUUID, String contentStorageId, String documentId) {
        this.name = name;
        this.author = author;
        this.creationDate = creationDate;
        this.lastModifiedBy = author;
        this.lastModificationDate = lastModificationDate;
        this.latestVersion = latestVersion;
        this.majorVersion = majorVersion;
        this.versionLabel = versionLabel;
        this.versionSeriesId = versionSeriesId;
        this.contentFileName = contentFileName;
        this.contentMimeType = contentMimeType;
        this.contentSize = contentSize;
        this.processInstanceUUID = processInstanceUUID;
        this.processDefinitionUUID = processDefinitionUUID;
        this.contentStorageId = contentStorageId;
        this.id = documentId;
    }

    public DocumentImpl(String name, String author, long creationDate, long lastModificationDate, boolean majorVersion, long versionLabel, long versionSeriesId, String contentFileName, String contentMimeType, long contentSize, ProcessDefinitionUUID processDefinitionUUID, ProcessInstanceUUID processInstanceUUID, String contentStorageId, long documentId) {
        this.name = name;
        this.author = author;
        this.creationDate = new Date(creationDate);
        this.lastModifiedBy = author;
        this.lastModificationDate = new Date(lastModificationDate);
        this.latestVersion = true;
        this.majorVersion = majorVersion;
        this.versionLabel = String.valueOf(versionLabel);
        this.versionSeriesId = String.valueOf(versionSeriesId);
        this.contentFileName = contentFileName;
        this.contentMimeType = contentMimeType;
        this.contentSize = contentSize;
        this.processInstanceUUID = processInstanceUUID;
        this.processDefinitionUUID = processDefinitionUUID;
        this.contentStorageId = contentStorageId;
        this.id = String.valueOf(documentId);
    }

    public DocumentImpl(String name) {
        this.name = name;
    }

    public DocumentImpl(String name, String contentFileName, String contentMimeType, long contentSize) {
        this.name = name;
        this.contentFileName = contentFileName;
        this.contentMimeType = contentMimeType;
        this.contentSize = contentSize;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setProcessInstanceUUID(ProcessInstanceUUID processInstanceUUID) {
        this.processInstanceUUID = processInstanceUUID;
    }

    public void setProcessDefinitionUUID(ProcessDefinitionUUID processDefinitionUUID) {
        this.processDefinitionUUID = processDefinitionUUID;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @Override
    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    @Override
    public boolean isLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public boolean isMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public String getVersionLabel() {
        return this.versionLabel;
    }

    @Override
    public String getVersionSeriesId() {
        return this.versionSeriesId;
    }

    @Override
    public String getContentMimeType() {
        return this.contentMimeType;
    }

    @Override
    public String getContentFileName() {
        return this.contentFileName;
    }

    @Override
    public long getContentSize() {
        return this.contentSize;
    }

    @Override
    public ProcessInstanceUUID getProcessInstanceUUID() {
        return this.processInstanceUUID;
    }

    @Override
    public ProcessDefinitionUUID getProcessDefinitionUUID() {
        return this.processDefinitionUUID;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getContentStorageId() {
        return this.contentStorageId;
    }

    public void setContentStorageId(String contentStorageId) {
        this.contentStorageId = contentStorageId;
    }

    public String toString() {
        XStream xstream = XStreamUtil.getDefaultXstream();
        return xstream.toXML((Object)this);
    }
}

