/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.persistence.DocumentDbSession;
import org.ow2.bonita.runtime.CommonClassLoader;
import org.ow2.bonita.services.DocumentContent;
import org.ow2.bonita.services.DocumentStorageService;
import org.ow2.bonita.services.DocumentVersion;
import org.ow2.bonita.services.impl.DocumentContentImpl;
import org.ow2.bonita.util.EnvTool;

public class DocumentStorageServiceImpl
implements DocumentStorageService {
    private final String persistenceServiceName;

    public DocumentStorageServiceImpl(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    public DocumentDbSession getDbSession() {
        return EnvTool.getDocumentDbSession(this.persistenceServiceName);
    }

    @Override
    public byte[] getContent(String documentId) throws DocumentNotFoundException {
        DocumentContent documentContent = this.getDocumentContent(documentId);
        return documentContent.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentContent getDocumentContent(String documentId) throws DocumentNotFoundException {
        DocumentContent documentContent = null;
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            CommonClassLoader commonClassLoader = EnvTool.getClassDataLoader().getCommonClassLoader();
            Thread.currentThread().setContextClassLoader(commonClassLoader);
            documentContent = this.getDbSession().getDocumentContent(Long.valueOf(documentId));
        }
        finally {
            if (ori != null) {
                Thread.currentThread().setContextClassLoader(ori);
            }
        }
        if (documentContent == null) {
            throw new DocumentNotFoundException(documentId);
        }
        return documentContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentVersion storeDocumentContent(DocumentVersion document, byte[] documentContent) throws DocumentationCreationException {
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            CommonClassLoader commonClassLoader = EnvTool.getClassDataLoader().getCommonClassLoader();
            Thread.currentThread().setContextClassLoader(commonClassLoader);
            DocumentContentImpl content = new DocumentContentImpl(documentContent);
            this.getDbSession().save(content);
            document.setContentStorageId(content.getId());
            DocumentVersion documentVersion = document;
            return documentVersion;
        }
        finally {
            if (ori != null) {
                Thread.currentThread().setContextClassLoader(ori);
            }
        }
    }

    @Override
    public void deleteContent(String documentId) throws DocumentNotFoundException {
        DocumentContent documentContent = this.getDocumentContent(documentId);
        this.getDbSession().delete(documentContent);
    }
}

