/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.services.Journal;
import org.ow2.bonita.services.UUIDService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ProcessUtil;

public class HiloDbUUIDService
implements UUIDService {
    static final Logger LOG = Logger.getLogger(ProcessUtil.class.getName());
    private final int increment;
    private final ConcurrentMap<ProcessDefinitionUUID, Sequence> sequences = new ConcurrentHashMap<ProcessDefinitionUUID, Sequence>();

    public HiloDbUUIDService() {
        this(1);
    }

    public HiloDbUUIDService(int increment) {
        this.increment = increment;
    }

    private String getMetadataName(ProcessDefinitionUUID processUUID) {
        return "*****" + processUUID + "*****instance-nb*****";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNewProcessInstanceNb(ProcessDefinitionUUID processUUID) {
        long processInstanceNb;
        Sequence sequence;
        final String metaName = this.getMetadataName(processUUID);
        Sequence sequence2 = sequence = this.getSequence(processUUID);
        synchronized (sequence2) {
            if (sequence.shouldReset()) {
                long nextHi = EnvTool.getCommandService().execute(new Command<Long>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Long execute(Environment environment) throws Exception {
                        Journal journal = EnvTool.getJournal();
                        journal.lockMetadata(metaName);
                        long nb = journal.getLockedMetadata(metaName);
                        journal.updateLockedMetadata(metaName, nb += (long)HiloDbUUIDService.this.increment);
                        return nb;
                    }
                });
                sequence.reset(nextHi, this.increment);
            }
            processInstanceNb = sequence.inc();
        }
        return processInstanceNb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveOrDeleteProcess(ProcessDefinitionUUID processUUID) {
        Sequence sequence;
        String metaName = this.getMetadataName(processUUID);
        Sequence sequence2 = sequence = this.getSequence(processUUID);
        synchronized (sequence2) {
            EnvTool.getJournal().removeLockedMetadata(metaName);
        }
    }

    private Sequence getSequence(ProcessDefinitionUUID processUUID) {
        Sequence old;
        Sequence sequence = (Sequence)this.sequences.get(processUUID);
        if (sequence == null && (old = this.sequences.putIfAbsent(processUUID, sequence = new Sequence())) != null) {
            sequence = old;
        }
        return sequence;
    }

    private static final class Sequence {
        private long hi = -1L;
        private long low = -1L;

        private Sequence() {
        }

        boolean shouldReset() {
            return this.low < 0L || this.low >= this.hi;
        }

        void reset(long nextHi, long increment) {
            assert (nextHi >= 0L) : "nextHi is negative: " + nextHi;
            assert (increment > 0L) : "increment is negative or null";
            this.hi = nextHi;
            this.low = nextHi - increment;
        }

        public long inc() {
            assert (!this.shouldReset()) : "inc() should not be called in a context where reset is needed";
            ++this.low;
            return this.low;
        }
    }
}

