/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.paging.ActivityInstanceCriterion;
import org.ow2.bonita.facade.paging.ProcessDefinitionCriterion;
import org.ow2.bonita.facade.paging.ProcessInstanceCriterion;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.Category;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.impl.CategoryImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.CategoryUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.search.SearchQueryBuilder;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.util.ActivityInstanceLastUpdateComparator;
import org.ow2.bonita.util.InternalProcessDefinitionComparator;
import org.ow2.bonita.util.InternalProcessInstanceComparator;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessInstanceEndedDateComparatorAsc;
import org.ow2.bonita.util.ProcessInstanceEndedDateComparatorDesc;
import org.ow2.bonita.util.ProcessInstanceLastUpdateComparator;
import org.ow2.bonita.util.ProcessInstanceLastUpdateComparatorAsc;
import org.ow2.bonita.util.ProcessInstanceNbComparatorAsc;
import org.ow2.bonita.util.ProcessInstanceNbComparatorDesc;
import org.ow2.bonita.util.ProcessInstanceStartedDateComparatorAsc;
import org.ow2.bonita.util.ProcessInstanceStartedDateComparatorDesc;
import org.ow2.bonita.util.ProcessInstanceUUIDComparatorAsc;
import org.ow2.bonita.util.ProcessInstanceUUIDComparatorDesc;

public class QuerierChainer
implements Querier {
    private final List<Querier> queriers;

    public QuerierChainer(List<Querier> queriers) {
        this.queriers = queriers;
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityName) {
        HashSet<InternalActivityInstance> set = new HashSet<InternalActivityInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalActivityInstance> tmp = querier.getActivityInstances(instanceUUID, activityName);
            if (tmp == null || tmp.isEmpty()) continue;
            set.addAll(tmp);
        }
        return set;
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityName, String iterationId) {
        HashSet<InternalActivityInstance> set = new HashSet<InternalActivityInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalActivityInstance> tmp = querier.getActivityInstances(instanceUUID, activityName, iterationId);
            if (tmp == null || tmp.isEmpty()) continue;
            set.addAll(tmp);
        }
        return set;
    }

    @Override
    public int getNumberOfProcesses() {
        int nb = 0;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfProcesses();
        }
        return nb;
    }

    @Override
    public int getNumberOfParentProcessInstances() {
        int nb = 0;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfParentProcessInstances();
        }
        return nb;
    }

    @Override
    public int getNumberOfProcessInstances() {
        int nb = 0;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfProcessInstances();
        }
        return nb;
    }

    @Override
    public InternalProcessInstance getProcessInstance(ProcessInstanceUUID instanceUUID) {
        for (Querier querier : this.queriers) {
            InternalProcessInstance processInst = querier.getProcessInstance(instanceUUID);
            if (processInst == null) continue;
            return processInst;
        }
        return null;
    }

    @Override
    public Set<ProcessInstanceUUID> getParentInstancesUUIDs() {
        HashSet<ProcessInstanceUUID> processInsts = new HashSet<ProcessInstanceUUID>();
        for (Querier querier : this.queriers) {
            Set<ProcessInstanceUUID> tmp = querier.getParentInstancesUUIDs();
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId, Date minStartDate) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getUserInstances(userId, minStartDate);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getUserParentInstances(String userId, Date minStartDate) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getUserParentInstances(userId, minStartDate);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public TaskInstance getOneTask(String userId, ProcessDefinitionUUID processUUID, ActivityState taskState) {
        for (Querier querier : this.queriers) {
            TaskInstance task = querier.getOneTask(userId, processUUID, taskState);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    @Override
    public TaskInstance getOneTask(String userId, ProcessInstanceUUID instanceUUID, ActivityState taskState) {
        for (Querier querier : this.queriers) {
            TaskInstance task = querier.getOneTask(userId, instanceUUID, taskState);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    @Override
    public TaskInstance getOneTask(String userId, ActivityState taskState) {
        for (Querier querier : this.queriers) {
            TaskInstance task = querier.getOneTask(userId, taskState);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances() {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getProcessInstances();
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getUserInstancesExcept(String userId, Set<ProcessInstanceUUID> myCases) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getUserInstancesExcept(userId, myCases);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getProcessInstances(instanceUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getParentInstances() {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getParentInstances();
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithTaskState(Collection<ActivityState> activityStates) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getProcessInstancesWithTaskState(activityStates);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithInstanceStates(Collection<InstanceState> instanceStates) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getProcessInstancesWithInstanceStates(instanceStates);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getProcessInstances(processUUID));
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID, InstanceState instanceState) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getProcessInstances(processUUID, instanceState));
        }
        return processInsts;
    }

    @Override
    public InternalActivityInstance getActivityInstance(ProcessInstanceUUID instanceUUID, String activityId, String iterationId, String activityInstanceId, String loopId) {
        for (Querier querier : this.queriers) {
            InternalActivityInstance activityInst = querier.getActivityInstance(instanceUUID, activityId, iterationId, activityInstanceId, loopId);
            if (activityInst == null) continue;
            return activityInst;
        }
        return null;
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(ProcessInstanceUUID rootInstanceUUID) {
        ArrayList<InternalActivityInstance> activities = new ArrayList<InternalActivityInstance>();
        for (Querier querier : this.queriers) {
            List<InternalActivityInstance> tmp = querier.getActivityInstancesFromRoot(rootInstanceUUID);
            if (tmp == null || tmp.isEmpty()) continue;
            activities.addAll(tmp);
        }
        if (!activities.isEmpty()) {
            Collections.sort(activities, new ActivityInstanceLastUpdateComparator());
        }
        return activities;
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs) {
        ArrayList<InternalActivityInstance> activities = new ArrayList<InternalActivityInstance>();
        for (Querier querier : this.queriers) {
            List<InternalActivityInstance> tmp = querier.getActivityInstancesFromRoot(rootInstanceUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            activities.addAll(tmp);
        }
        if (!activities.isEmpty()) {
            Collections.sort(activities, new ActivityInstanceLastUpdateComparator());
        }
        return activities;
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, ActivityState state) {
        ArrayList<InternalActivityInstance> activities = new ArrayList<InternalActivityInstance>();
        for (Querier querier : this.queriers) {
            List<InternalActivityInstance> tmp = querier.getActivityInstancesFromRoot(rootInstanceUUIDs, state);
            if (tmp == null || tmp.isEmpty()) continue;
            activities.addAll(tmp);
        }
        if (!activities.isEmpty()) {
            Collections.sort(activities, new ActivityInstanceLastUpdateComparator());
        }
        return activities;
    }

    @Override
    public Map<ProcessInstanceUUID, InternalActivityInstance> getLastUpdatedActivityInstanceFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, boolean considerSystemTaks) {
        HashMap<ProcessInstanceUUID, InternalActivityInstance> activities = new HashMap<ProcessInstanceUUID, InternalActivityInstance>();
        for (Querier querier : this.queriers) {
            Map<ProcessInstanceUUID, InternalActivityInstance> tmp = querier.getLastUpdatedActivityInstanceFromRoot(rootInstanceUUIDs, considerSystemTaks);
            for (Map.Entry<ProcessInstanceUUID, InternalActivityInstance> entry : tmp.entrySet()) {
                activities.put(entry.getKey(), entry.getValue());
            }
        }
        return activities;
    }

    @Override
    public long getLastProcessInstanceNb(ProcessDefinitionUUID processUUID) {
        long max = -1L;
        for (Querier querier : this.queriers) {
            long l = querier.getLastProcessInstanceNb(processUUID);
            if (l <= max) continue;
            max = l;
        }
        return max;
    }

    @Override
    public Execution getExecutionOnActivity(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityInstanceUUID) {
        for (Querier querier : this.queriers) {
            Execution execution = querier.getExecutionOnActivity(instanceUUID, activityInstanceUUID);
            if (execution == null) continue;
            return execution;
        }
        return null;
    }

    @Override
    public Execution getExecutionWithEventUUID(String eventUUID) {
        for (Querier querier : this.queriers) {
            Execution execution = querier.getExecutionWithEventUUID(eventUUID);
            if (execution == null) continue;
            return execution;
        }
        return null;
    }

    @Override
    public Set<Execution> getExecutions(ProcessInstanceUUID instanceUUID) {
        HashSet<Execution> executions = new HashSet<Execution>();
        for (Querier querier : this.queriers) {
            executions.addAll(querier.getExecutions(instanceUUID));
        }
        return executions;
    }

    @Override
    public ActivityState getActivityInstanceState(ActivityInstanceUUID activityInstanceUUID) {
        for (Querier querier : this.queriers) {
            ActivityState activityState = querier.getActivityInstanceState(activityInstanceUUID);
            if (activityState == null) continue;
            return activityState;
        }
        return null;
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID) {
        HashSet<InternalActivityInstance> activityInsts = new HashSet<InternalActivityInstance>();
        for (Querier querier : this.queriers) {
            activityInsts.addAll(querier.getActivityInstances(instanceUUID));
            if (activityInsts.isEmpty()) continue;
            return activityInsts;
        }
        return activityInsts;
    }

    @Override
    public List<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, int fromIndex, int pageSize, ActivityInstanceCriterion pagingCriterion) {
        ArrayList<InternalActivityInstance> activityInsts = new ArrayList<InternalActivityInstance>();
        for (Querier querier : this.queriers) {
            activityInsts.addAll(querier.getActivityInstances(instanceUUID, fromIndex, pageSize, pagingCriterion));
            if (activityInsts.isEmpty()) continue;
            return activityInsts;
        }
        return activityInsts;
    }

    @Override
    public TaskInstance getTaskInstance(ActivityInstanceUUID taskUUID) {
        for (Querier querier : this.queriers) {
            TaskInstance activity = querier.getTaskInstance(taskUUID);
            if (activity == null) continue;
            return activity;
        }
        return null;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses() {
        HashSet<InternalProcessDefinition> processes = new HashSet<InternalProcessDefinition>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessDefinition> querierProcesses = querier.getProcesses();
            if (querierProcesses == null || querierProcesses.isEmpty()) continue;
            processes.addAll(querierProcesses);
        }
        return processes;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(String processId) {
        HashSet<InternalProcessDefinition> processes = new HashSet<InternalProcessDefinition>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessDefinition> querierProcesses = querier.getProcesses(processId);
            if (querierProcesses == null || querierProcesses.isEmpty()) continue;
            processes.addAll(querierProcesses);
        }
        return processes;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(ProcessDefinition.ProcessState processState) {
        HashSet<InternalProcessDefinition> processes = new HashSet<InternalProcessDefinition>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessDefinition> querierProcesses = querier.getProcesses(processState);
            if (querierProcesses == null || querierProcesses.isEmpty()) continue;
            processes.addAll(querierProcesses);
        }
        return processes;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(String processId, ProcessDefinition.ProcessState processState) {
        HashSet<InternalProcessDefinition> processes = new HashSet<InternalProcessDefinition>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessDefinition> querierProcesses = querier.getProcesses(processId, processState);
            if (querierProcesses == null || querierProcesses.isEmpty()) continue;
            processes.addAll(querierProcesses);
        }
        return processes;
    }

    @Override
    public InternalProcessDefinition getProcess(ProcessDefinitionUUID processUUID) {
        for (Querier querier : this.queriers) {
            InternalProcessDefinition process = querier.getProcess(processUUID);
            if (process == null) continue;
            return process;
        }
        return null;
    }

    @Override
    public InternalProcessDefinition getProcess(String processId, String version) {
        for (Querier querier : this.queriers) {
            InternalProcessDefinition process = querier.getProcess(processId, version);
            if (process == null) continue;
            return process;
        }
        return null;
    }

    @Override
    public String getLastProcessVersion(String processName) {
        Misc.checkArgsNotNull(processName);
        String last = null;
        for (Querier querier : this.queriers) {
            String version = querier.getLastProcessVersion(processName);
            if (version == null || last != null && version.compareTo(last) <= 0) continue;
            last = version;
        }
        return last;
    }

    @Override
    public InternalProcessDefinition getLastDeployedProcess(String processId, ProcessDefinition.ProcessState processState) {
        Misc.checkArgsNotNull(new Object[]{processId, processState});
        Set<InternalProcessDefinition> processes = this.getProcesses(processId, processState);
        InternalProcessDefinition lastProcess = null;
        for (InternalProcessDefinition process : processes) {
            if (lastProcess == null) {
                lastProcess = process;
                continue;
            }
            if (!process.getDeployedDate().after(lastProcess.getDeployedDate())) continue;
            lastProcess = process;
        }
        return lastProcess;
    }

    @Override
    public InternalActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) {
        for (Querier querier : this.queriers) {
            InternalActivityInstance activity = querier.getActivityInstance(activityInstanceUUID);
            if (activity == null) continue;
            return activity;
        }
        return null;
    }

    @Override
    public Set<TaskInstance> getTaskInstances(ProcessInstanceUUID instanceUUID) {
        HashSet<TaskInstance> activities = new HashSet<TaskInstance>();
        for (Querier querier : this.queriers) {
            activities.addAll(querier.getTaskInstances(instanceUUID));
            if (activities.isEmpty()) continue;
            return activities;
        }
        return activities;
    }

    @Override
    public Set<TaskInstance> getTaskInstances(ProcessInstanceUUID instanceUUID, Set<String> taskNames) {
        HashSet<TaskInstance> activities = new HashSet<TaskInstance>();
        for (Querier querier : this.queriers) {
            activities.addAll(querier.getTaskInstances(instanceUUID, taskNames));
            if (activities.isEmpty()) continue;
            return activities;
        }
        return activities;
    }

    @Override
    public Set<TaskInstance> getUserInstanceTasks(String userId, ProcessInstanceUUID instanceUUID, ActivityState taskState) {
        HashSet<TaskInstance> activities = new HashSet<TaskInstance>();
        for (Querier querier : this.queriers) {
            activities.addAll(querier.getUserInstanceTasks(userId, instanceUUID, taskState));
            if (activities.isEmpty()) continue;
            return activities;
        }
        return activities;
    }

    @Override
    public Set<TaskInstance> getUserTasks(String userId, ActivityState taskState) {
        HashSet<TaskInstance> activities = new HashSet<TaskInstance>();
        for (Querier querier : this.queriers) {
            activities.addAll(querier.getUserTasks(userId, taskState));
        }
        return activities;
    }

    @Override
    public Set<TaskInstance> getUserTasks(String userId, Collection<ActivityState> taskStates) {
        HashSet<TaskInstance> activities = new HashSet<TaskInstance>();
        for (Querier querier : this.queriers) {
            activities.addAll(querier.getUserTasks(userId, taskStates));
        }
        return activities;
    }

    @Override
    public InternalActivityDefinition getActivity(ActivityDefinitionUUID activityDefinitionUUID) {
        for (Querier querier : this.queriers) {
            InternalActivityDefinition activity = querier.getActivity(activityDefinitionUUID);
            if (activity == null) continue;
            return activity;
        }
        return null;
    }

    @Override
    public int getNumberOfUserOpenSteps(String userId) {
        int openSteps = 0;
        for (Querier querier : this.queriers) {
            openSteps += querier.getNumberOfUserOpenSteps(userId);
        }
        return openSteps;
    }

    @Override
    public List<Integer> getNumberOfFinishedCasesPerDay(Date since, Date to) {
        ArrayList<Integer> finishedCases = new ArrayList<Integer>();
        for (Querier querier : this.queriers) {
            int i;
            List<Integer> finishedList = querier.getNumberOfFinishedCasesPerDay(since, to);
            if (finishedCases.isEmpty()) {
                for (i = 0; i < finishedList.size(); ++i) {
                    finishedCases.add(finishedList.get(i));
                }
                continue;
            }
            for (i = 0; i < finishedList.size(); ++i) {
                finishedCases.set(i, finishedList.get(i) + (Integer)finishedCases.get(i));
            }
        }
        return finishedCases;
    }

    @Override
    public List<Integer> getNumberOfExecutingCasesPerDay(Date since, Date to) {
        ArrayList<Integer> executingCases = new ArrayList<Integer>();
        for (Querier querier : this.queriers) {
            int i;
            List<Integer> executingList = querier.getNumberOfExecutingCasesPerDay(since, to);
            if (executingCases.isEmpty()) {
                for (i = 0; i < executingList.size(); ++i) {
                    executingCases.add(executingList.get(i));
                }
                continue;
            }
            for (i = 0; i < executingList.size(); ++i) {
                executingCases.set(i, executingList.get(i) + (Integer)executingCases.get(i));
            }
        }
        return executingCases;
    }

    @Override
    public List<Integer> getNumberOfOpenStepsPerDay(Date since, Date to) {
        ArrayList<Integer> opensteps = new ArrayList<Integer>();
        for (Querier querier : this.queriers) {
            int i;
            List<Integer> openList = querier.getNumberOfOpenStepsPerDay(since, to);
            if (opensteps.isEmpty()) {
                for (i = 0; i < openList.size(); ++i) {
                    opensteps.add(openList.get(i));
                }
                continue;
            }
            for (i = 0; i < openList.size(); ++i) {
                opensteps.set(i, openList.get(i) + (Integer)opensteps.get(i));
            }
        }
        return opensteps;
    }

    @Override
    public int getNumberOfOverdueSteps(Date currentDate) {
        int openSteps = 0;
        for (Querier querier : this.queriers) {
            openSteps += querier.getNumberOfOverdueSteps(currentDate);
        }
        return openSteps;
    }

    @Override
    public int getNumberOfStepsAtRisk(Date currentDate, Date atRisk) {
        int openSteps = 0;
        for (Querier querier : this.queriers) {
            openSteps += querier.getNumberOfStepsAtRisk(currentDate, atRisk);
        }
        return openSteps;
    }

    @Override
    public int getNumberOfOpenSteps() {
        int openSteps = 0;
        for (Querier querier : this.queriers) {
            openSteps += querier.getNumberOfOpenSteps();
        }
        return openSteps;
    }

    @Override
    public int getNumberOfUserOverdueSteps(String userId, Date currentDate) {
        int openSteps = 0;
        for (Querier querier : this.queriers) {
            openSteps += querier.getNumberOfUserOverdueSteps(userId, currentDate);
        }
        return openSteps;
    }

    @Override
    public int getNumberOfUserStepsAtRisk(String userId, Date currentDate, Date atRisk) {
        int stepsAtRisk = 0;
        for (Querier querier : this.queriers) {
            stepsAtRisk += querier.getNumberOfUserStepsAtRisk(userId, currentDate, atRisk);
        }
        return stepsAtRisk;
    }

    @Override
    public int getNumberOfFinishedSteps(int priority, Date since) {
        int finishedSteps = 0;
        for (Querier querier : this.queriers) {
            finishedSteps += querier.getNumberOfFinishedSteps(priority, since);
        }
        return finishedSteps;
    }

    @Override
    public int getNumberOfOpenSteps(int priority) {
        int openSteps = 0;
        for (Querier querier : this.queriers) {
            openSteps += querier.getNumberOfOpenSteps(priority);
        }
        return openSteps;
    }

    @Override
    public int getNumberOfUserFinishedSteps(String userId, int priority, Date since) {
        int finishedSteps = 0;
        for (Querier querier : this.queriers) {
            finishedSteps += querier.getNumberOfUserFinishedSteps(userId, priority, since);
        }
        return finishedSteps;
    }

    @Override
    public int getNumberOfUserOpenSteps(String userId, int priority) {
        int openSteps = 0;
        for (Querier querier : this.queriers) {
            openSteps += querier.getNumberOfUserOpenSteps(userId, priority);
        }
        return openSteps;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs) {
        HashSet<InternalProcessDefinition> processes = new HashSet<InternalProcessDefinition>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessDefinition> temp = querier.getProcesses(definitionUUIDs);
            if (temp == null) continue;
            processes.addAll(temp);
        }
        return processes;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs, ProcessDefinition.ProcessState processState) {
        HashSet<InternalProcessDefinition> processes = new HashSet<InternalProcessDefinition>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessDefinition> temp = querier.getProcesses(definitionUUIDs, processState);
            if (temp == null) continue;
            processes.addAll(temp);
        }
        return processes;
    }

    @Override
    public InternalProcessDefinition getLastDeployedProcess(Set<ProcessDefinitionUUID> definitionUUIDs, ProcessDefinition.ProcessState processState) {
        Misc.checkArgsNotNull(new Object[]{processState});
        Set<InternalProcessDefinition> processes = this.getProcesses(definitionUUIDs, processState);
        InternalProcessDefinition lastProcess = null;
        for (InternalProcessDefinition process : processes) {
            if (lastProcess == null) {
                lastProcess = process;
                continue;
            }
            if (!process.getDeployedDate().after(lastProcess.getDeployedDate())) continue;
            lastProcess = process;
        }
        return lastProcess;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getProcessInstances(definitionUUIDs));
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId, Set<ProcessDefinitionUUID> definitionUUIDs) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getUserInstances(userId, definitionUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public int getNumberOfProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        int nb = 0;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfProcessInstances(definitionUUIDs);
        }
        return nb;
    }

    @Override
    public int getNumberOfParentProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        int nb = 0;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfParentProcessInstances(definitionUUIDs);
        }
        return nb;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithTaskState(Collection<ActivityState> activityStates, Set<ProcessDefinitionUUID> definitionUUIDs) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getProcessInstancesWithTaskState(activityStates, definitionUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithInstanceStates(Collection<InstanceState> instanceStates, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getProcessInstancesWithInstanceStates(instanceStates, visibleProcessUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public TaskInstance getOneTask(String userId, ActivityState taskState, Set<ProcessDefinitionUUID> definitionUUIDs) {
        for (Querier querier : this.queriers) {
            TaskInstance task = querier.getOneTask(userId, taskState, definitionUUIDs);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    @Override
    public Set<TaskInstance> getUserTasks(String userId, ActivityState taskState, Set<ProcessDefinitionUUID> definitionUUIDs) {
        HashSet<TaskInstance> activities = new HashSet<TaskInstance>();
        for (Querier querier : this.queriers) {
            activities.addAll(querier.getUserTasks(userId, taskState, definitionUUIDs));
        }
        return activities;
    }

    @Override
    public int getNumberOfActivityInstanceComments(ActivityInstanceUUID activityUUID) {
        int comments = 0;
        for (Querier querier : this.queriers) {
            comments += querier.getNumberOfActivityInstanceComments(activityUUID);
        }
        return comments;
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            Set<InternalProcessInstance> tmp = querier.getUserInstances(userId);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentUserInstances(String userId, int fromIndex, int pageSize) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentUserInstances(userId, fromIndex, pageSize);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentUserInstances(String userId, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> querierInstances = querier.getParentUserInstances(userId, startingIndex, pageSize, pagingCriterion);
            if (querierInstances == null || querierInstances.isEmpty()) continue;
            processInsts.addAll(querierInstances);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithActiveUser(userId, fromIndex, pageSize, visibleProcessUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String userId, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> querierProcessInsts = querier.getParentProcessInstancesWithActiveUser(userId, startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
            if (querierProcessInsts == null || querierProcessInsts.isEmpty()) continue;
            processInsts.addAll(querierProcessInsts);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String userId, int fromIndex, int pageSize) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithActiveUser(userId, fromIndex, pageSize);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String userId, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> querierProcessInsts = querier.getParentProcessInstancesWithActiveUser(userId, startingIndex, pageSize, pagingCriterion);
            if (querierProcessInsts == null || querierProcessInsts.isEmpty()) continue;
            processInsts.addAll(querierProcessInsts);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize, visibleProcessUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk, int startingIndex, int pageSize) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize, pagingCriterion);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithOverdueTasks(String userId, Date currentDate, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithOverdueTasks(userId, currentDate, startingIndex, pageSize, visibleProcessUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithOverdueTasks(String userId, Date currentDate, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> querierInstances = querier.getParentProcessInstancesWithOverdueTasks(userId, currentDate, startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
            if (querierInstances == null || querierInstances.isEmpty()) continue;
            processInsts.addAll(querierInstances);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithOverdueTasks(String userId, Date currentDate, int startingIndex, int pageSize) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithOverdueTasks(userId, currentDate, startingIndex, pageSize);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithOverdueTasks(String userId, Date currentDate, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithOverdueTasks(userId, currentDate, startingIndex, pageSize, pagingCriterion);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize, visibleProcessUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithInvolvedUser(String userId, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithInvolvedUser(userId, startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithInvolvedUser(String userId, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentProcessInstancesWithInvolvedUser(userId, startingIndex, pageSize, pagingCriterion);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentUserInstances(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> definitionUUIDs) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentUserInstances(userId, fromIndex, pageSize, definitionUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentUserInstances(String userId, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> definitionUUIDs, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            List<InternalProcessInstance> tmp = querier.getParentUserInstances(userId, startingIndex, pageSize, definitionUUIDs, pagingCriterion);
            if (tmp == null || tmp.isEmpty()) continue;
            processInsts.addAll(tmp);
        }
        return processInsts;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUser(String userId, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        Integer result = 0;
        for (Querier querier : this.queriers) {
            result = result + querier.getNumberOfParentProcessInstancesWithActiveUser(userId, visibleProcessUUIDs);
        }
        return result;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUser(String userId) {
        Integer result = 0;
        for (Querier querier : this.queriers) {
            result = result + querier.getNumberOfParentProcessInstancesWithActiveUser(userId);
        }
        return result;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        Integer result = 0;
        for (Querier querier : this.queriers) {
            result = result + querier.getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk);
        }
        return result;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk) {
        Integer result = 0;
        for (Querier querier : this.queriers) {
            result = result + querier.getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk);
        }
        return result;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithOverdueTasks(String userId, Date currentDate, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        Integer result = 0;
        for (Querier querier : this.queriers) {
            result = result + querier.getNumberOfParentProcessInstancesWithOverdueTasks(userId, currentDate, visibleProcessUUIDs);
        }
        return result;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithOverdueTasks(String userId, Date currentDate) {
        Integer result = 0;
        for (Querier querier : this.queriers) {
            result = result + querier.getNumberOfParentProcessInstancesWithOverdueTasks(userId, currentDate);
        }
        return result;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUser(String userId, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        Integer result = 0;
        for (Querier querier : this.queriers) {
            result = result + querier.getNumberOfParentProcessInstancesWithInvolvedUser(userId, visibleProcessUUIDs);
        }
        return result;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUser(String userId) {
        Integer result = 0;
        for (Querier querier : this.queriers) {
            result = result + querier.getNumberOfParentProcessInstancesWithInvolvedUser(userId);
        }
        return result;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithStartedBy(String userId, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        Integer result = 0;
        for (Querier querier : this.queriers) {
            result = result + querier.getNumberOfParentProcessInstancesWithStartedBy(userId, visibleProcessUUIDs);
        }
        return result;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithStartedBy(String userId) {
        Integer result = 0;
        for (Querier querier : this.queriers) {
            result = result + querier.getNumberOfParentProcessInstancesWithStartedBy(userId);
        }
        return result;
    }

    @Override
    public Map<ActivityInstanceUUID, Integer> getNumberOfActivityInstanceComments(Set<ActivityInstanceUUID> activityUUIDs) {
        HashMap<ActivityInstanceUUID, Integer> result = new HashMap<ActivityInstanceUUID, Integer>();
        for (Querier querier : this.queriers) {
            result.putAll(querier.getNumberOfActivityInstanceComments(activityUUIDs));
        }
        return result;
    }

    @Override
    public int getNumberOfComments(ProcessInstanceUUID instanceUUID) {
        int comments = 0;
        for (Querier querier : this.queriers) {
            comments += querier.getNumberOfComments(instanceUUID);
        }
        return comments;
    }

    @Override
    public List<Comment> getCommentFeed(ProcessInstanceUUID instanceUUID) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (Querier querier : this.queriers) {
            comments.addAll(querier.getCommentFeed(instanceUUID));
        }
        return comments;
    }

    @Override
    public int getNumberOfProcessInstanceComments(ProcessInstanceUUID instanceUUID) {
        int comments = 0;
        for (Querier querier : this.queriers) {
            comments += querier.getNumberOfProcessInstanceComments(instanceUUID);
        }
        return comments;
    }

    @Override
    public List<Comment> getProcessInstanceCommentFeed(ProcessInstanceUUID instanceUUID) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (Querier querier : this.queriers) {
            comments.addAll(querier.getProcessInstanceCommentFeed(instanceUUID));
        }
        return comments;
    }

    @Override
    public List<Comment> getActivityInstanceCommentFeed(ActivityInstanceUUID activityUUID) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (Querier querier : this.queriers) {
            comments.addAll(querier.getActivityInstanceCommentFeed(activityUUID));
        }
        return comments;
    }

    @Override
    public Set<ProcessDefinitionUUID> getAllProcessDefinitionUUIDs() {
        HashSet<ProcessDefinitionUUID> set = new HashSet<ProcessDefinitionUUID>();
        for (Querier querier : this.queriers) {
            Set<ProcessDefinitionUUID> tmp = querier.getAllProcessDefinitionUUIDs();
            if (tmp == null || tmp.isEmpty()) continue;
            set.addAll(tmp);
        }
        return set;
    }

    @Override
    public Set<ProcessDefinitionUUID> getAllProcessDefinitionUUIDsExcept(Set<ProcessDefinitionUUID> processUUIDs) {
        HashSet<ProcessDefinitionUUID> set = new HashSet<ProcessDefinitionUUID>();
        for (Querier querier : this.queriers) {
            Set<ProcessDefinitionUUID> tmp = querier.getAllProcessDefinitionUUIDsExcept(processUUIDs);
            if (tmp == null || tmp.isEmpty()) continue;
            set.addAll(tmp);
        }
        return set;
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(int fromIndex, int pageSize) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processInsts.addAll(querier.getProcessInstances(fromIndex, pageSize));
            return processInsts;
        }
        for (Querier querier : this.queriers) {
            if (processInsts.size() < fromIndex + pageSize) {
                processInsts.addAll(querier.getProcessInstances(0, fromIndex + pageSize));
                continue;
            }
            this.mergePaginatedProcessInstances(processInsts, querier.getMostRecentProcessInstances(fromIndex + pageSize, this.getOldestTime(processInsts)), querier, fromIndex, pageSize, ProcessInstanceCriterion.DEFAULT);
        }
        return this.getInstancesSubset(fromIndex, pageSize, processInsts, ProcessInstanceCriterion.DEFAULT);
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(int fromIndex, int pageSize, ProcessInstanceCriterion paginCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processInsts.addAll(querier.getProcessInstances(fromIndex, pageSize, paginCriterion));
            return processInsts;
        }
        for (Querier querier : this.queriers) {
            if (processInsts.size() < fromIndex + pageSize) {
                processInsts.addAll(querier.getProcessInstances(0, fromIndex + pageSize, paginCriterion));
                continue;
            }
            this.mergePaginatedProcessInstances(processInsts, querier.getMostRecentProcessInstances(fromIndex + pageSize, this.getOldestTime(processInsts), paginCriterion), querier, fromIndex, pageSize, paginCriterion);
        }
        return this.getInstancesSubset(fromIndex, pageSize, processInsts, paginCriterion);
    }

    private long getOldestTime(List<InternalProcessInstance> processInsts) {
        return processInsts.get(processInsts.size() - 1).getLastUpdate().getTime();
    }

    private void mergePaginatedProcessInstances(List<InternalProcessInstance> processInsts, List<InternalProcessInstance> newProcessInstances, Querier querier, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        Comparator<InternalProcessInstance> comparator = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                comparator = new ProcessInstanceLastUpdateComparatorAsc();
                break;
            }
            case STARTED_DATE_ASC: {
                comparator = new ProcessInstanceStartedDateComparatorAsc();
                break;
            }
            case ENDED_DATE_ASC: {
                comparator = new ProcessInstanceEndedDateComparatorAsc();
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                comparator = new ProcessInstanceNbComparatorAsc();
                break;
            }
            case INSTANCE_UUID_ASC: {
                comparator = new ProcessInstanceUUIDComparatorAsc();
                break;
            }
            case LAST_UPDATE_DESC: {
                comparator = new ProcessInstanceLastUpdateComparator();
                break;
            }
            case STARTED_DATE_DESC: {
                comparator = new ProcessInstanceStartedDateComparatorDesc();
                break;
            }
            case ENDED_DATE_DESC: {
                comparator = new ProcessInstanceEndedDateComparatorDesc();
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                comparator = new ProcessInstanceNbComparatorDesc();
                break;
            }
            case INSTANCE_UUID_DESC: {
                comparator = new ProcessInstanceUUIDComparatorDesc();
                break;
            }
            case DEFAULT: {
                comparator = new ProcessInstanceLastUpdateComparator();
            }
        }
        if (!newProcessInstances.isEmpty()) {
            processInsts.addAll(newProcessInstances);
            Collections.sort(processInsts, comparator);
            processInsts = Misc.subList(InternalProcessInstance.class, processInsts, 0, fromIndex + pageSize);
        }
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessInstances(int maxResults, long time) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getMostRecentProcessInstances(maxResults, time));
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessInstances(int maxResults, long time, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getMostRecentProcessInstances(maxResults, time, pagingCriterion));
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentParentProcessInstances(int maxResults, long time) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getMostRecentParentProcessInstances(maxResults, time));
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentParentProcessInstances(int maxResults, long time, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getMostRecentParentProcessInstances(maxResults, time, pagingCriterion));
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstances(ProcessDefinitionUUID definitionUUID, int fromIndex, int pageSize) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getParentProcessInstances(definitionUUID, fromIndex, pageSize));
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstances(int fromIndex, int pageSize) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processInsts.addAll(querier.getParentProcessInstances(fromIndex, pageSize));
            return processInsts;
        }
        for (Querier querier : this.queriers) {
            if (processInsts.size() < fromIndex + pageSize) {
                processInsts.addAll(querier.getParentProcessInstances(0, fromIndex + pageSize));
                continue;
            }
            this.mergePaginatedProcessInstances(processInsts, querier.getMostRecentParentProcessInstances(fromIndex + pageSize, this.getOldestTime(processInsts)), querier, fromIndex, pageSize, ProcessInstanceCriterion.DEFAULT);
        }
        return this.getInstancesSubset(fromIndex, pageSize, processInsts, ProcessInstanceCriterion.DEFAULT);
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstances(int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processInsts.addAll(querier.getParentProcessInstances(fromIndex, pageSize, pagingCriterion));
            return processInsts;
        }
        for (Querier querier : this.queriers) {
            if (processInsts.size() < fromIndex + pageSize) {
                processInsts.addAll(querier.getParentProcessInstances(0, fromIndex + pageSize, pagingCriterion));
                continue;
            }
            this.mergePaginatedProcessInstances(processInsts, querier.getMostRecentParentProcessInstances(fromIndex + pageSize, this.getOldestTime(processInsts), pagingCriterion), querier, fromIndex, pageSize, pagingCriterion);
        }
        return this.getInstancesSubset(fromIndex, pageSize, processInsts, pagingCriterion);
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstances(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processInsts.addAll(querier.getParentProcessInstances(processUUIDs, fromIndex, pageSize, pagingCriterion));
            return processInsts;
        }
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getParentProcessInstances(processUUIDs, fromIndex, pageSize, pagingCriterion));
        }
        Collections.sort(processInsts, new InternalProcessInstanceComparator(pagingCriterion));
        return Misc.subList(InternalProcessInstance.class, processInsts, 0, pageSize);
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesExcept(Set<ProcessDefinitionUUID> exceptions, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        if (exceptions == null || exceptions.isEmpty()) {
            return this.getParentProcessInstances(fromIndex, pageSize, pagingCriterion);
        }
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processInsts.addAll(querier.getParentProcessInstancesExcept(exceptions, fromIndex, pageSize, pagingCriterion));
            return processInsts;
        }
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getParentProcessInstancesExcept(exceptions, fromIndex, pageSize, pagingCriterion));
        }
        Collections.sort(processInsts, new InternalProcessInstanceComparator(pagingCriterion));
        return Misc.subList(InternalProcessInstance.class, processInsts, 0, pageSize);
    }

    @Override
    public List<InternalProcessInstance> getMostRecentMatchingProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, int maxResults, long time) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getMostRecentMatchingProcessInstances(instanceUUIDs, maxResults, time));
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentMatchingProcessInstances(Set<ProcessInstanceUUID> instanceUUIDs, int maxResults, long time, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getMostRecentMatchingProcessInstances(instanceUUIDs, maxResults, time, pagingCriterion));
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, int fromIndex, int pageSize) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processInsts.addAll(querier.getProcessInstances(instanceUUIDs, fromIndex, pageSize));
            return processInsts;
        }
        for (Querier querier : this.queriers) {
            if (processInsts.size() < fromIndex + pageSize) {
                processInsts.addAll(querier.getProcessInstances(instanceUUIDs, 0, fromIndex + pageSize));
                continue;
            }
            this.mergePaginatedProcessInstances(processInsts, querier.getMostRecentMatchingProcessInstances(instanceUUIDs, fromIndex + pageSize, this.getOldestTime(processInsts)), querier, fromIndex, pageSize, ProcessInstanceCriterion.DEFAULT);
        }
        return this.getInstancesSubset(fromIndex, pageSize, processInsts, ProcessInstanceCriterion.DEFAULT);
    }

    @Override
    public List<InternalProcessInstance> getProcessInstancesWithInstanceUUIDs(Set<ProcessInstanceUUID> instanceUUIDs, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processInsts.addAll(querier.getProcessInstancesWithInstanceUUIDs(instanceUUIDs, fromIndex, pageSize, pagingCriterion));
            return processInsts;
        }
        for (Querier querier : this.queriers) {
            if (processInsts.size() < fromIndex + pageSize) {
                processInsts.addAll(querier.getProcessInstancesWithInstanceUUIDs(instanceUUIDs, 0, fromIndex + pageSize, pagingCriterion));
                continue;
            }
            this.mergePaginatedProcessInstances(processInsts, querier.getMostRecentMatchingProcessInstances(instanceUUIDs, fromIndex + pageSize, this.getOldestTime(processInsts), pagingCriterion), querier, fromIndex, pageSize, pagingCriterion);
        }
        return this.getInstancesSubset(fromIndex, pageSize, processInsts, pagingCriterion);
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessesProcessInstances(Collection<ProcessDefinitionUUID> definitionUUIDs, int maxResults, long time) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getMostRecentProcessesProcessInstances(definitionUUIDs, maxResults, time));
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessesProcessInstances(Collection<ProcessDefinitionUUID> definitionUUIDs, int maxResults, long time, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        for (Querier querier : this.queriers) {
            processInsts.addAll(querier.getMostRecentProcessesProcessInstances(definitionUUIDs, maxResults, time, pagingCriterion));
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processInsts.addAll(querier.getProcessInstances(definitionUUIDs, fromIndex, pageSize));
            return processInsts;
        }
        for (Querier querier : this.queriers) {
            if (processInsts.size() < fromIndex + pageSize) {
                processInsts.addAll(querier.getProcessInstances(definitionUUIDs, 0, fromIndex + pageSize));
                continue;
            }
            this.mergePaginatedProcessInstances(processInsts, querier.getMostRecentProcessesProcessInstances(definitionUUIDs, fromIndex + pageSize, this.getOldestTime(processInsts)), querier, fromIndex, pageSize, ProcessInstanceCriterion.DEFAULT);
        }
        return this.getInstancesSubset(fromIndex, pageSize, processInsts, ProcessInstanceCriterion.DEFAULT);
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<InternalProcessInstance> processInsts = new ArrayList<InternalProcessInstance>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processInsts.addAll(querier.getProcessInstances(definitionUUIDs, fromIndex, pageSize, pagingCriterion));
            return processInsts;
        }
        for (Querier querier : this.queriers) {
            if (processInsts.size() < fromIndex + pageSize) {
                processInsts.addAll(querier.getProcessInstances(definitionUUIDs, 0, fromIndex + pageSize, pagingCriterion));
                continue;
            }
            this.mergePaginatedProcessInstances(processInsts, querier.getMostRecentProcessesProcessInstances(definitionUUIDs, fromIndex + pageSize, this.getOldestTime(processInsts), pagingCriterion), querier, fromIndex, pageSize, pagingCriterion);
        }
        return this.getInstancesSubset(fromIndex, pageSize, processInsts, pagingCriterion);
    }

    private List<InternalProcessInstance> getInstancesSubset(int fromIndex, int pageSize, List<InternalProcessInstance> processInstances, ProcessInstanceCriterion pagingCriterion) {
        if (processInstances == null || processInstances.isEmpty() || fromIndex > processInstances.size()) {
            return Collections.emptyList();
        }
        int toIndex = fromIndex + pageSize;
        if (toIndex > processInstances.size()) {
            toIndex = processInstances.size();
        }
        Comparator<InternalProcessInstance> comparator = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                comparator = new ProcessInstanceLastUpdateComparatorAsc();
                break;
            }
            case STARTED_DATE_ASC: {
                comparator = new ProcessInstanceStartedDateComparatorAsc();
                break;
            }
            case ENDED_DATE_ASC: {
                comparator = new ProcessInstanceEndedDateComparatorAsc();
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                comparator = new ProcessInstanceNbComparatorAsc();
                break;
            }
            case INSTANCE_UUID_ASC: {
                comparator = new ProcessInstanceUUIDComparatorAsc();
                break;
            }
            case LAST_UPDATE_DESC: {
                comparator = new ProcessInstanceLastUpdateComparator();
                break;
            }
            case STARTED_DATE_DESC: {
                comparator = new ProcessInstanceStartedDateComparatorDesc();
                break;
            }
            case ENDED_DATE_DESC: {
                comparator = new ProcessInstanceEndedDateComparatorDesc();
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                comparator = new ProcessInstanceNbComparatorDesc();
                break;
            }
            case INSTANCE_UUID_DESC: {
                comparator = new ProcessInstanceUUIDComparatorDesc();
                break;
            }
            case DEFAULT: {
                comparator = new ProcessInstanceLastUpdateComparator();
            }
        }
        Collections.sort(processInstances, comparator);
        return Misc.subList(InternalProcessInstance.class, processInstances, fromIndex, toIndex);
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(int fromIndex, int pageSize) {
        ArrayList<InternalProcessDefinition> processes = new ArrayList<InternalProcessDefinition>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processes.addAll(querier.getProcesses(fromIndex, pageSize));
            return processes;
        }
        for (Querier querier : this.queriers) {
            processes.addAll(querier.getProcesses(0, fromIndex + pageSize));
        }
        return this.getProcessesSubset(fromIndex, pageSize, processes, ProcessDefinitionCriterion.DEFAULT);
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion) {
        ArrayList<InternalProcessDefinition> processes = new ArrayList<InternalProcessDefinition>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processes.addAll(querier.getProcesses(fromIndex, pageSize, pagingCriterion));
            return processes;
        }
        for (Querier querier : this.queriers) {
            processes.addAll(querier.getProcesses(0, fromIndex + pageSize, pagingCriterion));
        }
        return this.getProcessesSubset(fromIndex, pageSize, processes, pagingCriterion);
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize) {
        ArrayList<InternalProcessDefinition> processes = new ArrayList<InternalProcessDefinition>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processes.addAll(querier.getProcesses(definitionUUIDs, fromIndex, pageSize));
            return processes;
        }
        for (Querier querier : this.queriers) {
            processes.addAll(querier.getProcesses(definitionUUIDs, 0, fromIndex + pageSize));
        }
        return this.getProcessesSubset(fromIndex, pageSize, processes, ProcessDefinitionCriterion.DEFAULT);
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion) {
        ArrayList<InternalProcessDefinition> processes = new ArrayList<InternalProcessDefinition>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processes.addAll(querier.getProcesses(definitionUUIDs, fromIndex, pageSize, pagingCriterion));
            return processes;
        }
        for (Querier querier : this.queriers) {
            processes.addAll(querier.getProcesses(definitionUUIDs, 0, fromIndex + pageSize, pagingCriterion));
        }
        return this.getProcessesSubset(fromIndex, pageSize, processes, pagingCriterion);
    }

    @Override
    public List<InternalProcessDefinition> getProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize) {
        ArrayList<InternalProcessDefinition> processes = new ArrayList<InternalProcessDefinition>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processes.addAll(querier.getProcessesExcept(processUUIDs, fromIndex, pageSize));
            return processes;
        }
        for (Querier querier : this.queriers) {
            processes.addAll(querier.getProcessesExcept(processUUIDs, 0, fromIndex + pageSize));
        }
        return this.getProcessesSubset(fromIndex, pageSize, processes, ProcessDefinitionCriterion.DEFAULT);
    }

    @Override
    public List<InternalProcessDefinition> getProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion) {
        ArrayList<InternalProcessDefinition> processes = new ArrayList<InternalProcessDefinition>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            processes.addAll(querier.getProcessesExcept(processUUIDs, fromIndex, pageSize, pagingCriterion));
            return processes;
        }
        for (Querier querier : this.queriers) {
            processes.addAll(querier.getProcessesExcept(processUUIDs, 0, fromIndex + pageSize, pagingCriterion));
        }
        return this.getProcessesSubset(fromIndex, pageSize, processes, pagingCriterion);
    }

    @Override
    public Set<Category> getCategories(Collection<String> categoryNames) {
        HashSet<Category> result = new HashSet<Category>();
        for (Querier querier : this.queriers) {
            result.addAll(querier.getCategories(categoryNames));
        }
        return result;
    }

    @Override
    public Set<Category> getAllCategories() {
        HashSet<Category> result = new HashSet<Category>();
        for (Querier querier : this.queriers) {
            result.addAll(querier.getAllCategories());
        }
        return result;
    }

    @Override
    public Set<Category> getAllCategoriesExcept(Set<String> uuids) {
        HashSet<Category> result = new HashSet<Category>();
        for (Querier querier : this.queriers) {
            result.addAll(querier.getAllCategoriesExcept(uuids));
        }
        return result;
    }

    @Override
    public Set<CategoryImpl> getCategoriesByUUIDs(Set<CategoryUUID> uuids) {
        HashSet<CategoryImpl> result = new HashSet<CategoryImpl>();
        for (Querier querier : this.queriers) {
            result.addAll(querier.getCategoriesByUUIDs(uuids));
        }
        return result;
    }

    @Override
    public CategoryImpl getCategoryByUUID(String uuid) {
        CategoryImpl category = null;
        for (int i = 0; category == null && i < this.queriers.size(); ++i) {
            Querier querier = this.queriers.get(i);
            category = querier.getCategoryByUUID(uuid);
        }
        return category;
    }

    @Override
    public Set<ProcessDefinitionUUID> getProcessUUIDsFromCategory(String category) {
        HashSet<ProcessDefinitionUUID> result = new HashSet<ProcessDefinitionUUID>();
        for (Querier querier : this.queriers) {
            result.addAll(querier.getProcessUUIDsFromCategory(category));
        }
        return result;
    }

    private List<InternalProcessDefinition> getProcessesSubset(int fromIndex, int pageSize, List<InternalProcessDefinition> processes, ProcessDefinitionCriterion pagingCriterion) {
        int toIndex = fromIndex + pageSize;
        if (toIndex > processes.size()) {
            toIndex = processes.size();
        }
        Collections.sort(processes, new InternalProcessDefinitionComparator(pagingCriterion));
        return Misc.subList(InternalProcessDefinition.class, processes, fromIndex, toIndex);
    }

    @Override
    public List<Object> search(SearchQueryBuilder query, int firstResult, int maxResults, Class<?> indexClass) {
        List<Object> entities = new ArrayList<Object>();
        if (this.queriers.size() == 1) {
            Querier querier = this.queriers.get(0);
            entities.addAll(querier.search(query, firstResult, maxResults, indexClass));
        } else {
            for (Querier querier : this.queriers) {
                List<Object> temp = querier.search(query, firstResult, maxResults, indexClass);
                entities.addAll(temp);
                if (entities.size() <= maxResults) continue;
                entities = entities.subList(firstResult, maxResults);
                break;
            }
        }
        return entities;
    }

    @Override
    public int search(SearchQueryBuilder query, Class<?> indexClass) {
        int count = 0;
        for (Querier querier : this.queriers) {
            count += querier.search(query, indexClass);
        }
        return count;
    }

    @Override
    public Set<ActivityDefinitionUUID> getProcessTaskUUIDs(ProcessDefinitionUUID definitionUUID) {
        HashSet<ActivityDefinitionUUID> result = new HashSet<ActivityDefinitionUUID>();
        for (Querier querier : this.queriers) {
            result.addAll(querier.getProcessTaskUUIDs(definitionUUID));
        }
        return result;
    }

    @Override
    public boolean processExists(ProcessDefinitionUUID definitionUUID) {
        for (Querier querier : this.queriers) {
            boolean querierExists = querier.processExists(definitionUUID);
            if (!querierExists) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Long> getProcessInstancesDuration(Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getProcessInstancesDuration(since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public List<Long> getProcessInstancesDuration(ProcessDefinitionUUID processUUID, Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getProcessInstancesDuration(processUUID, since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public List<Long> getProcessInstancesDurationFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getProcessInstancesDurationFromProcessUUIDs(processUUIDs, since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(Date since, Date until) {
        ArrayList<Long> executionTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            executionTimes.addAll(querier.getActivityInstancesExecutionTime(since, until));
        }
        Collections.sort(executionTimes);
        return executionTimes;
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(ProcessDefinitionUUID processUUID, Date since, Date until) {
        ArrayList<Long> executionTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            executionTimes.addAll(querier.getActivityInstancesExecutionTime(processUUID, since, until));
        }
        Collections.sort(executionTimes);
        return executionTimes;
    }

    @Override
    public List<Long> getActivityInstancesExecutionTimeFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        ArrayList<Long> executionTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            executionTimes.addAll(querier.getActivityInstancesExecutionTimeFromProcessUUIDs(processUUIDs, since, until));
        }
        Collections.sort(executionTimes);
        return executionTimes;
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(ActivityDefinitionUUID activityUUID, Date since, Date until) {
        ArrayList<Long> executionTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            executionTimes.addAll(querier.getActivityInstancesExecutionTime(activityUUID, since, until));
        }
        Collections.sort(executionTimes);
        return executionTimes;
    }

    @Override
    public List<Long> getActivityInstancesExecutionTimeFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until) {
        ArrayList<Long> executionTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            executionTimes.addAll(querier.getActivityInstancesExecutionTimeFromActivityUUIDs(activityUUIDs, since, until));
        }
        Collections.sort(executionTimes);
        return executionTimes;
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(Date since, Date until) {
        ArrayList<Long> waitingTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            waitingTimes.addAll(querier.getTaskInstancesWaitingTime(since, until));
        }
        Collections.sort(waitingTimes);
        return waitingTimes;
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(ProcessDefinitionUUID processUUID, Date since, Date until) {
        ArrayList<Long> waitingTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            waitingTimes.addAll(querier.getTaskInstancesWaitingTime(processUUID, since, until));
        }
        Collections.sort(waitingTimes);
        return waitingTimes;
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        ArrayList<Long> waitingTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            waitingTimes.addAll(querier.getTaskInstancesWaitingTimeFromProcessUUIDs(processUUIDs, since, until));
        }
        Collections.sort(waitingTimes);
        return waitingTimes;
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(ActivityDefinitionUUID taskUUID, Date since, Date until) {
        ArrayList<Long> waitingTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            waitingTimes.addAll(querier.getTaskInstancesWaitingTime(taskUUID, since, until));
        }
        Collections.sort(waitingTimes);
        return waitingTimes;
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeFromTaskUUIDs(Set<ActivityDefinitionUUID> taskUUIDs, Date since, Date until) {
        ArrayList<Long> waitingTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            waitingTimes.addAll(querier.getTaskInstancesWaitingTimeFromTaskUUIDs(taskUUIDs, since, until));
        }
        Collections.sort(waitingTimes);
        return waitingTimes;
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, Date since, Date until) {
        ArrayList<Long> waitingTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            waitingTimes.addAll(querier.getTaskInstancesWaitingTimeOfUser(username, since, until));
        }
        Collections.sort(waitingTimes);
        return waitingTimes;
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, ProcessDefinitionUUID processUUID, Date since, Date until) {
        ArrayList<Long> waitingTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            waitingTimes.addAll(querier.getTaskInstancesWaitingTimeOfUser(username, processUUID, since, until));
        }
        Collections.sort(waitingTimes);
        return waitingTimes;
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUserFromProcessUUIDs(String username, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        ArrayList<Long> waitingTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            waitingTimes.addAll(querier.getTaskInstancesWaitingTimeOfUserFromProcessUUIDs(username, processUUIDs, since, until));
        }
        Collections.sort(waitingTimes);
        return waitingTimes;
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, ActivityDefinitionUUID taskUUID, Date since, Date until) {
        ArrayList<Long> waitingTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            waitingTimes.addAll(querier.getTaskInstancesWaitingTimeOfUser(username, taskUUID, since, until));
        }
        Collections.sort(waitingTimes);
        return waitingTimes;
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUserFromTaskUUIDs(String username, Set<ActivityDefinitionUUID> taskUUIDs, Date since, Date until) {
        ArrayList<Long> waitingTimes = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            waitingTimes.addAll(querier.getTaskInstancesWaitingTimeOfUserFromTaskUUIDs(username, taskUUIDs, since, until));
        }
        Collections.sort(waitingTimes);
        return waitingTimes;
    }

    @Override
    public List<Long> getActivityInstancesDuration(Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getActivityInstancesDuration(since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public List<Long> getActivityInstancesDuration(ProcessDefinitionUUID processUUID, Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getActivityInstancesDuration(processUUID, since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public List<Long> getActivityInstancesDurationFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getActivityInstancesDurationFromProcessUUIDs(processUUIDs, since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public List<Long> getActivityInstancesDuration(ActivityDefinitionUUID activityUUID, Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getActivityInstancesDuration(activityUUID, since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public List<Long> getActivityInstancesDurationFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getActivityInstancesDurationFromActivityUUIDs(activityUUIDs, since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityType(ActivityDefinition.Type activityType, Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getActivityInstancesDurationByActivityType(activityType, since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityType(ActivityDefinition.Type activityType, ProcessDefinitionUUID processUUID, Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getActivityInstancesDurationByActivityType(activityType, processUUID, since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityTypeFromProcessUUIDs(ActivityDefinition.Type activityType, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        ArrayList<Long> durations = new ArrayList<Long>();
        if (this.queriers.size() == 1) {
            return this.queriers.get(0).getActivityInstancesDurationByActivityTypeFromProcessUUIDs(activityType, processUUIDs, since, until);
        }
        for (Querier querier : this.queriers) {
            durations.addAll(querier.getActivityInstancesDurationByActivityTypeFromProcessUUIDs(activityType, processUUIDs, since, until));
        }
        Collections.sort(durations);
        return durations;
    }

    @Override
    public long getNumberOfCreatedProcessInstances(Date since, Date until) {
        long nb = 0L;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfCreatedProcessInstances(since, until);
        }
        return nb;
    }

    @Override
    public long getNumberOfCreatedProcessInstances(ProcessDefinitionUUID processUUID, Date since, Date until) {
        long nb = 0L;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfCreatedProcessInstances(processUUID, since, until);
        }
        return nb;
    }

    @Override
    public long getNumberOfCreatedActivityInstances(Date since, Date until) {
        long nb = 0L;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfCreatedActivityInstances(since, until);
        }
        return nb;
    }

    @Override
    public long getNumberOfCreatedActivityInstances(ProcessDefinitionUUID processUUID, Date since, Date until) {
        long nb = 0L;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfCreatedActivityInstances(processUUID, since, until);
        }
        return nb;
    }

    @Override
    public long getNumberOfCreatedActivityInstancesFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        long nb = 0L;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfCreatedActivityInstancesFromProcessUUIDs(processUUIDs, since, until);
        }
        return nb;
    }

    @Override
    public long getNumberOfCreatedActivityInstances(ActivityDefinitionUUID activityUUID, Date since, Date until) {
        long nb = 0L;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfCreatedActivityInstances(activityUUID, since, until);
        }
        return nb;
    }

    @Override
    public long getNumberOfCreatedActivityInstancesFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until) {
        long nb = 0L;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfCreatedActivityInstancesFromActivityUUIDs(activityUUIDs, since, until);
        }
        return nb;
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityType(ActivityDefinition.Type activityType, Date since, Date until) {
        long nb = 0L;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfCreatedActivityInstancesByActivityType(activityType, since, until);
        }
        return nb;
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityType(ActivityDefinition.Type activityType, ProcessDefinitionUUID processUUID, Date since, Date until) {
        long nb = 0L;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfCreatedActivityInstancesByActivityType(activityType, processUUID, since, until);
        }
        return nb;
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUIDs(ActivityDefinition.Type activityType, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        long nb = 0L;
        for (Querier querier : this.queriers) {
            nb += querier.getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUIDs(activityType, processUUIDs, since, until);
        }
        return nb;
    }

    @Override
    public boolean containsOtherActiveActivities(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID) {
        for (Querier querier : this.queriers) {
            if (!querier.containsOtherActiveActivities(instanceUUID, activityUUID)) continue;
            return true;
        }
        return false;
    }
}

