/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.type.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.ow2.bonita.type.Converter;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

public class SerializableToBytesConverter
implements Converter {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean supports(Object value) {
        return value == null || Serializable.class.isAssignableFrom(value.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object convert(Object o) {
        byte[] bytes = null;
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            try {
                String message = ExceptionManager.getInstance().getFullMessage("bp_STBC_1", o);
                throw new BonitaRuntimeException(message, e);
            }
            catch (Throwable throwable) {
                try {
                    if (oos == null) throw throwable;
                    oos.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    String message = ExceptionManager.getInstance().getFullMessage("bp_STBC_1", o);
                    throw new BonitaRuntimeException(message, e2);
                }
            }
        }
        try {
            if (oos == null) return bytes;
            oos.close();
            return bytes;
        }
        catch (IOException e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_STBC_1", o);
            throw new BonitaRuntimeException(message, e);
        }
    }

    @Override
    public Object revert(Object o) {
        byte[] bytes = (byte[])o;
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String className = desc.getName();
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return Class.forName(className, true, classLoader);
                }
            };
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_STBC_2", new Object[0]);
            throw new BonitaRuntimeException(message, e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    String message = ExceptionManager.getInstance().getFullMessage("bp_STBC_2", new Object[0]);
                    throw new BonitaRuntimeException(message, e);
                }
            }
        }
    }
}

