/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.element.impl.BusinessArchiveImpl;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.util.BonitaConstants;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessBuilder;

public final class BusinessArchiveFactory {
    private BusinessArchiveFactory() {
    }

    public static void generateBusinessArchiveFile(File barFile, ProcessDefinition process, Map<String, byte[]> resources, Class<?> ... classes) throws IOException, ClassNotFoundException {
        Misc.checkArgsNotNull(barFile);
        byte[] barContent = BusinessArchiveFactory.getBusinessArchiveContent(process, resources, classes);
        BusinessArchiveFactory.generateBusinessArchiveFile(barFile, barContent);
    }

    public static void generateBusinessArchiveFile(File barFile, BusinessArchive businessArchive) throws IOException {
        Misc.checkArgsNotNull(barFile, businessArchive);
        byte[] barContent = Misc.generateJar(businessArchive.getResources());
        BusinessArchiveFactory.generateBusinessArchiveFile(barFile, barContent);
    }

    private static void generateBusinessArchiveFile(File barFile, byte[] barContent) throws IOException {
        Misc.checkArgsNotNull(barFile, barContent);
        Misc.write(barFile, barContent);
    }

    public static BusinessArchive getBusinessArchive(URL businessArchiveFileUrl) throws URISyntaxException, IOException, ClassNotFoundException {
        return BusinessArchiveFactory.getBusinessArchive(new File(businessArchiveFileUrl.toURI()));
    }

    public static BusinessArchive getBusinessArchive(Map<String, byte[]> resources) throws IOException, ClassNotFoundException {
        return BusinessArchiveFactory.getBusinessArchive(resources, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusinessArchive getBusinessArchive(Map<String, byte[]> resources, boolean deserializeProcess) throws IOException, ClassNotFoundException {
        HashMap<String, byte[]> newResources = new HashMap<String, byte[]>();
        ProcessDefinition process = null;
        for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
            File tempDir;
            if (resource.getKey().endsWith(".xpdl")) {
                if (!deserializeProcess) continue;
                tempDir = Misc.createDirectories(BonitaConstants.getTemporaryFolder());
                File xpdlFile = Misc.createTempFile("xpdl", null, tempDir);
                Misc.getFile(xpdlFile, resource.getValue());
                try {
                    process = ProcessBuilder.createProcessFromXpdlFile(xpdlFile.toURL());
                    continue;
                }
                finally {
                    xpdlFile.delete();
                    continue;
                }
            }
            if (resource.getKey().equals("process-def.xml")) {
                if (!deserializeProcess) continue;
                tempDir = Misc.createDirectories(BonitaConstants.getTemporaryFolder());
                File xmlDefFile = Misc.createTempFile("xmlDef", null, tempDir);
                Misc.getFile(xmlDefFile, resource.getValue());
                Properties contextProperties = BusinessArchiveFactory.createPropertiesFromResources(resources);
                try {
                    process = ProcessBuilder.createProcessFromXmlDefFile(xmlDefFile.toURL(), contextProperties);
                    continue;
                }
                finally {
                    xmlDefFile.delete();
                    continue;
                }
            }
            newResources.put(resource.getKey(), resource.getValue());
        }
        return new BusinessArchiveImpl(process, newResources, new Class[0]);
    }

    public static Properties createPropertiesFromResources(Map<String, byte[]> resources) throws IOException {
        Properties res = new Properties();
        for (Map.Entry<String, byte[]> entry : resources.entrySet()) {
            if (!entry.getKey().startsWith("contexts/")) continue;
            byte[] bytes = entry.getValue();
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            Properties props = new Properties();
            props.load(stream);
            stream.close();
            res.putAll((Map<?, ?>)props);
        }
        return res;
    }

    public static BusinessArchive getBusinessArchive(File businessArchiveFile) throws IOException, ClassNotFoundException {
        return BusinessArchiveFactory.getBusinessArchive(businessArchiveFile, true);
    }

    public static BusinessArchive getBusinessArchive(File businessArchiveFile, boolean deserializeProcess) throws IOException, ClassNotFoundException {
        if (!businessArchiveFile.exists()) {
            throw new FileNotFoundException("File " + businessArchiveFile + "doesn't exists.");
        }
        byte[] fileAsBytes = Misc.getAllContentFrom(businessArchiveFile);
        Map<String, byte[]> resources = Misc.getResourcesFromZip(fileAsBytes);
        return BusinessArchiveFactory.getBusinessArchive(resources, deserializeProcess);
    }

    public static BusinessArchive getBusinessArchive(ProcessDefinition process, Class<?> ... classes) throws IOException, ClassNotFoundException {
        Misc.checkArgsNotNull(process);
        return new BusinessArchiveImpl(process, null, classes);
    }

    public static BusinessArchive getBusinessArchive(ProcessDefinition process, Map<String, byte[]> resources, Class<?> ... classes) throws IOException, ClassNotFoundException {
        Misc.checkArgsNotNull(process);
        return new BusinessArchiveImpl(process, resources, classes);
    }

    private static byte[] getBusinessArchiveContent(ProcessDefinition process, Map<String, byte[]> resources, Class<?> ... classes) throws IOException, ClassNotFoundException {
        BusinessArchive businessArchive = BusinessArchiveFactory.getBusinessArchive(process, resources, classes);
        return Misc.generateJar(businessArchive.getResources());
    }
}

