/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.transform.Transformers;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventCouple;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobBuilder;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.util.BonitaConstants;
import org.ow2.bonita.util.DbTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.IoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbMigration {
    private static final Logger LOG = LoggerFactory.getLogger(DbMigration.class);

    private DbMigration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 3) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBM_1", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        BonitaConstants.getBonitaHomeFolder();
        String domain = args[0];
        String db = args[1].toLowerCase();
        int stage = Integer.valueOf(args[2]);
        String useSearch = "bonita.search.use";
        System.setProperty("bonita.search.use", "false");
        LOG.info("Starting Migration on tenant: " + domain);
        try {
            if (stage < 2) {
                LOG.info("Stage 1: Updating history database schema...");
                DbMigration.preUpdateDatabase(domain, "hibernate-configuration:history", db);
                LOG.info("Stage 1: DONE");
            }
            if (stage < 3) {
                LOG.info("Stage 2: Updating journal database schema...");
                DbMigration.preUpdateDatabase(domain, "hibernate-configuration:core", db);
                LOG.info("Stage 2: DONE");
            }
            if (stage < 4) {
                LOG.info("Stage 3.1: Migrating asynchronous events...");
                DbMigration.migrateAsyncEvents(domain, "hibernate-configuration:core");
                LOG.info("Stage 3.1: DONE");
                LOG.info("Stage 3.2: Migrating timer events...");
                DbMigration.migrateTimerEvents(domain, "hibernate-configuration:core");
                LOG.info("Stage 3.2: DONE");
                LOG.info("Stage 3.3: Migrating deadline events...");
                DbMigration.migrateDeadlineEvents(domain, "hibernate-configuration:core");
                LOG.info("Stage 3.3: DONE");
                LOG.info("Stage 3.4: Migrating error events...");
                DbMigration.migrateErrorEvents(domain, "hibernate-configuration:core");
                LOG.info("Stage 3.4: DONE");
                LOG.info("Stage 3.5: Migrating signal events...");
                DbMigration.migrateSignalEvents(domain, "hibernate-configuration:core");
                LOG.info("Stage 3.5: DONE");
            }
            if (stage < 5) {
                LOG.info("Stage 4: Cleaning history database...");
                DbMigration.cleanDatabase(domain, "hibernate-configuration:history", db);
                DbMigration.postUpdateDatabase(domain, "hibernate-configuration:history", db);
                LOG.info("Stage 4: DONE");
            }
            if (stage < 6) {
                LOG.info("Stage 5: Cleaning journal database...");
                DbMigration.cleanDatabase(domain, "hibernate-configuration:core", db);
                DbMigration.postUpdateDatabase(domain, "hibernate-configuration:core", db);
                LOG.info("Stage 5: DONE");
            }
            LOG.info("Migration on tenant " + domain + ": DONE");
        }
        finally {
            System.clearProperty("bonita.search.use");
        }
    }

    private static void preUpdateDatabase(String domain, String configurationName, String db) throws Exception {
        String path = DbMigration.getSQLScriptPath(db, "pre");
        DbMigration.migrateDb(domain, configurationName, db, path);
    }

    private static void postUpdateDatabase(String domain, String configurationName, String db) throws Exception {
        String path = DbMigration.getSQLScriptPath(db, "post");
        DbMigration.migrateDb(domain, configurationName, db, path);
    }

    private static void cleanDatabase(String domain, String configurationName, String db) throws Exception {
        String path = DbMigration.getSQLScriptPath(db, "clean");
        DbMigration.cleanDb(domain, configurationName, db, path);
    }

    private static String getSQLScriptPath(String db, String position) {
        StringBuilder migrationScript = new StringBuilder("/migration/");
        migrationScript.append(db).append("-").append(position).append("-5.8-5.9.sql");
        return migrationScript.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanDb(String domain, String configurationName, String database, String resourcePath) throws Exception {
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(domain, configurationName.replaceAll("-configuration", "-session-factory"));
        try {
            InputStream inputStream = null;
            try {
                inputStream = DbMigration.getScriptStream(resourcePath);
                DbMigration.executeScriptStepByStep((SessionFactory)sessionFactory, inputStream, database);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        finally {
            sessionFactory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateDb(String domain, String configurationName, String database, String resourcePath) throws Exception {
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(domain, configurationName.replaceAll("-configuration", "-session-factory"));
        try {
            InputStream inputStream = null;
            try {
                inputStream = DbMigration.getScriptStream(resourcePath);
                DbMigration.executeScript((SessionFactory)sessionFactory, inputStream, database);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        finally {
            sessionFactory.close();
        }
    }

    private static InputStream getScriptStream(String resourcePath) {
        InputStream inputStream = DbMigration.class.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBM_2", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        return inputStream;
    }

    public static void executeScript(SessionFactory sessionFactory, InputStream inputStream, String db) {
        byte[] bytes = IoUtil.readBytes(inputStream);
        String scriptContent = new String(bytes);
        List<String> commands = DbMigration.getCommands(scriptContent, db);
        Session session = sessionFactory.openSession();
        session.getTransaction().begin();
        LOG.info("DB Commands Execution: " + commands.size());
        for (String command : commands) {
            LOG.info("Executing command : " + command);
            try {
                session.createSQLQuery(command).executeUpdate();
            }
            catch (Exception e) {
                LOG.error("Error while executing command: " + command, (Throwable)e);
            }
        }
        session.getTransaction().commit();
        session.close();
    }

    private static void executeScriptStepByStep(SessionFactory sessionFactory, InputStream inputStream, String db) {
        byte[] bytes = IoUtil.readBytes(inputStream);
        String scriptContent = new String(bytes);
        List<String> commands = DbMigration.getCommands(scriptContent, db);
        Session session = sessionFactory.openSession();
        LOG.info("DB Commands Execution: " + commands.size());
        for (String command : commands) {
            LOG.info("Executing command : " + command);
            try {
                session.getTransaction().begin();
                session.createSQLQuery(command).executeUpdate();
                session.getTransaction().commit();
            }
            catch (Exception e) {
                session.getTransaction().rollback();
                LOG.warn("Error while executing command: " + command, (Throwable)e);
            }
        }
        session.close();
    }

    public static List<String> getCommands(String scriptContent, String db) {
        String lastCommand;
        int index;
        String[] tmp;
        String delimiter = ";";
        if ("sqlserver".equals(db) || "sybase".equals(db)) {
            delimiter = "go";
        }
        String regex = delimiter.concat("\r?\n");
        ArrayList<String> commands = new ArrayList<String>();
        for (String command : tmp = scriptContent.split(regex)) {
            if (command.trim().length() <= 0) continue;
            commands.add(command.trim());
        }
        int lastIndex = commands.size() - 1;
        if (lastIndex >= 0 && (index = (lastCommand = (String)commands.get(lastIndex)).lastIndexOf(delimiter)) > 0) {
            lastCommand = lastCommand.substring(0, index);
            commands.remove(lastIndex);
            commands.add(lastCommand);
        }
        return commands;
    }

    private static void migrateTimerEvents(String domain, String configurationName) throws Exception {
        MigrateTimers timers = new MigrateTimers();
        timers.execute(domain, configurationName);
    }

    private static void migrateSignalEvents(String domain, String configurationName) throws Exception {
        MigrateSignals signals = new MigrateSignals();
        signals.execute(domain, configurationName);
    }

    private static void migrateErrorEvents(String domain, String configurationName) throws Exception {
        MigrateErrors errors = new MigrateErrors();
        errors.execute(domain, configurationName);
    }

    private static void migrateDeadlineEvents(String domain, String configurationName) throws Exception {
        MigrateDeadlines deadlines = new MigrateDeadlines();
        deadlines.execute(domain, configurationName);
    }

    private static void migrateAsyncEvents(String domain, String configurationName) throws Exception {
        MigrateAsyncs asyncs = new MigrateAsyncs();
        asyncs.execute(domain, configurationName);
    }

    private static class MigrateAsyncs
    extends ExecuteInASession {
        private MigrateAsyncs() {
        }

        @Override
        public String getEventQuery() {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT incoming AS incoming, outgoing AS outgoing ");
            builder.append("FROM org.ow2.bonita.runtime.event.IncomingEventInstance AS incoming,");
            builder.append("     org.ow2.bonita.runtime.event.OutgoingEventInstance AS outgoing ");
            builder.append("WHERE incoming.name = outgoing.name ");
            builder.append("AND incoming.signal = 'async' ");
            builder.append("AND incoming.locked = outgoing.locked ");
            builder.append("AND (outgoing.processName IS NULL OR outgoing.processName = incoming.processName) ");
            builder.append("AND (outgoing.activityName IS NULL OR outgoing.activityName = incoming.activityName) ");
            builder.append("ORDER BY outgoing.id ASC, incoming.id ASC");
            return builder.toString();
        }

        @Override
        public void executeEventCouple(org.hibernate.Session session, EventCouple couple) {
            IncomingEventInstance incoming = couple.getIncoming();
            OutgoingEventInstance outgoing = couple.getOutgoing();
            ProcessInstanceUUID instanceUUID = incoming.getInstanceUUID();
            String uuid = this.getRootProcessInstanceUUID(session, instanceUUID);
            Job async = JobBuilder.asyncJob(incoming.getName(), new ProcessInstanceUUID(uuid), incoming.getExecutionUUID(), instanceUUID);
            async.setEventSubProcessRootInstanceUUID(incoming.getEventSubProcessRootInstanceUUID());
            async.setRetries(this.getIncomingRetries(session, incoming));
            session.save((Object)async);
            session.delete((Object)outgoing);
            session.delete((Object)incoming);
        }
    }

    private static class MigrateDeadlines
    extends ExecuteInASession {
        private MigrateDeadlines() {
        }

        @Override
        public String getEventQuery() {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT incoming AS incoming, outgoing AS outgoing ");
            builder.append("FROM org.ow2.bonita.runtime.event.IncomingEventInstance AS incoming,");
            builder.append("     org.ow2.bonita.runtime.event.OutgoingEventInstance AS outgoing ");
            builder.append("WHERE incoming.name = outgoing.name ");
            builder.append("AND incoming.signal = 'timer' ");
            builder.append("AND incoming.locked = outgoing.locked ");
            builder.append("AND (outgoing.processName IS NULL OR outgoing.processName = incoming.processName) ");
            builder.append("AND (outgoing.activityName IS NULL OR outgoing.activityName = incoming.activityName) ");
            builder.append("ORDER BY outgoing.id ASC, incoming.id ASC");
            return builder.toString();
        }

        @Override
        public void executeEventCouple(org.hibernate.Session session, EventCouple couple) {
            IncomingEventInstance incoming = couple.getIncoming();
            OutgoingEventInstance outgoing = couple.getOutgoing();
            ProcessInstanceUUID instanceUUID = incoming.getInstanceUUID();
            String uuid = this.getRootProcessInstanceUUID(session, instanceUUID);
            String deadlineId = String.valueOf(outgoing.getParameters().get("id"));
            Job deadline = JobBuilder.deadlineJob(deadlineId, new ProcessInstanceUUID(uuid), incoming.getExecutionUUID(), incoming.getEnableTime(), incoming.getInstanceUUID());
            deadline.setRetries(this.getIncomingRetries(session, incoming));
            session.save((Object)deadline);
            session.delete((Object)outgoing);
            session.delete((Object)incoming);
        }
    }

    private static class MigrateErrors
    extends ExecuteInASession {
        private MigrateErrors() {
        }

        @Override
        public String getEventQuery() {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT incoming AS incoming, outgoing AS outgoing ");
            builder.append("FROM org.ow2.bonita.runtime.event.IncomingEventInstance AS incoming,");
            builder.append("     org.ow2.bonita.runtime.event.OutgoingEventInstance AS outgoing ");
            builder.append("WHERE incoming.name = outgoing.name ");
            builder.append("AND (incoming.signal = 'event.boundary.error' OR incoming.signal = 'event.start.error') ");
            builder.append("AND incoming.locked = outgoing.locked ");
            builder.append("AND (outgoing.processName IS NULL OR outgoing.processName = incoming.processName) ");
            builder.append("AND (outgoing.activityName IS NULL OR outgoing.activityName = incoming.activityName) ");
            builder.append("ORDER BY outgoing.id ASC, incoming.id ASC");
            return builder.toString();
        }

        @Override
        public void executeEventCouple(org.hibernate.Session session, EventCouple couple) {
            IncomingEventInstance incoming = couple.getIncoming();
            Job error = null;
            if ("event.start.error".equals(incoming.getSignal())) {
                error = JobBuilder.startErrorJob(incoming.getName(), incoming.getActivityDefinitionUUID());
                error.setEventSubProcessRootInstanceUUID(incoming.getEventSubProcessRootInstanceUUID());
            } else if ("event.boundary.error".equals(incoming.getSignal())) {
                String uuid = this.getRootProcessInstanceUUID(session, incoming.getInstanceUUID());
                String incomingEventName = incoming.getName();
                int separator = incomingEventName.indexOf("@3^3NT5@");
                String eventName = incomingEventName.substring(0, separator);
                error = JobBuilder.boundaryErrorJob(eventName, new ProcessInstanceUUID(uuid), incoming.getExecutionUUID(), incoming.getInstanceUUID());
                session.delete((Object)incoming);
            }
            error.setRetries(this.getIncomingRetries(session, incoming));
            LOG.info(error.toString());
            session.save((Object)error);
            session.delete((Object)couple.getOutgoing());
        }
    }

    private static class MigrateSignals
    extends ExecuteInASession {
        private MigrateSignals() {
        }

        @Override
        public String getEventQuery() {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT incoming AS incoming, outgoing AS outgoing ");
            builder.append("FROM org.ow2.bonita.runtime.event.IncomingEventInstance AS incoming,");
            builder.append("     org.ow2.bonita.runtime.event.OutgoingEventInstance AS outgoing ");
            builder.append("WHERE incoming.name = outgoing.name ");
            builder.append("AND (incoming.signal = 'event.intermediate.signal' OR incoming.signal = 'event.boundary.signal' OR incoming.signal = 'event.start.signal') ");
            builder.append("AND incoming.locked = outgoing.locked ");
            builder.append("AND (outgoing.processName IS NULL OR outgoing.processName = incoming.processName) ");
            builder.append("AND (outgoing.activityName IS NULL OR outgoing.activityName = incoming.activityName) ");
            builder.append("ORDER BY outgoing.id ASC, incoming.id ASC");
            return builder.toString();
        }

        @Override
        public void executeEventCouple(org.hibernate.Session session, EventCouple couple) {
            IncomingEventInstance incoming = couple.getIncoming();
            Job signal = null;
            if ("event.start.signal".equals(incoming.getSignal())) {
                signal = JobBuilder.startSignalJob(incoming.getName(), incoming.getActivityDefinitionUUID());
                signal.setEventSubProcessRootInstanceUUID(incoming.getEventSubProcessRootInstanceUUID());
            } else if ("event.boundary.signal".equals(incoming.getSignal())) {
                String uuid = this.getRootProcessInstanceUUID(session, incoming.getInstanceUUID());
                signal = JobBuilder.boundarySignalJob(incoming.getActivityName(), new ProcessInstanceUUID(uuid), incoming.getExecutionUUID(), incoming.getInstanceUUID());
                session.delete((Object)incoming);
            } else if ("event.intermediate.signal".equals(incoming.getSignal())) {
                String uuid = this.getRootProcessInstanceUUID(session, incoming.getInstanceUUID());
                signal = JobBuilder.intermediateSignalJob(incoming.getName(), new ProcessInstanceUUID(uuid), incoming.getExecutionUUID(), incoming.getInstanceUUID());
                session.delete((Object)incoming);
            }
            signal.setRetries(this.getIncomingRetries(session, incoming));
            session.save((Object)signal);
            session.delete((Object)couple.getOutgoing());
        }
    }

    private static class MigrateTimers
    extends ExecuteInASession {
        private MigrateTimers() {
        }

        @Override
        public String getEventQuery() {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT incoming AS incoming, outgoing AS outgoing ");
            builder.append("FROM org.ow2.bonita.runtime.event.IncomingEventInstance AS incoming,");
            builder.append("     org.ow2.bonita.runtime.event.OutgoingEventInstance AS outgoing ");
            builder.append("WHERE incoming.name = outgoing.name ");
            builder.append("AND (incoming.signal = 'end_of_timer' OR incoming.signal = 'event.boundary.timer' OR incoming.signal = 'event.start.timer') ");
            builder.append("AND incoming.locked = outgoing.locked ");
            builder.append("AND (outgoing.processName IS NULL OR outgoing.processName = incoming.processName) ");
            builder.append("AND (outgoing.activityName IS NULL OR outgoing.activityName = incoming.activityName) ");
            builder.append("ORDER BY outgoing.id ASC, incoming.id ASC");
            return builder.toString();
        }

        @Override
        public void executeEventCouple(org.hibernate.Session session, EventCouple couple) {
            IncomingEventInstance incoming = couple.getIncoming();
            LOG.info(incoming.toString());
            Job timer = null;
            if ("event.start.timer".equals(incoming.getSignal())) {
                timer = JobBuilder.startTimerJob(incoming.getActivityName(), incoming.getActivityDefinitionUUID(), incoming.getExpression(), incoming.getEnableTime());
                timer.setEventSubProcessRootInstanceUUID(incoming.getEventSubProcessRootInstanceUUID());
            } else if ("event.boundary.timer".equals(incoming.getSignal())) {
                String uuid = this.getRootProcessInstanceUUID(session, incoming.getInstanceUUID());
                timer = JobBuilder.boundaryTimerJob(incoming.getName(), new ProcessInstanceUUID(uuid), incoming.getExecutionUUID(), incoming.getEnableTime(), incoming.getInstanceUUID());
            } else if ("end_of_timer".equals(incoming.getSignal())) {
                String uuid = this.getRootProcessInstanceUUID(session, incoming.getInstanceUUID());
                timer = JobBuilder.intermediateTimerJob(incoming.getActivityName(), new ProcessInstanceUUID(uuid), incoming.getExecutionUUID(), incoming.getEnableTime(), incoming.getInstanceUUID());
            }
            timer.setRetries(this.getIncomingRetries(session, incoming));
            session.delete((Object)incoming);
            LOG.info(timer.toString());
            session.save((Object)timer);
            session.delete((Object)couple.getOutgoing());
        }
    }

    private static abstract class ExecuteInASession {
        private ExecuteInASession() {
        }

        public abstract String getEventQuery();

        public abstract void executeEventCouple(org.hibernate.Session var1, EventCouple var2);

        protected int getIncomingRetries(org.hibernate.Session session, IncomingEventInstance event) {
            String queryString = "select RETRIES_ from BN_IEI_ where DBID_ = :id";
            SQLQuery query = session.createSQLQuery("select RETRIES_ from BN_IEI_ where DBID_ = :id");
            query.setLong("id", event.getId());
            Object result = query.uniqueResult();
            if (result instanceof BigDecimal) {
                return ((BigDecimal)result).intValue();
            }
            return (Integer)result;
        }

        protected String getRootProcessInstanceUUID(org.hibernate.Session session, ProcessInstanceUUID instanceUUID) {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT process.rootInstanceUUID.value ");
            builder.append("FROM org.ow2.bonita.facade.runtime.impl.InternalProcessInstance AS process ");
            builder.append("WHERE process.instanceUUID.value = :processUUID");
            Query query = session.createQuery(builder.toString());
            query.setString("processUUID", instanceUUID.getValue());
            return (String)query.uniqueResult();
        }

        private static List<EventCouple> getEvents(org.hibernate.Session session, String queryString) {
            Query query = session.createQuery(queryString);
            query.setResultTransformer(Transformers.aliasToBean(EventCouple.class));
            query.setMaxResults(100);
            List couples = query.list();
            if (couples == null) {
                return Collections.emptyList();
            }
            return couples;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(String domain, String configurationName) throws Exception {
            SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(domain, configurationName.replaceAll("-configuration", "-session-factory"));
            Session session = sessionFactory.openSession();
            try {
                session.getTransaction().begin();
                List<EventCouple> eventCouples = null;
                do {
                    eventCouples = ExecuteInASession.getEvents((org.hibernate.Session)session, this.getEventQuery());
                    int size = eventCouples.size();
                    int i = 1;
                    LOG.info("Getting " + size + " eventCouple(s)");
                    for (EventCouple eventCouple : eventCouples) {
                        LOG.info("Migrating eventCouple: " + i + "/" + size);
                        this.executeEventCouple((org.hibernate.Session)session, eventCouple);
                        session.getTransaction().commit();
                        session.getTransaction().begin();
                        ++i;
                    }
                } while (!eventCouples.isEmpty());
            }
            finally {
                session.close();
            }
        }
    }
}

