/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.ArrayList;
import java.util.List;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.FilterListener;
import org.ow2.bonita.util.Listener;
import org.ow2.bonita.util.Observable;

public class DefaultObservable
implements Observable {
    protected List<Listener> listeners = null;

    @Override
    public void addListener(Listener listener) {
        if (listener == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_DO_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Listener listener) {
        if (listener == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_DO_2", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public Listener addListener(Listener listener, String eventName) {
        if (eventName == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_DO_3", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        ArrayList<String> eventNames = new ArrayList<String>();
        eventNames.add(eventName);
        return this.addListener(listener, eventNames);
    }

    @Override
    public Listener addListener(Listener listener, List<String> eventNames) {
        if (listener == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_DO_4", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        if (eventNames == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_DO_5", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        FilterListener filterListener = new FilterListener(listener, eventNames);
        this.addListener(filterListener);
        return filterListener;
    }

    @Override
    public void fire(String eventName) {
        this.fire(eventName, null);
    }

    @Override
    public void fire(String eventName, Object info) {
        if (this.listeners != null) {
            for (Listener listener : this.listeners) {
                listener.event(this, eventName, info);
            }
        }
    }

    public List<Listener> getListeners() {
        return this.listeners;
    }
}

