/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.ArrayList;
import java.util.List;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Listener;

public class FilterListener
implements Listener {
    protected Listener listener;
    protected List<String> eventNames;

    public FilterListener(Listener listener, String eventName) {
        if (listener == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_FL_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        this.listener = listener;
        if (eventName == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_FL_2", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        this.eventNames = new ArrayList<String>();
        this.eventNames.add(eventName);
    }

    public FilterListener(Listener listener, List<String> eventNames) {
        if (listener == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_FL_3", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        this.listener = listener;
        if (eventNames == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_FL_4", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        this.eventNames = eventNames;
    }

    @Override
    public void event(Object source, String name, Object info) {
        if (!this.isFiltered(name)) {
            this.listener.event(source, name, info);
        }
    }

    public boolean isFiltered(String eventName) {
        return !this.eventNames.contains(eventName);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return object instanceof Listener && this.listener.equals(object);
    }

    public int hashCode() {
        return 17 + this.listener.hashCode();
    }
}

