/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import groovy.lang.Binding;
import groovy.lang.MissingPropertyException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.APIAccessor;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.facade.exception.ActivityDefNotFoundException;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.DataFieldNotFoundException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.impl.StandardQueryAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.VariableUpdate;
import org.ow2.bonita.facade.runtime.impl.ActivityInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.ObjectVariable;
import org.ow2.bonita.facade.runtime.impl.ProcessInstanceImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.util.DocumentService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;

public class GroovyBindingBuilder {
    public static Binding getSimpleBinding(Map<String, Object> allVariables, ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID) throws IOException, ClassNotFoundException, GroovyException, InstanceNotFoundException, ActivityNotFoundException {
        return new SimpleBinding(allVariables, processUUID, instanceUUID, activityUUID);
    }

    public static Binding getPropagateBinding(Map<String, Object> allVariables, ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityInstanceUUID, Map<String, Object> context) throws IOException, ClassNotFoundException, GroovyException, InstanceNotFoundException, ActivityNotFoundException {
        ActivityDefinitionUUID activityUUID = null;
        if (activityInstanceUUID != null) {
            InternalActivityInstance activityInstance = EnvTool.getAllQueriers().getActivityInstance(activityInstanceUUID);
            activityUUID = activityInstance.getActivityDefinitionUUID();
        }
        HashSet<String> initialVariables = new HashSet<String>();
        initialVariables.addAll(allVariables.keySet());
        if (context != null) {
            initialVariables.removeAll(context.keySet());
        }
        return new PropagateBinding(processUUID, activityUUID, instanceUUID, activityInstanceUUID, allVariables, initialVariables);
    }

    public static Binding getSimpleBinding(ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID, Map<String, Object> context, boolean useActivityScope, boolean useInitialVariableValues) throws IOException, ClassNotFoundException, GroovyException, InstanceNotFoundException, ActivityNotFoundException {
        Map<String, Object> allVariables = GroovyBindingBuilder.getContext(context, processUUID, activityUUID, instanceUUID, useActivityScope, useInitialVariableValues);
        return new SimpleBinding(allVariables, processUUID, instanceUUID, activityUUID);
    }

    public static Binding getPropagateBinding(ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityInstanceUUID, Map<String, Object> context, boolean useActivityScope, boolean useInitialVariableValues) throws IOException, ClassNotFoundException, GroovyException, InstanceNotFoundException, ActivityNotFoundException {
        Map<String, Object> allVariables = GroovyBindingBuilder.getContext(context, processUUID, activityInstanceUUID, instanceUUID, useActivityScope, useInitialVariableValues);
        ActivityDefinitionUUID activityUUID = null;
        if (activityInstanceUUID != null) {
            InternalActivityInstance activityInstance = EnvTool.getAllQueriers().getActivityInstance(activityInstanceUUID);
            activityUUID = activityInstance.getActivityDefinitionUUID();
        }
        HashSet<String> initialVariables = new HashSet<String>();
        initialVariables.addAll(allVariables.keySet());
        if (context != null) {
            initialVariables.removeAll(context.keySet());
        }
        return new PropagateBinding(processUUID, activityUUID, instanceUUID, activityInstanceUUID, allVariables, initialVariables);
    }

    private static Map<String, Object> getActivityInstanceVariables(ActivityInstanceUUID activityUUID) throws ActivityNotFoundException {
        HashMap<String, Object> activityInstanceVariables = new HashMap<String, Object>();
        if (activityUUID != null) {
            StandardQueryAPIAccessorImpl accessor = new StandardQueryAPIAccessorImpl();
            QueryRuntimeAPI api = accessor.getQueryRuntimeAPI();
            activityInstanceVariables.putAll(api.getActivityInstanceVariables(activityUUID));
        }
        return activityInstanceVariables;
    }

    private static long getActivityScopeDate(ActivityInstance activityInstance, long defaultDate) {
        long maxDate = -1L;
        maxDate = !activityInstance.getState().equals((Object)ActivityState.READY) && !activityInstance.getState().equals((Object)ActivityState.SUSPENDED) && !activityInstance.getState().equals((Object)ActivityState.EXECUTING) ? activityInstance.getLastStateUpdate().getUpdatedDate().getTime() : defaultDate;
        return maxDate;
    }

    private static Map<String, Object> getProcessInstanceVariables(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID, boolean useInitialVariableValues, boolean useActivityScope) throws InstanceNotFoundException {
        HashMap<String, Object> processInstanceVariables = new HashMap<String, Object>();
        if (instanceUUID != null) {
            StandardQueryAPIAccessorImpl accessor = new StandardQueryAPIAccessorImpl();
            QueryRuntimeAPI api = accessor.getQueryRuntimeAPI();
            InternalProcessInstance instance = EnvTool.getAllQueriers().getProcessInstance(instanceUUID);
            if (useInitialVariableValues) {
                processInstanceVariables.putAll(instance.getInitialVariableValues());
            } else {
                processInstanceVariables.putAll(api.getProcessInstanceVariables(instanceUUID));
            }
        }
        if (activityUUID != null) {
            InternalActivityInstance activityInstance = EnvTool.getAllQueriers().getActivityInstance(activityUUID);
            InternalProcessInstance instance = EnvTool.getAllQueriers().getProcessInstance(activityInstance.getProcessInstanceUUID());
            long maxDate = new Date().getTime();
            if (useActivityScope) {
                maxDate = GroovyBindingBuilder.getActivityScopeDate(activityInstance, maxDate);
            }
            List<VariableUpdate> instanceVarUpdates = instance.getVariableUpdates();
            HashMap<String, VariableUpdate> tmp = new HashMap<String, VariableUpdate>();
            for (VariableUpdate varUpdate : instanceVarUpdates) {
                if (varUpdate.getDate().getTime() > maxDate) continue;
                tmp.put(varUpdate.getName(), varUpdate);
            }
            processInstanceVariables.putAll(instance.getInitialVariableValues());
            for (VariableUpdate varUpdate : tmp.values()) {
                processInstanceVariables.put(varUpdate.getName(), varUpdate.getValue());
            }
        }
        return processInstanceVariables;
    }

    private static Map<String, Object> getProcessDatafieldsVariables(ProcessDefinitionUUID processUUID, Set<String> variablesToIgnore) throws InstanceNotFoundException, GroovyException {
        HashMap<String, Object> processDatafieldsVariables = new HashMap<String, Object>();
        if (processUUID != null) {
            InternalProcessDefinition process = EnvTool.getAllQueriers().getProcess(processUUID);
            Set<DataFieldDefinition> datafields = process.getDataFields();
            processDatafieldsVariables.putAll(GroovyBindingBuilder.getMissingProcessDefinitionDataFields(datafields, variablesToIgnore, processUUID));
        }
        return processDatafieldsVariables;
    }

    private static Map<String, AttachmentInstance> getProcessInstanceAttachments(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityInstanceUUID) {
        DocumentationManager manager;
        List<AttachmentInstance> attachments;
        HashMap<String, AttachmentInstance> processInstanceAttachments = new HashMap<String, AttachmentInstance>();
        InternalProcessInstance instance = null;
        ProcessInstanceUUID processInstanceUUID = instanceUUID;
        if (instanceUUID != null) {
            instance = EnvTool.getAllQueriers().getProcessInstance(instanceUUID);
        } else if (activityInstanceUUID != null) {
            InternalActivityInstance activityInstance = EnvTool.getAllQueriers().getActivityInstance(activityInstanceUUID);
            processInstanceUUID = activityInstance.getProcessInstanceUUID();
            instance = EnvTool.getAllQueriers().getProcessInstance(processInstanceUUID);
        }
        if (instance != null && instance.getNbOfAttachments() > 0 && (attachments = DocumentService.getLastAttachments(manager = EnvTool.getDocumentationManager(), processInstanceUUID)) != null) {
            for (AttachmentInstance attachment : attachments) {
                processInstanceAttachments.put(attachment.getName(), attachment);
            }
        }
        return processInstanceAttachments;
    }

    public static Map<String, Object> getContext(Map<String, Object> context, ProcessDefinitionUUID processUUID, ActivityInstanceUUID activityUUID, ProcessInstanceUUID instanceUUID, boolean useActivityScope, boolean useInitialVariableValues) throws GroovyException, InstanceNotFoundException, ActivityNotFoundException {
        HashMap<String, Object> allVariables = new HashMap<String, Object>();
        Map<String, Object> processInstanceVariables = GroovyBindingBuilder.getProcessInstanceVariables(instanceUUID, activityUUID, useInitialVariableValues, useActivityScope);
        Map<String, Object> activityInstanceVariables = GroovyBindingBuilder.getActivityInstanceVariables(activityUUID);
        allVariables.putAll(processInstanceVariables);
        allVariables.putAll(activityInstanceVariables);
        Map<String, Object> processDatafieldsVariables = GroovyBindingBuilder.getProcessDatafieldsVariables(processUUID, allVariables.keySet());
        allVariables.putAll(processDatafieldsVariables);
        if (context != null) {
            allVariables.putAll(context);
        }
        return allVariables;
    }

    private static Map<String, Object> getMissingProcessDefinitionDataFields(Set<DataFieldDefinition> datafields, Set<String> variablesToIgnore, ProcessDefinitionUUID processDefinitionUUID) throws GroovyException {
        HashMap<String, Object> processDatafieldsVariables = new HashMap<String, Object>();
        if (datafields != null) {
            ArrayList<DataFieldDefinition> variables = new ArrayList<DataFieldDefinition>();
            for (DataFieldDefinition datafield : datafields) {
                if (variablesToIgnore.contains(datafield.getName())) continue;
                Serializable value = datafield.getInitialValue();
                String script = datafield.getScriptingValue();
                if (value == null && script != null) {
                    variables.add(datafield);
                    continue;
                }
                processDatafieldsVariables.put(datafield.getName(), value);
            }
            int size = variables.size();
            int index = 0;
            int errors = 0;
            while (size > 0 && index < size) {
                DataFieldDefinition variable = (DataFieldDefinition)variables.get(index);
                try {
                    Object value = GroovyUtil.evaluate(variable.getScriptingValue(), processDatafieldsVariables);
                    processDatafieldsVariables.put(variable.getName(), value);
                    variables.remove(index);
                    size = variables.size();
                    index = 0;
                    errors = 0;
                }
                catch (GroovyException e) {
                    if (++errors == size) {
                        StringBuilder stb = new StringBuilder("Unable to evaluate: '");
                        stb.append(variable.getScriptingValue());
                        stb.append("' on variable: '");
                        stb.append(variable.getName());
                        stb.append("' in process: '");
                        stb.append(processDefinitionUUID);
                        stb.append("' ");
                        throw new GroovyException(stb.toString(), e);
                    }
                    ++index;
                }
            }
        }
        return processDatafieldsVariables;
    }

    public static Object getInjectedVariable(String variable, ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityInstanceUUID) {
        if ("processDefinition".equals(variable) && processUUID != null) {
            return new ProcessDefinitionImpl(EnvTool.getAllQueriers().getProcess(processUUID));
        }
        if ("processInstance".equals(variable) && instanceUUID != null) {
            return new ProcessInstanceImpl(EnvTool.getAllQueriers().getProcessInstance(instanceUUID));
        }
        if ("activityInstance".equals(variable) && activityInstanceUUID != null) {
            return new ActivityInstanceImpl(EnvTool.getAllQueriers().getActivityInstance(activityInstanceUUID));
        }
        if ("loggedUser".equals(variable)) {
            try {
                return EnvTool.getUserId();
            }
            catch (Throwable e) {
                return null;
            }
        }
        if ("apiAccessor".equals(variable)) {
            return new StandardAPIAccessorImpl();
        }
        if ("processInstanceInitiator".equals(variable) && instanceUUID != null) {
            InternalProcessInstance processInstance = EnvTool.getAllQueriers().getProcessInstance(instanceUUID);
            return processInstance.getStartedBy();
        }
        return null;
    }

    public static class PropagateBinding
    extends SimpleBinding {
        private final Collection<String> varToPropagate = new HashSet<String>();
        private final Collection<String> initialProcessVariableKeys = new HashSet<String>();
        private final Collection<String> initialObjectVariables = new HashSet<String>();
        private final Collection<String> initialNullVariables = new HashSet<String>();
        private final ActivityDefinitionUUID activityUUID;
        private final ProcessDefinitionUUID processUUID;

        public PropagateBinding(ProcessDefinitionUUID processUUID, ActivityDefinitionUUID activityUUID, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityInstanceUUID, Map<String, Object> variables, Set<String> initialProcessVariableKeys) throws IOException, ClassNotFoundException {
            super(variables, processUUID, instanceUUID, activityInstanceUUID);
            this.initialProcessVariableKeys.addAll(initialProcessVariableKeys);
            if (variables != null) {
                for (Map.Entry<String, Object> variable : variables.entrySet()) {
                    Object value = variable.getValue();
                    String varName = variable.getKey();
                    if (value instanceof ObjectVariable && initialProcessVariableKeys.contains(varName)) {
                        value = ((ObjectVariable)value).getValue();
                        this.initialObjectVariables.add(varName);
                    }
                    if (value != null) continue;
                    this.initialNullVariables.add(varName);
                }
            }
            this.activityUUID = activityUUID;
            this.processUUID = processUUID;
        }

        @Override
        public Object getVariable(String name) {
            this.varToPropagate.add(name);
            return super.getVariable(name);
        }

        @Override
        public void setVariable(String name, Object value) {
            super.setVariable(name, value);
            if (this.initialProcessVariableKeys.contains(name)) {
                this.varToPropagate.add(name);
            }
        }

        public Map<String, Object> getVariablesToPropagate() throws NotSerializableException, IOException, ClassNotFoundException, ActivityDefNotFoundException, DataFieldNotFoundException, ProcessNotFoundException {
            HashMap<String, Object> variablesToPropagate = new HashMap<String, Object>();
            for (String varName : this.varToPropagate) {
                if (!this.initialProcessVariableKeys.contains(varName)) continue;
                Object value = this.allVariables.get(varName);
                if (this.initialObjectVariables.contains(varName)) {
                    value = new ObjectVariable(value);
                } else if (this.initialNullVariables.contains(varName)) {
                    StandardQueryAPIAccessorImpl accessor = new StandardQueryAPIAccessorImpl();
                    QueryDefinitionAPI queryDefinitionAPI = accessor.getQueryDefinitionAPI("journalQueryList");
                    DataFieldDefinition datafield = null;
                    if (this.activityUUID != null) {
                        try {
                            datafield = queryDefinitionAPI.getActivityDataField(this.activityUUID, varName);
                        }
                        catch (DataFieldNotFoundException e) {
                            datafield = queryDefinitionAPI.getProcessDataField(this.processUUID, varName);
                        }
                    }
                    if (datafield == null && this.processUUID != null) {
                        datafield = queryDefinitionAPI.getProcessDataField(this.processUUID, varName);
                    }
                    if (datafield != null && datafield.getDataTypeClassName().equals(ObjectVariable.class.getName())) {
                        value = new ObjectVariable(value);
                    }
                }
                variablesToPropagate.put(varName, value);
            }
            return variablesToPropagate;
        }
    }

    public static class SimpleBinding
    extends Binding {
        Map<String, Object> allVariables = new HashMap<String, Object>();
        private ProcessDefinitionUUID processUUID;
        private ProcessDefinition clientProcessDefinition;
        private ProcessInstanceUUID instanceUUID;
        private ProcessInstance clientProcessInstance;
        private final ActivityInstanceUUID activityInstanceUUID;
        private ActivityInstance clientActivityInstance;
        private APIAccessor apiAccessor;
        private String initiator;
        private boolean attachmentsWasLoaded = false;

        public SimpleBinding(Map<String, Object> variables, ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityInstanceUUID) throws IOException, ClassNotFoundException {
            if (variables != null) {
                for (Map.Entry<String, Object> variable : variables.entrySet()) {
                    Object value = variable.getValue();
                    if (value instanceof ObjectVariable) {
                        value = ((ObjectVariable)value).getValue();
                    }
                    this.allVariables.put(variable.getKey(), value);
                }
            }
            if (processUUID != null) {
                this.processUUID = processUUID;
            } else if (instanceUUID != null) {
                this.processUUID = EnvTool.getAllQueriers().getProcessInstance(instanceUUID).getProcessDefinitionUUID();
            } else if (activityInstanceUUID != null) {
                this.processUUID = EnvTool.getAllQueriers().getActivityInstance(activityInstanceUUID).getProcessDefinitionUUID();
            }
            if (instanceUUID != null) {
                this.instanceUUID = instanceUUID;
            } else if (activityInstanceUUID != null) {
                this.instanceUUID = EnvTool.getAllQueriers().getActivityInstance(activityInstanceUUID).getProcessInstanceUUID();
            }
            this.activityInstanceUUID = activityInstanceUUID;
        }

        public Object getVariable(String name) {
            if ("processDefinition".equals(name)) {
                if (this.clientProcessDefinition == null && this.processUUID != null) {
                    this.clientProcessDefinition = new ProcessDefinitionImpl(EnvTool.getAllQueriers().getProcess(this.processUUID));
                }
                return this.clientProcessDefinition;
            }
            if ("processInstance".equals(name)) {
                if (this.clientProcessInstance == null && this.instanceUUID != null) {
                    this.clientProcessInstance = new ProcessInstanceImpl(EnvTool.getAllQueriers().getProcessInstance(this.instanceUUID));
                }
                return this.clientProcessInstance;
            }
            if ("activityInstance".equals(name)) {
                if (this.clientActivityInstance == null && this.activityInstanceUUID != null) {
                    this.clientActivityInstance = new ActivityInstanceImpl(EnvTool.getAllQueriers().getActivityInstance(this.activityInstanceUUID));
                }
                return this.clientActivityInstance;
            }
            if ("loggedUser".equals(name)) {
                try {
                    return EnvTool.getUserId();
                }
                catch (Throwable e) {
                    return null;
                }
            }
            if ("apiAccessor".equals(name)) {
                if (this.apiAccessor == null) {
                    this.apiAccessor = new StandardAPIAccessorImpl();
                }
                return this.apiAccessor;
            }
            if ("processInstanceInitiator".equals(name)) {
                if (this.initiator == null && this.instanceUUID != null) {
                    InternalProcessInstance processInstance = EnvTool.getAllQueriers().getProcessInstance(this.instanceUUID);
                    this.initiator = processInstance.getStartedBy();
                }
                return this.initiator;
            }
            if (this.allVariables.containsKey(name)) {
                return this.allVariables.get(name);
            }
            try {
                return super.getVariable(name);
            }
            catch (MissingPropertyException e) {
                if (!this.attachmentsWasLoaded) {
                    Map attachments = GroovyBindingBuilder.getProcessInstanceAttachments(this.instanceUUID, this.activityInstanceUUID);
                    this.allVariables.putAll(attachments);
                    this.attachmentsWasLoaded = true;
                    if (this.allVariables.containsKey(name)) {
                        return this.allVariables.get(name);
                    }
                    throw e;
                }
                throw e;
            }
        }

        public void setVariable(String name, Object value) {
            this.allVariables.put(name, value);
        }

        public Map<String, Object> getVariables() {
            return this.allVariables;
        }
    }
}

