/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import org.hibernate.CacheMode;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.ow2.bonita.util.BonitaConstants;
import org.ow2.bonita.util.DbTool;
import org.ow2.bonita.util.ExceptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexTool {
    private static final Logger LOG = LoggerFactory.getLogger(IndexTool.class);
    private static final String REINDEX_DOMAIN_PROPERTY = "org.ow2.bonita.reindex.domain";

    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 3) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBM_3", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        String domain = args[0];
        int nbOfThreadLoad = Integer.valueOf(args[1]);
        int nbOfThreadFetching = Integer.valueOf(args[2]);
        LOG.info("Indexing History DB");
        IndexTool.populateIndexes(domain, "hibernate-configuration:history", nbOfThreadLoad, nbOfThreadFetching);
        LOG.info("Indexing Core DB");
        IndexTool.populateIndexes(domain, "hibernate-configuration:core", nbOfThreadLoad, nbOfThreadFetching);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateIndexes(SessionFactoryImplementor sessionFactory, int nbOfThreadLoad, int nbOfThreadFetching) throws InterruptedException {
        FullTextSession fullTextSession = null;
        try {
            Session session = sessionFactory.openSession();
            fullTextSession = Search.getFullTextSession((org.hibernate.Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            MassIndexer indexer = fullTextSession.createIndexer(new Class[0]);
            indexer.batchSizeToLoadObjects(25).cacheMode(CacheMode.NORMAL).optimizeOnFinish(true);
            indexer.threadsToLoadObjects(nbOfThreadLoad).threadsForSubsequentFetching(nbOfThreadFetching).startAndWait();
            fullTextSession.createIndexer(new Class[0]);
            tx.commit();
        }
        finally {
            if (fullTextSession != null) {
                fullTextSession.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateIndexes(String domain, String configurationName, int nbOfThreadLoad, int nbOfThreadFetching) throws Exception {
        SessionFactoryImplementor sessionFactory;
        block4: {
            System.setProperty(REINDEX_DOMAIN_PROPERTY, domain);
            sessionFactory = null;
            try {
                BonitaConstants.getBonitaHomeFolder();
                Configuration cfg = DbTool.getConfiguration(domain, configurationName);
                if ("true".equals(cfg.getProperty("bonita.search.use"))) {
                    sessionFactory = DbTool.getSessionFactory(domain, configurationName.replaceAll("-configuration", "-session-factory"));
                    if (sessionFactory != null) {
                        IndexTool.populateIndexes(sessionFactory, nbOfThreadLoad, nbOfThreadFetching);
                    }
                    break block4;
                }
                LOG.info(configurationName + "does not support indexing");
            }
            catch (Throwable throwable) {
                System.clearProperty(REINDEX_DOMAIN_PROPERTY);
                IndexTool.closeSession(sessionFactory);
                throw throwable;
            }
        }
        System.clearProperty(REINDEX_DOMAIN_PROPERTY);
        IndexTool.closeSession(sessionFactory);
    }

    private static void closeSession(SessionFactoryImplementor sessionFactory) {
        block3: {
            if (sessionFactory != null) {
                try {
                    sessionFactory.close();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error("Problems while closing section factory: ", (Throwable)e);
                }
            }
        }
    }
}

