/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util.hibernate;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.type.StringType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.ow2.bonita.util.ExceptionManager;

public class GenericEnumUserType
implements UserType,
ParameterizedType,
Serializable {
    private static final long serialVersionUID = -1330133661718663399L;
    private static final String DEFAULT_IDENTIFIER_METHOD_NAME = "name";
    private static final String DEFAULT_VALUE_OF_METHOD_NAME = "valueOf";
    private Class<? extends Enum> enumClass;
    private Method identifierMethod;
    private Method valueOfMethod;
    private final StringType type = new StringType();
    private int[] sqlTypes;

    public void setParameterValues(Properties parameters) {
        Class<?> identifierType;
        String enumClassName = parameters.getProperty("enumClass");
        try {
            this.enumClass = Class.forName(enumClassName).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException cfne) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_GEUT_1", new Object[0]);
            throw new HibernateException(message, (Throwable)cfne);
        }
        String identifierMethodName = parameters.getProperty("identifierMethod", DEFAULT_IDENTIFIER_METHOD_NAME);
        try {
            this.identifierMethod = this.enumClass.getMethod(identifierMethodName, new Class[0]);
            identifierType = this.identifierMethod.getReturnType();
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_GEUT_2", new Object[0]);
            throw new HibernateException(message, (Throwable)e);
        }
        this.sqlTypes = new int[]{this.type.sqlType()};
        String valueOfMethodName = parameters.getProperty("valueOfMethod", DEFAULT_VALUE_OF_METHOD_NAME);
        try {
            this.valueOfMethod = this.enumClass.getMethod(valueOfMethodName, identifierType);
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_GEUT_4", new Object[0]);
            throw new HibernateException(message, (Throwable)e);
        }
    }

    public Class<?> returnedClass() {
        return this.enumClass;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        Object identifier = this.type.get(rs, names[0]);
        if (identifier == null) {
            return null;
        }
        try {
            return this.valueOfMethod.invoke(this.enumClass, identifier);
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_GEUT_5", this.valueOfMethod.getName(), this.enumClass);
            throw new HibernateException(message, (Throwable)e);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws SQLException {
        try {
            if (value == null) {
                st.setNull(index, this.type.sqlType());
            } else {
                String identifier = (String)this.identifierMethod.invoke(value, new Object[0]);
                this.type.set(st, (Object)identifier, index);
            }
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_GEUT_6", this.identifierMethod.getName(), this.enumClass);
            throw new HibernateException(message, (Throwable)e);
        }
    }

    public int[] sqlTypes() {
        return this.sqlTypes;
    }

    public Object assemble(Serializable cached, Object owner) {
        return cached;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) {
        return x == y;
    }

    public int hashCode(Object x) {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }
}

