/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util.stream;

import java.io.InputStream;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.ReflectUtil;
import org.ow2.bonita.util.stream.StreamSource;

public class ResourceStreamSource
extends StreamSource {
    protected ClassLoader classLoader;
    protected String resource;

    public ResourceStreamSource(String resource) {
        this(resource, null);
    }

    public ResourceStreamSource(String resource, ClassLoader classLoader) {
        if (resource == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_RSS_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        this.name = "resource://" + resource;
        this.resource = resource;
        this.classLoader = classLoader;
    }

    @Override
    public InputStream openStream() {
        InputStream stream = ReflectUtil.getResourceAsStream(this.classLoader, this.resource);
        if (stream == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_RSS_2", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        return stream;
    }
}

