/**
 * Copyright (C) 2002-2007 - INRIA (www.inria.fr)
 *
 * CAROL: Common Architecture for RMI ObjectWeb Layer
 *
 * This library is developed inside the OW2 Consortium,
 * http://www.ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JDuplicateName.java 1880 2008-06-28 21:10:49Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.carol.rmi.interceptor.api;

/**
 * Exception <code>JDuplicateName</code> is the CAROL JRMP Interceptor
 * Registering Exception This Exception occur when 2 Interceptors with the same
 * name are registered
 * @author Guillaume Riviere (Guillaume.Riviere@inrialpes.fr)
 * @version 1.0, 15/07/2002
 */
public class JDuplicateName extends Exception {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 603942111992934920L;

    /**
     * EMPTY constructor
     */
    public JDuplicateName() {
        super();
    }

    /**
     * Constructor
     * @param name The exception name
     */
    public JDuplicateName(final String name) {
        super(name);
    }

    public JDuplicateName(final Throwable thr) {
        super(thr);
    }

    public JDuplicateName(final String name, final Throwable thr) {
        super(name, thr);
    }

}
