/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.lb.strategy.LoadFactorComparator;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class LoadFactorSort<T extends LoadBalanceable>
implements IStrategy<T> {
    private static final Log LOGGER = LogFactory.getLog(LoadFactorSort.class);
    private final LoadFactorComparator<T> comparator;

    public LoadFactorSort(ClusterViewManager clusterViewManager) {
        this.comparator = new LoadFactorComparator(clusterViewManager);
    }

    public List<T> choose(Collection<T> loadBalanceables) {
        ArrayList<T> orderedLoadBalanceables = new ArrayList<T>(loadBalanceables);
        Collections.sort(orderedLoadBalanceables, this.comparator);
        return orderedLoadBalanceables;
    }

    public String toString() {
        return "LoadFactor";
    }
}

