/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jotm.jms;

import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.transaction.TransactionManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jotm.jms.JConnectionFactory;
import org.ow2.jotm.jms.JSession;
import org.ow2.jotm.jms.JmsManagerImpl;

public class JConnection
implements Connection {
    protected XAConnection xac;
    protected boolean closed;
    protected String user;
    protected boolean globaltx;
    protected static TransactionManager tm;
    protected JConnectionFactory jcf;
    protected LinkedList<Session> sessionlist = new LinkedList();
    protected static final String INTERNAL_USER_NAME = "anybody";
    protected Logger logger;

    protected JConnection(JConnectionFactory jcf, String user, Logger logger) {
        this.user = user;
        this.jcf = jcf;
        this.logger = logger;
        this.closed = false;
        if (tm == null) {
            tm = JmsManagerImpl.getTransactionManager();
        }
        try {
            this.globaltx = tm.getTransaction() != null;
        }
        catch (Exception e) {
            this.globaltx = false;
        }
    }

    public JConnection(JConnectionFactory jcf, XAConnectionFactory xacf, String user, String passwd, Logger logger) throws JMSException {
        this(jcf, user, logger);
        this.xac = xacf.createXAConnection(user, passwd);
    }

    public JConnection(JConnectionFactory jcf, XAConnectionFactory xacf, Logger logger) throws JMSException {
        this(jcf, INTERNAL_USER_NAME, logger);
        this.xac = xacf.createXAConnection();
    }

    protected synchronized boolean sessionOpen(Session s) {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.closed) {
            this.sessionlist.add(s);
            return true;
        }
        return false;
    }

    protected synchronized void sessionClose(Session s) {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.sessionlist.remove(s);
        if (this.sessionlist.size() == 0 && this.closed) {
            this.notify();
        }
    }

    public String getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        if (this.globaltx) {
            this.jcf.freeJConnection(this);
        } else {
            JConnection jConnection = this;
            synchronized (jConnection) {
                while (this.sessionlist.size() > 0) {
                    try {
                        this.logger.log(BasicLevel.DEBUG, (Object)"waiting for sessions to be finished");
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        System.out.println("JConnection.close: interrupted");
                    }
                }
            }
            this.closed = true;
            this.xac.close();
        }
    }

    public void finalClose() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.closed) {
            this.closed = true;
            this.xac.close();
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.xac.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.xac.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return new JSession(this, this.xac, this.logger);
    }

    public String getClientID() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.xac.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.xac.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.xac.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.xac.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.xac.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.xac.start();
    }

    public void stop() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.xac.stop();
    }
}

