/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: RollbackException.java 1506 2007-06-30 15:34:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction;
 
/**
 * RollbackException exception is thrown when the transaction has
 * been marked for rollback only or the transaction has been
 * rolled back instead of committed. This is a local exception
 * thrown by methods in the {@link UserTransaction},
 * {@link Transaction}, and {@link TransactionManager} interfaces.
 * @author Guillaume Sauthier
 */
public class RollbackException extends Exception {

    /**
     * Serial Version UID.
     * TODO Check for interop
     */
    private static final long serialVersionUID = 4151607774785285395L;

    /**
     * Creates a new RollbackException.
     */
    public RollbackException() {
        super();
    }

    /**
     * Creates a new RollbackException.
     * @param msg Exception message
     */
    public RollbackException(String msg) {
        super(msg);
    }

}
