/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.UrlStringUtils;

@Experimental
public class AutoconfAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final String CONFIGURE = "configure";
    private static final String CONFIGURE_IN = "configure.in";
    private static final String CONFIGURE_AC = "configure.ac";
    private static final String ANALYZER_NAME = "Autoconf Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String[] EXTENSIONS = new String[]{"ac", "in"};
    private static final Pattern PACKAGE_VAR = Pattern.compile("PACKAGE_(.+?)='(.*?)'", 34);
    private static final Pattern AC_INIT_PATTERN;
    private static final FileFilter FILTER;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.python.distribution.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File actualFile = dependency.getActualFile();
        String name = actualFile.getName();
        if (name.startsWith(CONFIGURE)) {
            String contents;
            File parent = actualFile.getParentFile();
            String parentName = parent.getName();
            dependency.setDisplayFileName(parentName + "/" + name);
            boolean isOutputScript = CONFIGURE.equals(name);
            if ((isOutputScript || CONFIGURE_AC.equals(name) || CONFIGURE_IN.equals(name)) && !(contents = this.getFileContents(actualFile)).isEmpty()) {
                if (isOutputScript) {
                    this.extractConfigureScriptEvidence(dependency, name, contents);
                } else {
                    this.gatherEvidence(dependency, name, contents);
                }
            }
        } else {
            engine.getDependencies().remove(dependency);
        }
    }

    private void extractConfigureScriptEvidence(Dependency dependency, String name, String contents) {
        Matcher matcher = PACKAGE_VAR.matcher(contents);
        while (matcher.find()) {
            String variable = matcher.group(1);
            String value = matcher.group(2);
            if (value.isEmpty()) continue;
            if (variable.endsWith("NAME")) {
                dependency.getProductEvidence().addEvidence(name, variable, value, Confidence.HIGHEST);
                continue;
            }
            if ("VERSION".equals(variable)) {
                dependency.getVersionEvidence().addEvidence(name, variable, value, Confidence.HIGHEST);
                continue;
            }
            if ("BUGREPORT".equals(variable)) {
                dependency.getVendorEvidence().addEvidence(name, variable, value, Confidence.HIGH);
                continue;
            }
            if (!"URL".equals(variable)) continue;
            dependency.getVendorEvidence().addEvidence(name, variable, value, Confidence.HIGH);
        }
    }

    private String getFileContents(File actualFile) throws AnalysisException {
        try {
            return FileUtils.readFileToString((File)actualFile, (Charset)Charset.defaultCharset()).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
    }

    private void gatherEvidence(Dependency dependency, String name, String contents) {
        Matcher matcher = AC_INIT_PATTERN.matcher(contents);
        if (matcher.find()) {
            String url;
            EvidenceCollection productEvidence = dependency.getProductEvidence();
            productEvidence.addEvidence(name, "Package", matcher.group(1), Confidence.HIGHEST);
            dependency.getVersionEvidence().addEvidence(name, "Package Version", matcher.group(2), Confidence.HIGHEST);
            EvidenceCollection vendorEvidence = dependency.getVendorEvidence();
            if (null != matcher.group(3)) {
                vendorEvidence.addEvidence(name, "Bug report address", matcher.group(4), Confidence.HIGH);
            }
            if (null != matcher.group(5)) {
                productEvidence.addEvidence(name, "Tarname", matcher.group(6), Confidence.HIGH);
            }
            if (null != matcher.group(7) && UrlStringUtils.isUrl(url = matcher.group(8))) {
                vendorEvidence.addEvidence(name, "URL", url, Confidence.HIGH);
            }
        }
    }

    @Override
    protected void initializeFileTypeAnalyzer() throws InitializationException {
    }

    static {
        String param = "\\[{0,2}(.+?)\\]{0,2}";
        String sepParam = "\\s*,\\s*\\[{0,2}(.+?)\\]{0,2}";
        AC_INIT_PATTERN = Pattern.compile(String.format("AC_INIT\\(%s%s(%s)?(%s)?(%s)?\\s*\\)", "\\[{0,2}(.+?)\\]{0,2}", "\\s*,\\s*\\[{0,2}(.+?)\\]{0,2}", "\\s*,\\s*\\[{0,2}(.+?)\\]{0,2}", "\\s*,\\s*\\[{0,2}(.+?)\\]{0,2}", "\\s*,\\s*\\[{0,2}(.+?)\\]{0,2}"), 34);
        FILTER = FileFilterBuilder.newInstance().addFilenames(CONFIGURE).addExtensions(EXTENSIONS).build();
    }
}

