/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nuget.NugetPackage;
import org.owasp.dependencycheck.data.nuget.NuspecParseException;
import org.owasp.dependencycheck.data.nuget.XPathNuspecParser;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuspecAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NuspecAnalyzer.class);
    private static final String ANALYZER_NAME = "Nuspec Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String SUPPORTED_EXTENSIONS = "nuspec";
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("nuspec").build();

    @Override
    public void initializeFileTypeAnalyzer() throws InitializationException {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nuspec.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        LOGGER.debug("Checking Nuspec file {}", (Object)dependency);
        try {
            XPathNuspecParser parser = new XPathNuspecParser();
            NugetPackage np = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(dependency.getActualFilePath());
                np = parser.parse(fis);
            }
            catch (NuspecParseException ex) {
                throw new AnalysisException(ex);
            }
            catch (FileNotFoundException ex) {
                throw new AnalysisException(ex);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LOGGER.debug("Error closing input stream");
                    }
                }
            }
            if (np.getOwners() != null) {
                dependency.getVendorEvidence().addEvidence(SUPPORTED_EXTENSIONS, "owners", np.getOwners(), Confidence.HIGHEST);
            }
            dependency.getVendorEvidence().addEvidence(SUPPORTED_EXTENSIONS, "authors", np.getAuthors(), Confidence.HIGH);
            dependency.getVersionEvidence().addEvidence(SUPPORTED_EXTENSIONS, "version", np.getVersion(), Confidence.HIGHEST);
            dependency.getProductEvidence().addEvidence(SUPPORTED_EXTENSIONS, "id", np.getId(), Confidence.HIGHEST);
            if (np.getTitle() != null) {
                dependency.getProductEvidence().addEvidence(SUPPORTED_EXTENSIONS, "title", np.getTitle(), Confidence.MEDIUM);
            }
        }
        catch (Throwable e) {
            throw new AnalysisException(e);
        }
    }
}

