/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.owasp.dependencycheck.xml.pom.License;

public class Model {
    private String name;
    private String organization;
    private String description;
    private String groupId;
    private String artifactId;
    private String version;
    private String parentGroupId;
    private String parentArtifactId;
    private String parentVersion;
    private final List<License> licenses = new ArrayList<License>();
    private String projectURL;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getParentGroupId() {
        return this.parentGroupId;
    }

    public void setParentGroupId(String parentGroupId) {
        this.parentGroupId = parentGroupId;
    }

    public String getParentArtifactId() {
        return this.parentArtifactId;
    }

    public void setParentArtifactId(String parentArtifactId) {
        this.parentArtifactId = parentArtifactId;
    }

    public String getParentVersion() {
        return this.parentVersion;
    }

    public void setParentVersion(String parentVersion) {
        this.parentVersion = parentVersion;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public void addLicense(License license) {
        this.licenses.add(license);
    }

    public String getProjectURL() {
        return this.projectURL;
    }

    public void setProjectURL(String projectURL) {
        this.projectURL = projectURL;
    }

    public void processProperties(Properties properties) {
        this.groupId = Model.interpolateString(this.groupId, properties);
        this.artifactId = Model.interpolateString(this.artifactId, properties);
        this.version = Model.interpolateString(this.version, properties);
        this.description = Model.interpolateString(this.description, properties);
        for (License l : this.getLicenses()) {
            l.setName(Model.interpolateString(l.getName(), properties));
            l.setUrl(Model.interpolateString(l.getUrl(), properties));
        }
        this.name = Model.interpolateString(this.name, properties);
        this.projectURL = Model.interpolateString(this.projectURL, properties);
        this.organization = Model.interpolateString(this.organization, properties);
        this.parentGroupId = Model.interpolateString(this.parentGroupId, properties);
        this.parentArtifactId = Model.interpolateString(this.parentArtifactId, properties);
        this.parentVersion = Model.interpolateString(this.parentVersion, properties);
    }

    public static String interpolateString(String text, Properties properties) {
        if (null == text || null == properties) {
            return text;
        }
        StrSubstitutor substitutor = new StrSubstitutor((StrLookup)new PropertyLookup(properties));
        return substitutor.replace(text);
    }

    private static class PropertyLookup
    extends StrLookup<String> {
        private final Properties props;

        PropertyLookup(Properties props) {
            this.props = props;
        }

        public String lookup(String key) {
            return this.props.getProperty(key);
        }
    }
}

