/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.ecosystem;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.data.nvd.ecosystem.DescriptionKeywordHint;
import org.owasp.dependencycheck.data.nvd.ecosystem.EcosystemHint;
import org.owasp.dependencycheck.data.nvd.ecosystem.EcosystemHintNature;
import org.owasp.dependencycheck.data.nvd.ecosystem.FileExtensionHint;
import org.owasp.dependencycheck.data.nvd.ecosystem.StringAhoCorasickDoubleArrayTrie;

public class DescriptionEcosystemMapper {
    private static final String[] ECOSYSTEMS;
    private static final int[] HINT_TO_ECOSYSTEM_LOOKUP;
    private static final TreeMap<String, EcosystemHint> ECOSYSTEM_MAP;
    private final boolean[] keywordPrefixes = DescriptionEcosystemMapper.getPrefixesFor(" -(\"'");
    private final boolean[] keywordPostfixes = DescriptionEcosystemMapper.getPrefixesFor(" -)\"',.:;");
    private final StringAhoCorasickDoubleArrayTrie<EcosystemHint> ahoCorasickDoubleArrayTrie = DescriptionEcosystemMapper.toAhoCorasickDoubleArrayTrie();

    protected static boolean[] getPrefixesFor(String str) {
        char c;
        int n = -1;
        for (int i = 0; i < str.length(); ++i) {
            if (c >= str.charAt(i)) continue;
            c = str.charAt(i);
        }
        boolean[] delimiters = new boolean[c + true];
        for (int i = 0; i < str.length(); ++i) {
            delimiters[str.charAt((int)i)] = true;
        }
        return delimiters;
    }

    protected static StringAhoCorasickDoubleArrayTrie<EcosystemHint> toAhoCorasickDoubleArrayTrie() {
        StringAhoCorasickDoubleArrayTrie<EcosystemHint> exact = new StringAhoCorasickDoubleArrayTrie<EcosystemHint>();
        exact.build(ECOSYSTEM_MAP);
        return exact;
    }

    protected static boolean isExtension(String str, int begin, int end) {
        if (str.length() != end && Character.isLetterOrDigit(str.charAt(end))) {
            return false;
        }
        return DescriptionEcosystemMapper.isLowercaseAscii(str, begin + 1, end);
    }

    protected static boolean isLowercaseAscii(String multicase, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = multicase.charAt(i);
            if (c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static boolean isURL(String c, int begin) {
        int pos = begin - 2;
        while (pos > 2) {
            if (c.charAt(--pos) == ' ') {
                return false;
            }
            if (c.charAt(pos) != ':') continue;
            return c.charAt(pos + 1) == '/' && c.charAt(pos + 2) == '/';
        }
        return false;
    }

    protected void increment(int i, int[] ecosystemMap) {
        int n = HINT_TO_ECOSYSTEM_LOOKUP[i];
        ecosystemMap[n] = ecosystemMap[n] + 1;
    }

    public String getEcosystem(DefCveItem cve) {
        int[] ecosystemMap = new int[ECOSYSTEMS.length];
        cve.getCve().getDescriptions().stream().filter(langString -> langString.getLang().equals("en")).forEachOrdered(langString -> this.search(langString.getValue(), ecosystemMap));
        return this.getResult(ecosystemMap);
    }

    public String getEcosystem(String multicase) {
        int[] ecosystemMap = new int[ECOSYSTEMS.length];
        this.search(multicase, ecosystemMap);
        return this.getResult(ecosystemMap);
    }

    private void search(String multicase, int[] ecosystemMap) {
        String c = multicase.toLowerCase();
        this.ahoCorasickDoubleArrayTrie.parseText(c, (AhoCorasickDoubleArrayTrie.IHitFull<EcosystemHint>)((AhoCorasickDoubleArrayTrie.IHitFull)(begin, end, value, index) -> {
            if (value.getNature() == EcosystemHintNature.FILE_EXTENSION) {
                if (!DescriptionEcosystemMapper.isExtension(multicase, begin, end)) {
                    return;
                }
                String ecosystem = value.getEcosystem();
                if ("php".equals(ecosystem) && c.regionMatches(begin, ".php", 0, 4) ? DescriptionEcosystemMapper.isURL(c, begin) : "java".equals(ecosystem) && c.regionMatches(begin, ".jsp", 0, 4) && DescriptionEcosystemMapper.isURL(c, begin)) {
                    return;
                }
            } else {
                char endChar;
                char startChar;
                if (!(begin == 0 || (startChar = c.charAt(begin - 1)) < this.keywordPrefixes.length && this.keywordPrefixes[startChar])) {
                    return;
                }
                if (!(end == c.length() || (endChar = c.charAt(end)) < this.keywordPostfixes.length && this.keywordPostfixes[endChar])) {
                    return;
                }
                String ecosystem = value.getEcosystem();
                if ("native".equals(ecosystem) && StringUtils.contains((CharSequence)c, (CharSequence)"android")) {
                    return;
                }
            }
            this.increment(index, ecosystemMap);
        }));
    }

    private String getResult(int[] values) {
        int best = this.getBestScore(values);
        if (best != -1) {
            return ECOSYSTEMS[best];
        }
        return null;
    }

    private int getBestScore(int[] values) {
        int bestIndex = -1;
        int bestScore = -1;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= 0) continue;
            if (values[i] > bestScore) {
                bestIndex = i;
                bestScore = values[i];
            }
            values[i] = 0;
        }
        return bestIndex;
    }

    static {
        ECOSYSTEM_MAP = new TreeMap();
        for (FileExtensionHint fileExtensionHint : FileExtensionHint.values()) {
            ECOSYSTEM_MAP.put(fileExtensionHint.getValue(), fileExtensionHint);
        }
        for (Enum enum_ : DescriptionKeywordHint.values()) {
            ECOSYSTEM_MAP.put(((DescriptionKeywordHint)enum_).getValue(), (EcosystemHint)((Object)enum_));
        }
        HashMap<String, Integer> ecosystemIndexes = new HashMap<String, Integer>();
        HINT_TO_ECOSYSTEM_LOOKUP = new int[ECOSYSTEM_MAP.size()];
        int index = 0;
        for (Map.Entry<String, EcosystemHint> entry : ECOSYSTEM_MAP.entrySet()) {
            EcosystemHint ecosystemHint = entry.getValue();
            Integer ecosystemIndex = (Integer)ecosystemIndexes.get(ecosystemHint.getEcosystem());
            if (ecosystemIndex == null) {
                ecosystemIndex = ecosystemIndexes.size();
                ecosystemIndexes.put(ecosystemHint.getEcosystem(), ecosystemIndex);
            }
            DescriptionEcosystemMapper.HINT_TO_ECOSYSTEM_LOOKUP[index] = ecosystemIndex;
            ++index;
        }
        ECOSYSTEMS = new String[ecosystemIndexes.size()];
        ecosystemIndexes.forEach((key, value) -> {
            DescriptionEcosystemMapper.ECOSYSTEMS[value.intValue()] = key;
        });
    }
}

