/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nexus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicHeader;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nexus.NexusSearch;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ForbiddenException;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.ToXMLDocumentResponseHandler;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@ThreadSafe
public class NexusV2Search
implements NexusSearch {
    private final URL rootURL;
    private final boolean useProxy;
    private final Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(NexusV2Search.class);

    public NexusV2Search(Settings settings, boolean useProxy) throws MalformedURLException {
        this.settings = settings;
        this.useProxy = useProxy;
        String searchUrl = settings.getString("analyzer.nexus.url");
        LOGGER.debug("Nexus Search URL: {}", (Object)searchUrl);
        this.rootURL = new URL(searchUrl);
    }

    @Override
    public MavenArtifact searchSha1(String sha1) throws IOException {
        if (null == sha1 || !sha1.matches("^[0-9A-Fa-f]{40}$")) {
            throw new IllegalArgumentException("Invalid SHA1 format");
        }
        URL url = new URL(this.rootURL, String.format("identify/sha1/%s", sha1.toLowerCase()));
        LOGGER.debug("Searching Nexus url {}", (Object)url);
        try {
            ToXMLDocumentResponseHandler handler = new ToXMLDocumentResponseHandler();
            Document doc = (Document)Downloader.getInstance().fetchAndHandle(url, (HttpClientResponseHandler)handler, List.of(new BasicHeader("Accept", (Object)ContentType.APPLICATION_XML)));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String groupId = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/groupId", doc);
            String artifactId = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/artifactId", doc);
            String version = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/version", doc);
            String link = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/artifactLink", doc);
            String pomLink = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/pomLink", doc);
            MavenArtifact ma = new MavenArtifact(groupId, artifactId, version);
            if (link != null && !link.isEmpty()) {
                ma.setArtifactUrl(link);
            }
            if (pomLink != null && !pomLink.isEmpty()) {
                ma.setPomUrl(pomLink);
            }
            return ma;
        }
        catch (DownloadFailedException | TooManyRequestsException e) {
            if (LOGGER.isDebugEnabled()) {
                int responseCode = -1;
                String responseMessage = "";
                if (e.getCause() instanceof HttpResponseException) {
                    HttpResponseException cause = (HttpResponseException)e.getCause();
                    responseCode = cause.getStatusCode();
                    responseMessage = cause.getReasonPhrase();
                }
                LOGGER.debug("Could not connect to Nexus received response code: {} {}", (Object)responseCode, (Object)responseMessage);
            }
            throw new IOException("Could not connect to Nexus");
        }
        catch (ResourceNotFoundException e) {
            throw new FileNotFoundException("Artifact not found in Nexus");
        }
        catch (URISyntaxException | XPathExpressionException | ForbiddenException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public boolean preflightRequest() {
        try {
            URL url = new URL(this.rootURL, "status");
            ToXMLDocumentResponseHandler handler = new ToXMLDocumentResponseHandler();
            Document doc = (Document)Downloader.getInstance().fetchAndHandle(url, (HttpClientResponseHandler)handler, List.of(new BasicHeader("Accept", (Object)ContentType.APPLICATION_XML)));
            if (!"status".equals(doc.getDocumentElement().getNodeName())) {
                LOGGER.warn("Pre-flight request to Nexus failed; expected root node name of status, got {}", (Object)doc.getDocumentElement().getNodeName());
                return false;
            }
        }
        catch (IOException | URISyntaxException | ResourceNotFoundException | TooManyRequestsException e) {
            LOGGER.warn("Pre-flight request to Nexus failed: ", e);
            return false;
        }
        return true;
    }
}

