/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.ossindex;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.joda.time.Duration;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.ossindex.service.client.OssindexClient;
import org.sonatype.ossindex.service.client.OssindexClientConfiguration;
import org.sonatype.ossindex.service.client.cache.CacheConfiguration;
import org.sonatype.ossindex.service.client.cache.DirectoryCache;
import org.sonatype.ossindex.service.client.internal.OssindexClientImpl;
import org.sonatype.ossindex.service.client.marshal.GsonMarshaller;
import org.sonatype.ossindex.service.client.marshal.Marshaller;
import org.sonatype.ossindex.service.client.transport.HttpUrlConnectionTransport;
import org.sonatype.ossindex.service.client.transport.Transport;
import org.sonatype.ossindex.service.client.transport.UserAgentSupplier;

public final class OssindexClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OssindexClientFactory.class);

    private OssindexClientFactory() {
    }

    public static OssindexClient create(final Settings settings) {
        OssindexClientConfiguration config = new OssindexClientConfiguration();
        String baseUrl = settings.getString("analyzer.ossindex.url", null);
        if (baseUrl != null) {
            config.setBaseUrl(baseUrl);
        }
        if (settings.getBoolean("analyzer.ossindex.use.cache", true)) {
            DirectoryCache.Configuration cache = new DirectoryCache.Configuration();
            try {
                File data = settings.getDataDirectory();
                File cacheDir = new File(data, "oss_cache");
                if (cacheDir.isDirectory() || cacheDir.mkdirs()) {
                    cache.setBaseDir(cacheDir.toPath());
                    cache.setExpireAfter(Duration.standardHours((long)24L));
                    config.setCacheConfiguration((CacheConfiguration)cache);
                    LOGGER.debug("OSS Index Cache: " + cache.toString());
                } else {
                    LOGGER.warn("Unable to use a cache for the OSS Index");
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to use a cache for the OSS Index", (Throwable)ex);
            }
        }
        final UserAgentSupplier userAgent = new UserAgentSupplier("dependency-check", settings.getString("application.version", "unknown"));
        HttpUrlConnectionTransport transport = new HttpUrlConnectionTransport(userAgent){
            private final URLConnectionFactory connectionFactory;
            {
                super(arg0);
                this.connectionFactory = new URLConnectionFactory(settings);
            }

            protected HttpURLConnection connect(URL url) throws IOException {
                HttpURLConnection connection = this.connectionFactory.createHttpURLConnection(url);
                connection.setRequestProperty("User-Agent", userAgent.get());
                return connection;
            }
        };
        GsonMarshaller marshaller = new GsonMarshaller();
        return new OssindexClientImpl(config, (Transport)transport, (Marshaller)marshaller);
    }

    static {
        PackageUrl.RenderFlavor.setDefault((PackageUrl.RenderFlavor)PackageUrl.RenderFlavor.SCHEME);
    }
}

