/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.jetbrains.annotations.NotNull;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.CpeSuppressionAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.cpe.CpeMemoryIndex;
import org.owasp.dependencycheck.data.cpe.IndexEntry;
import org.owasp.dependencycheck.data.cpe.IndexException;
import org.owasp.dependencycheck.data.cpe.MemoryIndex;
import org.owasp.dependencycheck.data.lucene.LuceneUtils;
import org.owasp.dependencycheck.data.lucene.SearchFieldAnalyzer;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.cpe.CpePlus;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeBuilder;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

@ThreadSafe
public class CPEAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPEAnalyzer.class);
    private static final int MAX_QUERY_RESULTS = 100;
    private static final int WEIGHTING_BOOST = 1;
    private static final String CLEANSE_CHARACTER_RX = "[^A-Za-z0-9 ._:/-]";
    private static final String CLEANSE_NONALPHA_RX = "[^A-Za-z]*";
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    public static final String NVD_SEARCH_URL = "https://nvd.nist.gov/vuln/search/results?form_type=Advanced&results_type=overview&search_type=all&cpe_vendor=cpe%%3A%%2F%%3A%1$s&cpe_product=cpe%%3A%%2F%%3A%1$s%%3A%2$s&cpe_version=cpe%%3A%%2F%%3A%1$s%%3A%2$s%%3A%3$s";
    public static final String NVD_SEARCH_BROAD_URL = "https://nvd.nist.gov/vuln/search/results?form_type=Advanced&results_type=overview&search_type=all&cpe_vendor=cpe%%3A%%2F%%3A%1$s&cpe_product=cpe%%3A%%2F%%3A%1$s%%3A%2$s";
    private MemoryIndex cpe;
    private CveDB cve;
    private List<String> skipEcosystems;
    private CpeSuppressionAnalyzer suppression;

    @Override
    public String getName() {
        return "CPE Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.IDENTIFIER_ANALYSIS;
    }

    @Override
    public void prepareAnalyzer(Engine engine) throws InitializationException {
        super.prepareAnalyzer(engine);
        try {
            this.open(engine.getDatabase());
        }
        catch (IOException ex) {
            LOGGER.debug("Exception initializing the Lucene Index", (Throwable)ex);
            throw new InitializationException("An exception occurred initializing the Lucene Index", ex);
        }
        catch (DatabaseException ex) {
            LOGGER.debug("Exception accessing the database", (Throwable)ex);
            throw new InitializationException("An exception occurred accessing the database", ex);
        }
        Object[] tmp = engine.getSettings().getArray("ecosystem.skip.cpeanalyzer");
        if (tmp == null) {
            this.skipEcosystems = new ArrayList<String>();
        } else {
            LOGGER.debug("Skipping CPE Analysis for {}", (Object)StringUtils.join((Object[])tmp, (String)","));
            this.skipEcosystems = Arrays.asList(tmp);
        }
        this.suppression = new CpeSuppressionAnalyzer();
        this.suppression.initialize(engine.getSettings());
        this.suppression.prepareAnalyzer(engine);
    }

    public void open(CveDB cve) throws IOException, DatabaseException {
        this.cve = cve;
        this.cpe = CpeMemoryIndex.getInstance();
        try {
            long creationStart = System.currentTimeMillis();
            this.cpe.open(cve.getVendorProductList(), this.getSettings());
            long creationSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - creationStart);
            LOGGER.info("Created CPE Index ({} seconds)", (Object)creationSeconds);
        }
        catch (IndexException ex) {
            LOGGER.debug("IndexException", (Throwable)ex);
            throw new DatabaseException(ex);
        }
    }

    @Override
    public void closeAnalyzer() {
        if (this.cpe != null) {
            this.cpe.close();
            this.cpe = null;
        }
    }

    protected void determineCPE(Dependency dependency) throws CorruptIndexException, IOException, ParseException, AnalysisException {
        HashMap<String, MutableInt> vendors = new HashMap<String, MutableInt>();
        HashMap<String, MutableInt> products = new HashMap<String, MutableInt>();
        HashSet<Integer> previouslyFound = new HashSet<Integer>();
        for (Confidence confidence : Confidence.values()) {
            List<IndexEntry> entries;
            this.collectTerms(vendors, dependency.getIterator(EvidenceType.VENDOR, confidence));
            LOGGER.debug("vendor search: {}", vendors);
            this.collectTerms(products, dependency.getIterator(EvidenceType.PRODUCT, confidence));
            LOGGER.debug("product search: {}", products);
            if (vendors.isEmpty() || products.isEmpty() || (entries = this.searchCPE(vendors, products, dependency.getVendorWeightings(), dependency.getProductWeightings())) == null) continue;
            boolean identifierAdded = false;
            for (IndexEntry e : entries) {
                if (previouslyFound.contains(e.getDocumentId())) continue;
                previouslyFound.add(e.getDocumentId());
                if (!this.verifyEntry(e, dependency)) continue;
                String vendor = e.getVendor();
                String product = e.getProduct();
                LOGGER.debug("identified vendor/product: {}/{}", (Object)vendor, (Object)product);
                identifierAdded |= this.determineIdentifiers(dependency, vendor, product, confidence);
            }
            if (identifierAdded) break;
        }
    }

    protected void collectTerms(Map<String, MutableInt> terms, Iterable<Evidence> evidence) {
        for (Evidence e : evidence) {
            MutableInt count;
            String value = this.cleanseText(e.getValue());
            if (StringUtils.isBlank((CharSequence)value)) continue;
            if (value.length() > 1000) {
                boolean trimmed = false;
                int pos = value.lastIndexOf(" ", 1000);
                if (pos > 0) {
                    value = value.substring(0, pos);
                    trimmed = true;
                } else {
                    pos = value.lastIndexOf(".", 1000);
                }
                if (!trimmed) {
                    if (pos > 0) {
                        value = value.substring(0, pos);
                        trimmed = true;
                    } else {
                        pos = value.lastIndexOf("-", 1000);
                    }
                }
                if (!trimmed) {
                    if (pos > 0) {
                        value = value.substring(0, pos);
                        trimmed = true;
                    } else {
                        pos = value.lastIndexOf("_", 1000);
                    }
                }
                if (!trimmed) {
                    if (pos > 0) {
                        value = value.substring(0, pos);
                        trimmed = true;
                    } else {
                        pos = value.lastIndexOf("/", 1000);
                    }
                }
                if (!trimmed && pos > 0) {
                    value = value.substring(0, pos);
                    trimmed = true;
                }
                if (!trimmed) {
                    value = value.substring(0, 1000);
                }
            }
            if ((count = terms.get(value)) == null) {
                terms.put(value, new MutableInt(1));
                continue;
            }
            count.add(1);
        }
    }

    protected List<IndexEntry> searchCPE(Map<String, MutableInt> vendor, Map<String, MutableInt> product, Set<String> vendorWeightings, Set<String> productWeightings) {
        ArrayList<IndexEntry> ret = new ArrayList<IndexEntry>(100);
        String searchString = this.buildSearch(vendor, product, vendorWeightings, productWeightings);
        if (searchString == null) {
            return ret;
        }
        try {
            Query query = this.cpe.parseQuery(searchString);
            TopDocs docs = this.cpe.search(query, 100);
            for (ScoreDoc d : docs.scoreDocs) {
                Document doc = this.cpe.getDocument(d.doc);
                IndexEntry entry = new IndexEntry();
                entry.setDocumentId(d.doc);
                entry.setVendor(doc.get("vendor"));
                entry.setProduct(doc.get("product"));
                entry.setSearchScore(d.score);
                if (ret.contains(entry)) continue;
                ret.add(entry);
            }
            return ret;
        }
        catch (ParseException ex) {
            LOGGER.warn("An error occurred querying the CPE data. See the log for more details.");
            LOGGER.info("Unable to parse: {}", (Object)searchString, (Object)ex);
        }
        catch (IndexException ex) {
            LOGGER.warn("An error occurred resetting the CPE index searcher. See the log for more details.");
            LOGGER.info("Unable to reset the search analyzer", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.warn("An error occurred reading CPE data. See the log for more details.");
            LOGGER.info("IO Error with search string: {}", (Object)searchString, (Object)ex);
        }
        return null;
    }

    protected String buildSearch(Map<String, MutableInt> vendor, Map<String, MutableInt> product, Set<String> vendorWeighting, Set<String> productWeightings) {
        StringBuilder sb = new StringBuilder();
        if (!this.appendWeightedSearch(sb, "product", product, productWeightings)) {
            return null;
        }
        sb.append(" AND ");
        if (!this.appendWeightedSearch(sb, "vendor", vendor, vendorWeighting)) {
            return null;
        }
        return sb.toString();
    }

    private boolean appendWeightedSearch(StringBuilder sb, String field, Map<String, MutableInt> terms, Set<String> weightedText) {
        if (terms.isEmpty()) {
            return false;
        }
        sb.append(field).append(":(");
        boolean addSpace = false;
        boolean addedTerm = false;
        for (Map.Entry<String, MutableInt> entry : terms.entrySet()) {
            String[] text;
            StringBuilder boostedTerms = new StringBuilder();
            int weighting = entry.getValue().intValue();
            for (String word : text = entry.getKey().split(" ")) {
                if (word.isEmpty()) continue;
                if (addSpace) {
                    sb.append(" ");
                } else {
                    addSpace = true;
                }
                addedTerm = true;
                if (LuceneUtils.isKeyword(word)) {
                    sb.append("\"");
                    LuceneUtils.appendEscapedLuceneQuery(sb, word);
                    sb.append("\"");
                } else {
                    LuceneUtils.appendEscapedLuceneQuery(sb, word);
                }
                String boostTerm = this.findBoostTerm(word, weightedText);
                if (boostTerm != null) {
                    sb.append("^").append(weighting + 1);
                    if (boostTerm.equals(word)) continue;
                    boostedTerms.append(" ").append(boostTerm).append("^").append(weighting + 1);
                    continue;
                }
                if (weighting <= 1) continue;
                sb.append("^").append(weighting);
            }
            if (boostedTerms.length() <= 0) continue;
            sb.append((CharSequence)boostedTerms);
        }
        sb.append(")");
        return addedTerm;
    }

    private String cleanseText(String text) {
        return text.replaceAll(CLEANSE_CHARACTER_RX, " ");
    }

    private String findBoostTerm(String term, Set<String> boost) {
        for (String entry : boost) {
            if (!this.equalsIgnoreCaseAndNonAlpha(term, entry)) continue;
            return entry;
        }
        return null;
    }

    private boolean equalsIgnoreCaseAndNonAlpha(String l, String r) {
        if (l == null || r == null) {
            return false;
        }
        String left = l.replaceAll(CLEANSE_NONALPHA_RX, "");
        String right = r.replaceAll(CLEANSE_NONALPHA_RX, "");
        return left.equalsIgnoreCase(right);
    }

    private boolean verifyEntry(IndexEntry entry, Dependency dependency) {
        boolean isValid = false;
        if (this.collectionContainsString(dependency.getEvidence(EvidenceType.PRODUCT), entry.getProduct()) && this.collectionContainsString(dependency.getEvidence(EvidenceType.VENDOR), entry.getVendor())) {
            isValid = true;
        }
        return isValid;
    }

    private boolean collectionContainsString(Set<Evidence> evidence, String text) {
        if (text == null) {
            return false;
        }
        String textLC = text.toLowerCase();
        for (Evidence e2 : evidence) {
            if (!e2.getValue().toLowerCase().equals(textLC)) continue;
            return true;
        }
        String[] words = text.split("[\\s_-]+");
        ArrayList<String> list = new ArrayList<String>();
        String tempWord = null;
        CharArraySet stopWords = SearchFieldAnalyzer.getStopWords();
        for (String word : words) {
            if (tempWord != null) {
                list.add(tempWord + word);
                tempWord = null;
                continue;
            }
            if (word.length() <= 2) {
                tempWord = word;
                continue;
            }
            if (stopWords.contains((CharSequence)word)) continue;
            list.add(word);
        }
        if (tempWord != null) {
            if (!list.isEmpty()) {
                String tmp = (String)list.get(list.size() - 1) + tempWord;
                list.add(tmp);
            } else {
                list.add(tempWord);
            }
        }
        if (list.isEmpty()) {
            return false;
        }
        boolean isValid = true;
        ArrayList evidenceValues = new ArrayList(evidence.size());
        evidence.forEach(e -> evidenceValues.add(e.getValue().toLowerCase().replaceAll("[\\s_-]+", "")));
        for (String word : list) {
            word = word.toLowerCase();
            boolean found = false;
            for (String e3 : evidenceValues) {
                if (!e3.contains(word) || "http".equals(word) && e3.contains("http:")) continue;
                found = true;
                break;
            }
            isValid &= found;
        }
        return isValid;
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.skipEcosystems.contains(dependency.getEcosystem())) {
            return;
        }
        try {
            this.determineCPE(dependency);
        }
        catch (CorruptIndexException ex) {
            throw new AnalysisException("CPE Index is corrupt.", ex);
        }
        catch (IOException ex) {
            throw new AnalysisException("Failure opening the CPE Index.", ex);
        }
        catch (ParseException ex) {
            throw new AnalysisException("Unable to parse the generated Lucene query for this dependency.", ex);
        }
    }

    protected boolean determineIdentifiers(Dependency dependency, String vendor, String product, Confidence currentConfidence) throws UnsupportedEncodingException, AnalysisException {
        Cpe guessCpe;
        CpeBuilder cpeBuilder = new CpeBuilder();
        Set<CpePlus> cpePlusEntries = this.cve.getCPEs(vendor, product);
        Set<Cpe> cpes = this.filterEcosystem(dependency.getEcosystem(), cpePlusEntries);
        if (cpes == null || cpes.isEmpty()) {
            return false;
        }
        DependencyVersion bestGuess = "Golang".equals(dependency.getEcosystem()) && dependency.getVersion() == null ? new DependencyVersion("*") : new DependencyVersion("-");
        Object bestGuessUpdate = null;
        Confidence bestGuessConf = null;
        String bestGuessURL = null;
        HashSet<IdentifierMatch> collected = new HashSet<IdentifierMatch>();
        if (dependency.getVersion() != null && !dependency.getVersion().isEmpty()) {
            DependencyVersion depVersion;
            boolean useDependencyVersion = true;
            CharArraySet stopWords = SearchFieldAnalyzer.getStopWords();
            if (dependency.getName() != null && !dependency.getName().isEmpty()) {
                String name = dependency.getName();
                for (String word : product.split("[^a-zA-Z0-9]")) {
                    useDependencyVersion &= name.contains(word) || stopWords.contains((CharSequence)word);
                }
            }
            if (useDependencyVersion && (depVersion = new DependencyVersion(dependency.getVersion())).getVersionParts().size() > 0) {
                cpeBuilder.part(Part.APPLICATION).vendor(vendor).product(product);
                int idx = depVersion.getVersionParts().size() - 1;
                if (idx > 0 && depVersion.getVersionParts().get(idx).matches("^(v|release|snapshot|beta|alpha|u|rc|m|20\\d\\d).*$")) {
                    cpeBuilder.version(StringUtils.join(depVersion.getVersionParts().subList(0, idx), (String)"."));
                    if (depVersion.getVersionParts().get(idx).matches("^v\\d.*$")) {
                        cpeBuilder.update(depVersion.getVersionParts().get(idx).substring(1));
                    } else {
                        cpeBuilder.update(depVersion.getVersionParts().get(idx));
                    }
                } else {
                    cpeBuilder.version(depVersion.toString());
                }
                try {
                    Cpe depCpe = cpeBuilder.build();
                    String url = String.format(NVD_SEARCH_URL, URLEncoder.encode(vendor, UTF8), URLEncoder.encode(product, UTF8), URLEncoder.encode(depCpe.getVersion(), UTF8));
                    IdentifierMatch match = new IdentifierMatch(depCpe, url, IdentifierConfidence.EXACT_MATCH, currentConfidence);
                    collected.add(match);
                }
                catch (CpeValidationException ex) {
                    throw new AnalysisException(String.format("Unable to create a CPE for %s:%s:%s", vendor, product, bestGuess.toString()));
                }
            }
        }
        for (Confidence conf : Confidence.values()) {
            for (Evidence evidence : dependency.getIterator(EvidenceType.VERSION, conf)) {
                Object checkUpdate;
                DependencyVersion evVer = DependencyVersionUtil.parseVersion(evidence.getValue(), true);
                if (evVer == null) continue;
                DependencyVersion evBaseVer = null;
                Object evBaseVerUpdate = null;
                int idx = evVer.getVersionParts().size() - 1;
                if (evVer.getVersionParts().get(idx).matches("^(v|release|snapshot|beta|alpha|u|rc|m|20\\d\\d).*$") && ((String)(checkUpdate = evVer.getVersionParts().get(idx))).matches("^(v|release|snapshot|beta|alpha|u|rc|m|20\\d\\d).*$")) {
                    evBaseVerUpdate = checkUpdate;
                    evBaseVer = new DependencyVersion();
                    evBaseVer.setVersionParts(evVer.getVersionParts().subList(0, idx));
                }
                checkUpdate = cpes.iterator();
                while (checkUpdate.hasNext()) {
                    String url;
                    DependencyVersion dbVer;
                    Cpe vs = (Cpe)checkUpdate.next();
                    DependencyVersion dbVerUpdate = dbVer = DependencyVersionUtil.parseVersion(vs.getVersion());
                    if (!(vs.getUpdate() == null || vs.getUpdate().isEmpty() || vs.getUpdate().startsWith("*") || vs.getUpdate().startsWith("-"))) {
                        dbVerUpdate = DependencyVersionUtil.parseVersion(vs.getVersion() + '.' + vs.getUpdate(), true);
                    }
                    if (dbVer == null) {
                        url = String.format(NVD_SEARCH_BROAD_URL, URLEncoder.encode(vs.getVendor(), UTF8), URLEncoder.encode(vs.getProduct(), UTF8));
                        IdentifierMatch match = new IdentifierMatch(vs, url, IdentifierConfidence.BROAD_MATCH, conf);
                        collected.add(match);
                        continue;
                    }
                    if (evVer.equals(dbVer)) {
                        Cpe useCpe;
                        url = String.format(NVD_SEARCH_URL, URLEncoder.encode(vs.getVendor(), UTF8), URLEncoder.encode(vs.getProduct(), UTF8), URLEncoder.encode(vs.getVersion(), UTF8));
                        if (evBaseVerUpdate != null && "*".equals(vs.getUpdate())) {
                            try {
                                useCpe = cpeBuilder.part(vs.getPart()).wfVendor(vs.getWellFormedVendor()).wfProduct(vs.getWellFormedProduct()).wfVersion(vs.getWellFormedVersion()).wfEdition(vs.getWellFormedEdition()).wfLanguage(vs.getWellFormedLanguage()).wfOther(vs.getWellFormedOther()).wfSwEdition(vs.getWellFormedSwEdition()).update((String)evBaseVerUpdate).build();
                            }
                            catch (CpeValidationException ex) {
                                LOGGER.debug("Error building cpe with update:" + (String)evBaseVerUpdate, (Throwable)ex);
                                useCpe = vs;
                            }
                        } else {
                            useCpe = vs;
                        }
                        IdentifierMatch match = new IdentifierMatch(useCpe, url, IdentifierConfidence.EXACT_MATCH, conf);
                        collected.add(match);
                        continue;
                    }
                    if (evBaseVer != null && evBaseVer.equals(dbVer) && (bestGuessConf == null || bestGuessConf.compareTo(conf) > 0)) {
                        bestGuessConf = conf;
                        bestGuess = dbVer;
                        bestGuessUpdate = evBaseVerUpdate;
                        bestGuessURL = String.format(NVD_SEARCH_URL, URLEncoder.encode(vs.getVendor(), UTF8), URLEncoder.encode(vs.getProduct(), UTF8), URLEncoder.encode(vs.getVersion(), UTF8));
                        continue;
                    }
                    if (dbVerUpdate == null || evVer.getVersionParts().size() > dbVerUpdate.getVersionParts().size() || !evVer.matchesAtLeastThreeLevels(dbVerUpdate) || bestGuessConf != null && bestGuessConf.compareTo(conf) <= 0 || bestGuess.getVersionParts().size() >= dbVer.getVersionParts().size()) continue;
                    bestGuess = dbVer;
                    bestGuessUpdate = evBaseVerUpdate;
                    bestGuessConf = conf;
                }
                if (bestGuessConf != null && bestGuessConf.compareTo(conf) <= 0 || bestGuess.getVersionParts().size() >= evVer.getVersionParts().size()) continue;
                bestGuess = evVer;
                bestGuessUpdate = evBaseVerUpdate;
                bestGuessConf = conf;
            }
        }
        cpeBuilder.part(Part.APPLICATION).vendor(vendor).product(product);
        int idx = bestGuess.getVersionParts().size() - 1;
        if (bestGuess.getVersionParts().get(idx).matches("^(v|release|snapshot|beta|alpha|u|rc|m|20\\d\\d).*$")) {
            cpeBuilder.version(StringUtils.join(bestGuess.getVersionParts().subList(0, idx), (String)"."));
            if (bestGuess.getVersionParts().get(idx).matches("^v\\d.*$")) {
                cpeBuilder.update(bestGuess.getVersionParts().get(idx).substring(1));
            } else {
                cpeBuilder.update(bestGuess.getVersionParts().get(idx));
            }
        } else {
            cpeBuilder.version(bestGuess.toString());
            if (bestGuessUpdate != null) {
                cpeBuilder.update(bestGuessUpdate);
            }
        }
        try {
            guessCpe = cpeBuilder.build();
        }
        catch (CpeValidationException ex) {
            throw new AnalysisException(String.format("Unable to create a CPE for %s:%s:%s", vendor, product, bestGuess.toString()));
        }
        if (!"-".equals(guessCpe.getVersion())) {
            String url = null;
            if (bestGuessURL != null) {
                url = bestGuessURL;
            }
            if (bestGuessConf == null) {
                bestGuessConf = Confidence.LOW;
            }
            IdentifierMatch match = new IdentifierMatch(guessCpe, url, IdentifierConfidence.BEST_GUESS, bestGuessConf);
            collected.add(match);
        }
        boolean identifierAdded = false;
        if (!collected.isEmpty()) {
            ArrayList items = new ArrayList(collected);
            Collections.sort(items);
            IdentifierConfidence bestIdentifierQuality = ((IdentifierMatch)items.get(0)).getIdentifierConfidence();
            Confidence bestEvidenceQuality = ((IdentifierMatch)items.get(0)).getEvidenceConfidence();
            boolean addedNonGuess = false;
            Confidence prevAddedConfidence = dependency.getVulnerableSoftwareIdentifiers().stream().map(id -> id.getConfidence()).min(Comparator.comparing(Enum::ordinal)).orElse(Confidence.LOW);
            for (IdentifierMatch m : items) {
                if (!bestIdentifierQuality.equals((Object)m.getIdentifierConfidence()) || !bestEvidenceQuality.equals((Object)m.getEvidenceConfidence())) continue;
                CpeIdentifier i = m.getIdentifier();
                if (bestIdentifierQuality == IdentifierConfidence.BEST_GUESS) {
                    if (addedNonGuess) continue;
                    i.setConfidence(Confidence.LOW);
                } else {
                    i.setConfidence(bestEvidenceQuality);
                }
                if (prevAddedConfidence.compareTo(i.getConfidence()) < 0) continue;
                dependency.addVulnerableSoftwareIdentifier(i);
                this.suppression.analyze(dependency, null);
                if (!dependency.getVulnerableSoftwareIdentifiers().contains(i)) continue;
                identifierAdded = true;
                if (addedNonGuess || bestIdentifierQuality == IdentifierConfidence.BEST_GUESS) continue;
                addedNonGuess = true;
            }
        }
        return identifierAdded;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.cpe.enabled";
    }

    private Set<Cpe> filterEcosystem(String ecosystem, Set<CpePlus> entries) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        if (ecosystem != null) {
            return entries.stream().filter(c -> {
                if (c.getEcosystem() == null) {
                    return true;
                }
                switch (c.getEcosystem()) {
                    case "Java": 
                    case "java": {
                        return ecosystem.equals("Java");
                    }
                    case "dotnet": 
                    case "nuget": 
                    case "asp.net": {
                        return ecosystem.equals("nuget") || ecosystem.equals("dotnet");
                    }
                    case "js": 
                    case "jquery": {
                        return ecosystem.equals("js");
                    }
                    case "python": {
                        return ecosystem.equals("python");
                    }
                    case "CMAKE": 
                    case "borland_c++": 
                    case "c/c++": 
                    case "gnu_c++": {
                        return ecosystem.equals("CMAKE");
                    }
                    case "Composer": 
                    case "drupal": 
                    case "joomla": 
                    case "joomla!": 
                    case "moodle": 
                    case "phpcms": 
                    case "piwigo": 
                    case "simplesamlphp": 
                    case "symfony": 
                    case "typo3": {
                        return ecosystem.equals("Composer");
                    }
                    case "npm": 
                    case "node.js": 
                    case "nodejs": {
                        return ecosystem.equals("npm");
                    }
                    case "ruby": 
                    case "rails": {
                        return ecosystem.equals("ruby");
                    }
                    case "perl": 
                    case "elixir": 
                    case "delphi": {
                        return false;
                    }
                }
                return true;
            }).map(c -> c.getCpe()).collect(Collectors.toSet());
        }
        return entries.stream().map(c -> c.getCpe()).collect(Collectors.toSet());
    }

    public static void main(String[] args) {
        Settings props = new Settings();
        try {
            Engine en = new Engine(Engine.Mode.EVIDENCE_PROCESSING, props);
            Throwable throwable = null;
            try {
                try {
                    en.openDatabase(false, false);
                    CPEAnalyzer analyzer = new CPEAnalyzer();
                    analyzer.initialize(props);
                    analyzer.prepareAnalyzer(en);
                    LOGGER.error("test");
                    System.out.println("Memory index query for ODC");
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                    Throwable throwable2 = null;
                    try {
                        try {
                            while (true) {
                                MutableInt count;
                                String[] parts;
                                HashMap<String, MutableInt> vendor = new HashMap<String, MutableInt>();
                                HashMap<String, MutableInt> product = new HashMap<String, MutableInt>();
                                System.out.print("Vendor: ");
                                for (String term : parts = br.readLine().split(" ")) {
                                    count = (MutableInt)vendor.get(term);
                                    if (count == null) {
                                        vendor.put(term, new MutableInt(0));
                                        continue;
                                    }
                                    count.add(1);
                                }
                                System.out.print("Product: ");
                                for (String term : parts = br.readLine().split(" ")) {
                                    count = (MutableInt)product.get(term);
                                    if (count == null) {
                                        product.put(term, new MutableInt(0));
                                        continue;
                                    }
                                    count.add(1);
                                }
                                List<IndexEntry> list = analyzer.searchCPE(vendor, product, new HashSet<String>(), new HashSet<String>());
                                if (list == null || list.isEmpty()) {
                                    System.out.println("No results found");
                                } else {
                                    list.forEach(e -> System.out.println(String.format("%s:%s (%f)", e.getVendor(), e.getProduct(), Float.valueOf(e.getSearchScore()))));
                                }
                                System.out.println();
                                System.out.println();
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        CPEAnalyzer.$closeResource(throwable2, br);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            catch (Throwable throwable6) {
                CPEAnalyzer.$closeResource(throwable, en);
                throw throwable6;
            }
        }
        catch (IOException | InitializationException ex) {
            System.err.println("Lucene ODC search tool failed:");
            System.err.println(ex.getMessage());
            return;
        }
    }

    protected void setCveDB(CveDB cveDb) {
        this.cve = cveDb;
    }

    protected CveDB getCveDB() {
        return this.cve;
    }

    protected void setMemoryIndex(MemoryIndex idx) {
        this.cpe = idx;
    }

    protected MemoryIndex getMemoryIndex() {
        return this.cpe;
    }

    protected void setCpeSuppressionAnalyzer(CpeSuppressionAnalyzer suppression) {
        this.suppression = suppression;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private static class IdentifierMatch
    implements Comparable<IdentifierMatch> {
        private IdentifierConfidence identifierConfidence;
        private CpeIdentifier identifier;

        IdentifierMatch(Cpe cpe, String url, IdentifierConfidence identifierConfidence, Confidence evidenceConfidence) {
            this.identifier = new CpeIdentifier(cpe, url, evidenceConfidence);
            this.identifierConfidence = identifierConfidence;
        }

        public Confidence getEvidenceConfidence() {
            return this.identifier.getConfidence();
        }

        public void setEvidenceConfidence(Confidence evidenceConfidence) {
            this.identifier.setConfidence(evidenceConfidence);
        }

        public IdentifierConfidence getIdentifierConfidence() {
            return this.identifierConfidence;
        }

        public void setIdentifierConfidence(IdentifierConfidence confidence) {
            this.identifierConfidence = confidence;
        }

        public CpeIdentifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(CpeIdentifier identifier) {
            this.identifier = identifier;
        }

        public String toString() {
            return "IdentifierMatch{ IdentifierConfidence=" + (Object)((Object)this.identifierConfidence) + ", identifier=" + this.identifier + '}';
        }

        public int hashCode() {
            return new HashCodeBuilder(115, 303).append((Object)this.identifierConfidence).append((Object)this.identifier).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof IdentifierMatch)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            IdentifierMatch other = (IdentifierMatch)obj;
            return new EqualsBuilder().append((Object)this.identifierConfidence, (Object)other.identifierConfidence).append((Object)this.identifier, (Object)other.identifier).build();
        }

        @Override
        public int compareTo(@NotNull IdentifierMatch o) {
            return new CompareToBuilder().append((Object)this.identifierConfidence, (Object)o.identifierConfidence).append((Object)this.identifier, (Object)o.identifier).toComparison();
        }
    }

    private static enum IdentifierConfidence {
        EXACT_MATCH,
        BEST_GUESS,
        BROAD_MATCH;

    }
}

