/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.elixir.MixAuditJsonParser;
import org.owasp.dependencycheck.data.elixir.MixAuditResult;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.CvssV2;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

@Experimental
public class ElixirMixAuditAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElixirMixAuditAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "elixir";
    private static final String ANALYZER_NAME = "Elixir Mix Audit Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.PRE_INFORMATION_COLLECTION;
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addFilenames("mix.lock").build();
    public static final String NAME = "Name: ";
    public static final String VERSION = "Version: ";
    public static final String ADVISORY = "Advisory: ";
    public static final String CRITICALITY = "Criticality: ";
    private CveDB cvedb = null;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        String mixAuditVersionDetails;
        int exitValue;
        Process process;
        if (engine != null) {
            this.cvedb = engine.getDatabase();
        }
        try {
            ImmutableList mixAuditArgs = ImmutableList.of((Object)"--version");
            process = this.launchMixAudit(this.getSettings().getTempDirectory(), (List<String>)mixAuditArgs);
        }
        catch (AnalysisException ae) {
            this.setEnabled(false);
            String msg = String.format("Exception from mix_audit process: %s. Disabling %s", ae.getCause(), ANALYZER_NAME);
            throw new InitializationException(msg, ae);
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unable to create temporary file, the Mix Audit Analyzer will be disabled", ex);
        }
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException ex) {
            this.setEnabled(false);
            String msg = String.format("mix_audit process was interrupted. Disabling %s", ANALYZER_NAME);
            Thread.currentThread().interrupt();
            throw new InitializationException(msg);
        }
        if (exitValue != 0) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    try {
                        if (!reader.ready()) {
                            LOGGER.warn("Unexpected exit value from mix_audit process and error stream unexpectedly not ready to capture error details. Disabling {}. Exit value was: {}", (Object)ANALYZER_NAME, (Object)exitValue);
                            this.setEnabled(false);
                            throw new InitializationException("mix_audit error stream unexpectedly not ready.");
                        }
                        String line = reader.readLine();
                        this.setEnabled(false);
                        LOGGER.warn("Unexpected exit value from mix_audit process. Disabling {}. Exit value was: {}. error stream output from mix_audit process was: {}", new Object[]{ANALYZER_NAME, exitValue, line});
                        throw new InitializationException("Unexpected exit value from bundle-audit process.");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    ElixirMixAuditAnalyzer.$closeResource(throwable, reader);
                    throw throwable3;
                }
            }
            catch (UnsupportedEncodingException ex) {
                this.setEnabled(false);
                throw new InitializationException("Unexpected mix_audit encoding when reading error stream.", ex);
            }
            catch (IOException ex) {
                this.setEnabled(false);
                throw new InitializationException("Unable to read mix_audit output from error stream.", ex);
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            if (!reader.ready()) {
                LOGGER.warn("mix_audit input stream unexpectedly not ready to capture version details. Disabling {}", (Object)ANALYZER_NAME);
                this.setEnabled(false);
                throw new InitializationException("mix_audit input stream unexpectedly not ready to capture version details.");
            }
            mixAuditVersionDetails = reader.readLine();
        }
        catch (UnsupportedEncodingException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unexpected mix_audit encoding when reading input stream.", ex);
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unable to read mix_audit output from input stream.", ex);
        }
        if (this.isEnabled()) {
            LOGGER.info("{} is enabled and is using mix_audit with version: {}.", (Object)ANALYZER_NAME, (Object)mixAuditVersionDetails);
        }
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.mix.audit.enabled";
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    private Process launchMixAudit(File folder, List<String> mixAuditArgs) throws AnalysisException {
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        ArrayList<String> args = new ArrayList<String>();
        String mixAuditPath = this.getSettings().getString("analyzer.mix.audit.path");
        File mixAudit = null;
        if (mixAuditPath != null) {
            mixAudit = new File(mixAuditPath);
            if (!mixAudit.isFile()) {
                LOGGER.warn("Supplied `mixAudit` path is incorrect: {}", (Object)mixAuditPath);
                mixAudit = null;
            }
        } else {
            Path homePath = Paths.get(System.getProperty("user.home"), new String[0]);
            Path escriptPath = Paths.get(homePath.toString(), ".mix", "escripts", "mix_audit");
            mixAudit = escriptPath.toFile();
        }
        args.add(mixAudit != null ? mixAudit.getAbsolutePath() : "mix_audit");
        args.addAll(mixAuditArgs);
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(folder);
        try {
            LOGGER.info("Launching: {} from {}", args, (Object)folder);
            return builder.start();
        }
        catch (IOException ioe) {
            throw new AnalysisException("mix_audit initialization failure; this error can be ignored if you are not analyzing Elixir. Otherwise ensure that mix_audit is installed and the path to mix_audit is correctly specified", ioe);
        }
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        int exitValue;
        File parentFile = dependency.getActualFile().getParentFile();
        ImmutableList mixAuditArgs = ImmutableList.of((Object)"--format", (Object)"json");
        Process process = this.launchMixAudit(parentFile, (List<String>)mixAuditArgs);
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new AnalysisException("mix_audit process interrupted", ie);
        }
        if (exitValue < 0 || exitValue > 1) {
            String msg = String.format("Unexpected exit code from mix_audit process; exit code: %s", exitValue);
            throw new AnalysisException(msg);
        }
        try {
            try (BufferedReader errReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
                while (errReader.ready()) {
                    String error = errReader.readLine();
                    LOGGER.warn(error);
                }
            }
            var8_11 = null;
            try (BufferedReader rdr = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                this.processMixAuditOutput(dependency, engine, rdr);
            }
            catch (Throwable throwable) {
                var8_11 = throwable;
                throw throwable;
            }
        }
        catch (IOException | CpeValidationException ioe) {
            LOGGER.warn("mix_audit failure", ioe);
        }
    }

    private void processMixAuditOutput(Dependency original, Engine engine, BufferedReader rdr) throws AnalysisException, CpeValidationException {
        MixAuditJsonParser parser = new MixAuditJsonParser(rdr);
        parser.process();
        for (MixAuditResult result : parser.getResults()) {
            Dependency dependency = this.createDependency(original, result.getDependencyPackage(), result.getDependencyVersion());
            Vulnerability vulnerability = this.cvedb.getVulnerability(result.getCve());
            if (vulnerability == null) {
                vulnerability = this.createVulnerability(result);
            }
            dependency.addVulnerability(vulnerability);
            engine.addDependency(dependency);
        }
    }

    private Dependency createDependency(Dependency parentDependency, String packageName, String version) {
        Dependency dep = new Dependency(parentDependency.getActualFile(), true);
        String identifier = String.format("%s:%s", packageName, version);
        dep.setEcosystem(DEPENDENCY_ECOSYSTEM);
        dep.setDisplayFileName(identifier);
        dep.setName(packageName);
        dep.setVersion(version);
        dep.setPackagePath(identifier);
        dep.setMd5sum(Checksum.getMD5Checksum((String)identifier));
        dep.setSha1sum(Checksum.getSHA1Checksum((String)identifier));
        dep.setSha256sum(Checksum.getSHA256Checksum((String)identifier));
        dep.addEvidence(EvidenceType.VERSION, "mix_audit", "Version", version, Confidence.HIGHEST);
        dep.addEvidence(EvidenceType.PRODUCT, "mix_audit", "Package", packageName, Confidence.HIGHEST);
        try {
            PackageURL purl = PackageURLBuilder.aPackageURL().withType("hex").withName(packageName).withVersion(version).build();
            dep.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
        }
        catch (MalformedPackageURLException ex) {
            LOGGER.debug("Unable to build package url for hex", (Throwable)ex);
            GenericIdentifier id = new GenericIdentifier("hex:" + packageName + "@" + version, Confidence.HIGHEST);
            dep.addSoftwareIdentifier(id);
        }
        return dep;
    }

    private Vulnerability createVulnerability(MixAuditResult result) throws CpeValidationException {
        String product = result.getDependencyPackage();
        String version = result.getDependencyVersion();
        Vulnerability vulnerability = new Vulnerability();
        vulnerability.setSource(Vulnerability.Source.MIXAUDIT);
        VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder();
        VulnerableSoftware vs = builder.part(Part.APPLICATION).vendor(String.format("%s_project", product)).product(product).version(version).build();
        vulnerability.addVulnerableSoftware(vs);
        vulnerability.setMatchedVulnerableSoftware(vs);
        vulnerability.setCvssV2(new CvssV2(-1.0f, "-", "-", "-", "-", "-", "-", "unknown"));
        vulnerability.setDescription(result.getDescription());
        vulnerability.setName(result.getCve());
        return vulnerability;
    }
}

