/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.SimpleResultSet;

public final class H2Functions {
    private H2Functions() {
    }

    public static void insertSoftware(Connection conn, int vulnerabilityId, String part, String vendor, String product, String version, String update, String edition, String language, String swEdition, String targetSw, String targetHw, String other, String ecosystem, String versionEndExcluding, String versionEndIncluding, String versionStartExcluding, String versionStartIncluding, Boolean vulnerable) throws SQLException {
        Throwable throwable;
        int cpeID;
        block74: {
            cpeID = 0;
            throwable = null;
            try (PreparedStatement selectCpeId = conn.prepareStatement("SELECT id, ecosystem FROM cpeEntry WHERE part=? AND vendor=? AND product=? AND version=? AND update_version=? AND edition=? AND lang=? AND sw_edition=? AND target_sw=? AND target_hw=? AND other=?");){
                selectCpeId.setString(1, part);
                selectCpeId.setString(2, vendor);
                selectCpeId.setString(3, product);
                selectCpeId.setString(4, version);
                selectCpeId.setString(5, update);
                selectCpeId.setString(6, edition);
                selectCpeId.setString(7, language);
                selectCpeId.setString(8, swEdition);
                selectCpeId.setString(9, targetSw);
                selectCpeId.setString(10, targetHw);
                selectCpeId.setString(11, other);
                try (ResultSet rs = selectCpeId.executeQuery();){
                    if (!rs.next()) break block74;
                    cpeID = rs.getInt(1);
                    String e = rs.getString(2);
                    if (e != null || ecosystem == null) break block74;
                    try (PreparedStatement updateEcosystem = conn.prepareStatement("UPDATE cpeEntry SET ecosystem=? WHERE id=?");){
                        updateEcosystem.setString(1, ecosystem);
                        updateEcosystem.setInt(2, cpeID);
                        updateEcosystem.execute();
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (cpeID == 0) {
            String[] returnedColumns = new String[]{"id"};
            try (PreparedStatement insertCpe = conn.prepareStatement("INSERT INTO cpeEntry (part, vendor, product, version, update_version, edition, lang, sw_edition, target_sw, target_hw, other, ecosystem) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", returnedColumns);){
                insertCpe.setString(1, part);
                insertCpe.setString(2, vendor);
                insertCpe.setString(3, product);
                insertCpe.setString(4, version);
                insertCpe.setString(5, update);
                insertCpe.setString(6, edition);
                insertCpe.setString(7, language);
                insertCpe.setString(8, swEdition);
                insertCpe.setString(9, targetSw);
                insertCpe.setString(10, targetHw);
                insertCpe.setString(11, other);
                H2Functions.setStringOrNull(insertCpe, 12, ecosystem);
                insertCpe.executeUpdate();
                try (ResultSet rs = insertCpe.getGeneratedKeys();){
                    if (rs.next()) {
                        cpeID = rs.getInt(1);
                    }
                }
            }
        }
        throwable = null;
        try (PreparedStatement insertSoftware = conn.prepareStatement("INSERT INTO software (cveid, cpeEntryId, versionEndExcluding, versionEndIncluding, versionStartExcluding, versionStartIncluding, vulnerable) VALUES (?, ?, ?, ?, ?, ?, ?)");){
            insertSoftware.setInt(1, vulnerabilityId);
            insertSoftware.setInt(2, cpeID);
            H2Functions.setStringOrNull(insertSoftware, 3, versionEndExcluding);
            H2Functions.setStringOrNull(insertSoftware, 4, versionEndIncluding);
            H2Functions.setStringOrNull(insertSoftware, 5, versionStartExcluding);
            H2Functions.setStringOrNull(insertSoftware, 6, versionStartIncluding);
            H2Functions.setBooleanOrNull(insertSoftware, 7, vulnerable);
            insertSoftware.execute();
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet updateVulnerability(Connection conn, String cve, String description, String v2Severity, Float v2ExploitabilityScore, Float v2ImpactScore, Boolean v2AcInsufInfo, Boolean v2ObtainAllPrivilege, Boolean v2ObtainUserPrivilege, Boolean v2ObtainOtherPrivilege, Boolean v2UserInteractionRequired, Float v2Score, String v2AccessVector, String v2AccessComplexity, String v2Authentication, String v2ConfidentialityImpact, String v2IntegrityImpact, String v2AvailabilityImpact, String v2Version, Float v3ExploitabilityScore, Float v3ImpactScore, String v3AttackVector, String v3AttackComplexity, String v3PrivilegesRequired, String v3UserInteraction, String v3Scope, String v3ConfidentialityImpact, String v3IntegrityImpact, String v3AvailabilityImpact, Float v3BaseScore, String v3BaseSeverity, String v3Version) throws SQLException {
        int vulnerabilityId;
        SimpleResultSet ret;
        block87: {
            Throwable throwable;
            Object rs;
            ret = new SimpleResultSet();
            ret.addColumn("id", 4, 10, 0);
            String url = conn.getMetaData().getURL();
            if ("jdbc:columnlist:connection".equals(url)) {
                return ret;
            }
            vulnerabilityId = 0;
            try (PreparedStatement selectVulnerabilityId = conn.prepareStatement("SELECT id FROM VULNERABILITY CVE WHERE cve=?");){
                selectVulnerabilityId.setString(1, cve);
                rs = selectVulnerabilityId.executeQuery();
                throwable = null;
                try {
                    if (rs.next()) {
                        vulnerabilityId = rs.getInt(1);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            try (Statement merge = null;){
                if (vulnerabilityId > 0) {
                    PreparedStatement refs = conn.prepareStatement("DELETE FROM reference WHERE cveid = ?");
                    rs = null;
                    try {
                        refs.setInt(1, vulnerabilityId);
                        refs.executeUpdate();
                    }
                    catch (Throwable throwable4) {
                        rs = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (refs != null) {
                            if (rs != null) {
                                try {
                                    refs.close();
                                }
                                catch (Throwable throwable5) {
                                    ((Throwable)rs).addSuppressed(throwable5);
                                }
                            } else {
                                refs.close();
                            }
                        }
                    }
                    PreparedStatement software = conn.prepareStatement("DELETE FROM software WHERE cveid = ?");
                    rs = null;
                    try {
                        software.setInt(1, vulnerabilityId);
                        software.executeUpdate();
                    }
                    catch (Throwable throwable6) {
                        rs = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (software != null) {
                            if (rs != null) {
                                try {
                                    software.close();
                                }
                                catch (Throwable throwable7) {
                                    ((Throwable)rs).addSuppressed(throwable7);
                                }
                            } else {
                                software.close();
                            }
                        }
                    }
                    PreparedStatement cwe = conn.prepareStatement("DELETE FROM cweEntry WHERE cveid = ?");
                    rs = null;
                    try {
                        cwe.setInt(1, vulnerabilityId);
                        cwe.executeUpdate();
                    }
                    catch (Throwable throwable8) {
                        rs = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (cwe != null) {
                            if (rs != null) {
                                try {
                                    cwe.close();
                                }
                                catch (Throwable throwable9) {
                                    ((Throwable)rs).addSuppressed(throwable9);
                                }
                            } else {
                                cwe.close();
                            }
                        }
                    }
                    merge = conn.prepareStatement("UPDATE VULNERABILITY SET description=?, v2Severity=?, v2ExploitabilityScore=?, v2ImpactScore=?, v2AcInsufInfo=?, v2ObtainAllPrivilege=?, v2ObtainUserPrivilege=?, v2ObtainOtherPrivilege=?, v2UserInteractionRequired=?, v2Score=?, v2AccessVector=?, v2AccessComplexity=?, v2Authentication=?, v2ConfidentialityImpact=?, v2IntegrityImpact=?, v2AvailabilityImpact=?, v2Version=?, v3ExploitabilityScore=?, v3ImpactScore=?, v3AttackVector=?, v3AttackComplexity=?, v3PrivilegesRequired=?, v3UserInteraction=?, v3Scope=?, v3ConfidentialityImpact=?, v3IntegrityImpact=?, v3AvailabilityImpact=?, v3BaseScore=?, v3BaseSeverity=?, v3Version=? WHERE id=?");
                } else {
                    String[] returnedColumns = new String[]{"id"};
                    merge = conn.prepareStatement("INSERT INTO VULNERABILITY (description, v2Severity, v2ExploitabilityScore, v2ImpactScore, v2AcInsufInfo, v2ObtainAllPrivilege, v2ObtainUserPrivilege, v2ObtainOtherPrivilege, v2UserInteractionRequired, v2Score, v2AccessVector, v2AccessComplexity, v2Authentication, v2ConfidentialityImpact, v2IntegrityImpact, v2AvailabilityImpact, v2Version, v3ExploitabilityScore, v3ImpactScore, v3AttackVector, v3AttackComplexity, v3PrivilegesRequired, v3UserInteraction, v3Scope, v3ConfidentialityImpact, v3IntegrityImpact, v3AvailabilityImpact, v3BaseScore, v3BaseSeverity, v3Version, cve) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", returnedColumns);
                }
                merge.setString(1, description);
                H2Functions.setStringOrNull((PreparedStatement)merge, 2, v2Severity);
                H2Functions.setFloatOrNull((PreparedStatement)merge, 3, v2ExploitabilityScore);
                H2Functions.setFloatOrNull((PreparedStatement)merge, 4, v2ImpactScore);
                H2Functions.setBooleanOrNull((PreparedStatement)merge, 5, v2AcInsufInfo);
                H2Functions.setBooleanOrNull((PreparedStatement)merge, 6, v2ObtainAllPrivilege);
                H2Functions.setBooleanOrNull((PreparedStatement)merge, 7, v2ObtainUserPrivilege);
                H2Functions.setBooleanOrNull((PreparedStatement)merge, 8, v2ObtainOtherPrivilege);
                H2Functions.setBooleanOrNull((PreparedStatement)merge, 9, v2UserInteractionRequired);
                H2Functions.setFloatOrNull((PreparedStatement)merge, 10, v2Score);
                H2Functions.setStringOrNull((PreparedStatement)merge, 11, v2AccessVector);
                H2Functions.setStringOrNull((PreparedStatement)merge, 12, v2AccessComplexity);
                H2Functions.setStringOrNull((PreparedStatement)merge, 13, v2Authentication);
                H2Functions.setStringOrNull((PreparedStatement)merge, 14, v2ConfidentialityImpact);
                H2Functions.setStringOrNull((PreparedStatement)merge, 15, v2IntegrityImpact);
                H2Functions.setStringOrNull((PreparedStatement)merge, 16, v2AvailabilityImpact);
                H2Functions.setStringOrNull((PreparedStatement)merge, 17, v2Version);
                H2Functions.setFloatOrNull((PreparedStatement)merge, 18, v3ExploitabilityScore);
                H2Functions.setFloatOrNull((PreparedStatement)merge, 19, v3ImpactScore);
                H2Functions.setStringOrNull((PreparedStatement)merge, 20, v3AttackVector);
                H2Functions.setStringOrNull((PreparedStatement)merge, 21, v3AttackComplexity);
                H2Functions.setStringOrNull((PreparedStatement)merge, 22, v3PrivilegesRequired);
                H2Functions.setStringOrNull((PreparedStatement)merge, 23, v3UserInteraction);
                H2Functions.setStringOrNull((PreparedStatement)merge, 24, v3Scope);
                H2Functions.setStringOrNull((PreparedStatement)merge, 25, v3ConfidentialityImpact);
                H2Functions.setStringOrNull((PreparedStatement)merge, 26, v3IntegrityImpact);
                H2Functions.setStringOrNull((PreparedStatement)merge, 27, v3AvailabilityImpact);
                H2Functions.setFloatOrNull((PreparedStatement)merge, 28, v3BaseScore);
                H2Functions.setStringOrNull((PreparedStatement)merge, 29, v3BaseSeverity);
                H2Functions.setStringOrNull((PreparedStatement)merge, 30, v3Version);
                if (vulnerabilityId == 0) {
                    merge.setString(31, cve);
                } else {
                    merge.setInt(31, vulnerabilityId);
                }
                int count = merge.executeUpdate();
                if (vulnerabilityId != 0) break block87;
                rs = merge.getGeneratedKeys();
                throwable = null;
                try {
                    if (rs.next()) {
                        vulnerabilityId = rs.getInt(1);
                    }
                }
                catch (Throwable throwable10) {
                    throwable = throwable10;
                    throw throwable10;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable11) {
                                throwable.addSuppressed(throwable11);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
        }
        ret.addRow(new Object[]{vulnerabilityId});
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeKnownExploited(Connection conn, String cveId, String vendorProject, String product, String vulnerabilityName, String dateAdded, String shortDescription, String requiredAction, String dueDate, String notes) throws SQLException {
        String id = "";
        try (PreparedStatement selectVulnerabilityId = conn.prepareStatement("SELECT cveID FROM knownExploited cveID WHERE cveID=?");){
            selectVulnerabilityId.setString(1, cveId);
            try (ResultSet rs = selectVulnerabilityId.executeQuery();){
                if (rs.next()) {
                    id = rs.getString(1);
                }
            }
        }
        try (Statement merge = null;){
            merge = Strings.isNullOrEmpty((String)id) ? conn.prepareStatement("INSERT INTO knownExploited (vendorProject, product, vulnerabilityName, dateAdded, shortDescription, requiredAction, dueDate, notes, cveID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : conn.prepareStatement("UPDATE knownExploited SET vendorProject=?, product=?, vulnerabilityName=?, dateAdded=?, shortDescription=?, requiredAction=?, dueDate=?, notes=? WHERE cveID=?");
            H2Functions.setStringOrNull((PreparedStatement)merge, 1, vendorProject);
            H2Functions.setStringOrNull((PreparedStatement)merge, 2, product);
            H2Functions.setStringOrNull((PreparedStatement)merge, 3, vulnerabilityName);
            H2Functions.setStringOrNull((PreparedStatement)merge, 4, dateAdded);
            H2Functions.setStringOrNull((PreparedStatement)merge, 5, shortDescription);
            H2Functions.setStringOrNull((PreparedStatement)merge, 6, requiredAction);
            H2Functions.setStringOrNull((PreparedStatement)merge, 7, dueDate);
            H2Functions.setStringOrNull((PreparedStatement)merge, 8, notes);
            H2Functions.setStringOrNull((PreparedStatement)merge, 9, cveId);
            merge.execute();
        }
    }

    private static void setStringOrNull(PreparedStatement ps, int i, String value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 0);
        } else {
            ps.setString(i, value);
        }
    }

    private static void setFloatOrNull(PreparedStatement ps, int i, Float value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 0);
        } else {
            ps.setFloat(i, value.floatValue());
        }
    }

    private static void setBooleanOrNull(PreparedStatement ps, int i, Boolean value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 0);
        } else {
            ps.setBoolean(i, value);
        }
    }
}

