/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;

public class CvssV2
implements Serializable {
    private static final long serialVersionUID = -2203955879356702367L;
    private final float score;
    private final String accessVector;
    private final String accessComplexity;
    private final String authentication;
    private final String confidentialityImpact;
    private final String integrityImpact;
    private final String availabilityImpact;
    private final String version;
    private final String severity;
    private final Float exploitabilityScore;
    private final Float impactScore;
    private final Boolean acInsufInfo;
    private final Boolean obtainAllPrivilege;
    private final Boolean obtainUserPrivilege;
    private final Boolean obtainOtherPrivilege;
    private final Boolean userInteractionRequired;

    public CvssV2(float score, String accessVector, String accessComplexity, String authentication, String confidentialityImpact, String integrityImpact, String availabilityImpact, String severity) {
        this(score, accessVector, accessComplexity, authentication, confidentialityImpact, integrityImpact, availabilityImpact, severity, null, null, null, null, null, null, null, null);
    }

    public CvssV2(float score, String accessVector, String accessComplexity, String authentication, String confidentialityImpact, String integrityImpact, String availabilityImpact, String severity, Float exploitabilityScore, Float impactScore, Boolean acInsufInfo, Boolean obtainAllPrivilege, Boolean obtainUserPrivilege, Boolean obtainOtherPrivilege, Boolean userInteractionRequired, String version) {
        this.score = score;
        this.accessVector = accessVector;
        this.accessComplexity = accessComplexity;
        this.authentication = authentication;
        this.confidentialityImpact = confidentialityImpact;
        this.integrityImpact = integrityImpact;
        this.availabilityImpact = availabilityImpact;
        this.severity = severity;
        this.exploitabilityScore = exploitabilityScore;
        this.impactScore = impactScore;
        this.acInsufInfo = acInsufInfo;
        this.obtainAllPrivilege = obtainAllPrivilege;
        this.obtainUserPrivilege = obtainUserPrivilege;
        this.obtainOtherPrivilege = obtainOtherPrivilege;
        this.userInteractionRequired = userInteractionRequired;
        this.version = version;
    }

    public float getScore() {
        return this.score;
    }

    public String getAccessVector() {
        return this.accessVector;
    }

    public String getAccessComplexity() {
        return this.accessComplexity;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public String getConfidentialityImpact() {
        return this.confidentialityImpact;
    }

    public String getIntegrityImpact() {
        return this.integrityImpact;
    }

    public String getAvailabilityImpact() {
        return this.availabilityImpact;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Float getExploitabilityScore() {
        return this.exploitabilityScore;
    }

    public Float getImpactScore() {
        return this.impactScore;
    }

    public Boolean isAcInsufInfo() {
        return this.acInsufInfo;
    }

    public Boolean isObtainAllPrivilege() {
        return this.obtainAllPrivilege;
    }

    public Boolean isObtainUserPrivilege() {
        return this.obtainUserPrivilege;
    }

    public Boolean isObtainOtherPrivilege() {
        return this.obtainOtherPrivilege;
    }

    public Boolean isUserInteractionRequired() {
        return this.userInteractionRequired;
    }

    public String toString() {
        return String.format("/AV:%s/AC:%s/Au:%s/C:%s/I:%s/A:%s", this.accessVector == null ? "" : this.accessVector.substring(0, 1), this.accessComplexity == null ? "" : this.accessComplexity.substring(0, 1), this.authentication == null ? "" : this.authentication.substring(0, 1), this.confidentialityImpact == null ? "" : this.confidentialityImpact.substring(0, 1), this.integrityImpact == null ? "" : this.integrityImpact.substring(0, 1), this.availabilityImpact == null ? "" : this.availabilityImpact.substring(0, 1));
    }
}

