/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nodeaudit;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.JsonObject;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.data.cache.DataCache;
import org.owasp.dependencycheck.data.cache.DataCacheFactory;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NodeAuditSearch {
    private final URL nodeAuditUrl;
    private final boolean useProxy;
    private final Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeAuditSearch.class);
    private DataCache<List<Advisory>> cache;

    public NodeAuditSearch(Settings settings) throws MalformedURLException {
        String searchUrl = settings.getString("analyzer.node.audit.url", "https://registry.npmjs.org/-/npm/v1/security/audits");
        LOGGER.debug("Node Audit Search URL: {}", (Object)searchUrl);
        this.nodeAuditUrl = new URL(searchUrl);
        this.settings = settings;
        if (null != settings.getString("proxy.server")) {
            this.useProxy = true;
            LOGGER.debug("Using proxy");
        } else {
            this.useProxy = false;
            LOGGER.debug("Not using proxy");
        }
        if (settings.getBoolean("analyzer.node.audit.use.cache", true)) {
            try {
                DataCacheFactory factory = new DataCacheFactory(settings);
                this.cache = factory.getNodeAuditCache();
            }
            catch (CacheException ex) {
                settings.setBoolean("analyzer.node.audit.use.cache", false);
                LOGGER.debug("Error creating cache, disabling caching", (Throwable)ex);
            }
        }
    }

    public List<Advisory> submitPackage(JsonObject packageJson) throws SearchException, IOException {
        List<Advisory> cached;
        String key = null;
        if (this.cache != null && (cached = this.cache.get(key = Checksum.getSHA256Checksum((String)packageJson.toString()))) != null) {
            LOGGER.debug("cache hit for node audit: " + key);
            return cached;
        }
        return this.submitPackage(packageJson, key, 0);
    }

    /*
     * Exception decompiling
     */
    private List<Advisory> submitPackage(JsonObject packageJson, String key, int count) throws SearchException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String generateRandomSession() {
        int length = 16;
        SecureRandom r = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        while (sb.length() < 16) {
            sb.append(Integer.toHexString(r.nextInt()));
        }
        return sb.toString().substring(0, 16);
    }
}

