/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd.api;

import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.Callable;
import java.util.zip.GZIPInputStream;
import org.owasp.dependencycheck.data.nvd.ecosystem.CveEcosystemMapper;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.nvd.api.CveApiJson20CveItemSource;
import org.owasp.dependencycheck.data.update.nvd.api.CveItemSource;
import org.owasp.dependencycheck.data.update.nvd.api.JsonArrayCveItemSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdApiProcessor
implements Callable<NvdApiProcessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdApiProcessor.class);
    private final CveDB cveDB;
    private File jsonFile;
    private final CveEcosystemMapper mapper = new CveEcosystemMapper();
    private final long startTime;
    private long endTime = 0L;

    public NvdApiProcessor(CveDB cveDB, File jsonFile, long startTime) {
        this.cveDB = cveDB;
        this.jsonFile = jsonFile;
        this.startTime = startTime;
    }

    public NvdApiProcessor(CveDB cveDB, File jsonFile) {
        this(cveDB, jsonFile, System.currentTimeMillis());
    }

    @Override
    public NvdApiProcessor call() throws Exception {
        block110: {
            if (this.jsonFile.getName().endsWith(".jsonarray.gz")) {
                try (InputStream fis = Files.newInputStream(this.jsonFile.toPath(), new OpenOption[0]);
                     BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(fis));
                     JsonArrayCveItemSource itemSource = new JsonArrayCveItemSource(is);){
                    this.updateCveDb(itemSource);
                    break block110;
                }
            }
            if (this.jsonFile.getName().endsWith(".gz")) {
                try (InputStream fis = Files.newInputStream(this.jsonFile.toPath(), new OpenOption[0]);
                     BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(fis));
                     CveApiJson20CveItemSource itemSource = new CveApiJson20CveItemSource(is);){
                    this.updateCveDb(itemSource);
                    break block110;
                }
            }
            try (InputStream fis = Files.newInputStream(this.jsonFile.toPath(), new OpenOption[0]);
                 BufferedInputStream is = new BufferedInputStream(fis);
                 JsonArrayCveItemSource itemSource = new JsonArrayCveItemSource(is);){
                this.updateCveDb(itemSource);
            }
        }
        this.endTime = System.currentTimeMillis();
        return this;
    }

    private void updateCveDb(CveItemSource<DefCveItem> itemSource) throws IOException {
        while (itemSource.hasNext()) {
            DefCveItem entry = itemSource.next();
            try {
                this.cveDB.updateVulnerability(entry, this.mapper.getEcosystem(entry));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process " + entry.getCve().getId(), (Throwable)ex);
            }
        }
    }

    public long getDurationMillis() {
        return this.endTime - this.startTime;
    }
}

