/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class CocoaPodsAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "ios";
    private static final Logger LOGGER = LoggerFactory.getLogger(CocoaPodsAnalyzer.class);
    private static final String ANALYZER_NAME = "CocoaPods Package Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String PODSPEC = "podspec";
    public static final String PODFILE_LOCK = "Podfile.lock";
    private static final FileFilter PODS_FILTER = FileFilterBuilder.newInstance().addExtensions("podspec").addFilenames("Podfile.lock").build();
    private static final Pattern PODSPEC_BLOCK_PATTERN = Pattern.compile("Pod::Spec\\.new\\s+?do\\s+?\\|(.+?)\\|");
    private static final Pattern PODFILE_LOCK_DEPENDENCY_PATTERN = Pattern.compile("  - \"?(.*) \\((\\d+(\\.\\d+){0,4})\\)\"?");

    @Override
    protected FileFilter getFileFilter() {
        return PODS_FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.cocoapods.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (PODFILE_LOCK.equals(dependency.getFileName())) {
            this.analyzePodfileLockDependencies(dependency, engine);
        }
        if (dependency.getFileName().endsWith(PODSPEC)) {
            this.analyzePodspecDependency(dependency);
        }
    }

    private void analyzePodfileLockDependencies(Dependency podfileLock, Engine engine) throws AnalysisException {
        String contents;
        engine.removeDependency(podfileLock);
        try {
            contents = new String(Files.readAllBytes(podfileLock.getActualFile().toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        Matcher matcher = PODFILE_LOCK_DEPENDENCY_PATTERN.matcher(contents);
        while (matcher.find()) {
            String name = matcher.group(1);
            String version = matcher.group(2);
            Dependency dependency = new Dependency(podfileLock.getActualFile(), true);
            dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
            dependency.setName(name);
            dependency.setVersion(version);
            try {
                PackageURLBuilder builder = PackageURLBuilder.aPackageURL().withType("cocoapods").withName(dependency.getName());
                if (dependency.getVersion() != null) {
                    builder.withVersion(dependency.getVersion());
                }
                PackageURL purl = builder.build();
                dependency.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to build package url for cocoapods", (Throwable)ex);
                GenericIdentifier id = dependency.getVersion() != null ? new GenericIdentifier("cocoapods:" + dependency.getName() + "@" + dependency.getVersion(), Confidence.HIGHEST) : new GenericIdentifier("cocoapods:" + dependency.getName(), Confidence.HIGHEST);
                dependency.addSoftwareIdentifier(id);
            }
            String packagePath = String.format("%s:%s", name, version);
            dependency.setPackagePath(packagePath);
            dependency.setDisplayFileName(packagePath);
            dependency.setSha1sum(Checksum.getSHA1Checksum((String)packagePath));
            dependency.setSha256sum(Checksum.getSHA256Checksum((String)packagePath));
            dependency.setMd5sum(Checksum.getMD5Checksum((String)packagePath));
            dependency.addEvidence(EvidenceType.VENDOR, PODFILE_LOCK, "name", name, Confidence.HIGHEST);
            dependency.addEvidence(EvidenceType.PRODUCT, PODFILE_LOCK, "name", name, Confidence.HIGHEST);
            dependency.addEvidence(EvidenceType.VERSION, PODFILE_LOCK, "version", version, Confidence.HIGHEST);
            engine.addDependency(dependency);
        }
    }

    private void analyzePodspecDependency(Dependency dependency) throws AnalysisException {
        String contents;
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        try {
            contents = new String(Files.readAllBytes(dependency.getActualFile().toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        Matcher matcher = PODSPEC_BLOCK_PATTERN.matcher(contents);
        if (matcher.find()) {
            String license;
            String homepage;
            String author;
            String summary;
            String version;
            contents = contents.substring(matcher.end());
            String blockVariable = matcher.group(1);
            PackageURLBuilder builder = null;
            String name = this.determineEvidence(contents, blockVariable, "name");
            if (!name.isEmpty()) {
                dependency.addEvidence(EvidenceType.PRODUCT, PODSPEC, "name_project", name, Confidence.HIGHEST);
                dependency.addEvidence(EvidenceType.VENDOR, PODSPEC, "name_project", name, Confidence.HIGHEST);
                dependency.setName(name);
                builder = PackageURLBuilder.aPackageURL();
                builder.withType("cocoapods").withName(name);
            }
            if (!(version = this.determineEvidence(contents, blockVariable, "version")).isEmpty()) {
                dependency.addEvidence(EvidenceType.VERSION, PODSPEC, "version", version, Confidence.HIGHEST);
                dependency.setVersion(version);
                if (builder != null) {
                    builder.withVersion(version);
                }
            }
            if (!(summary = this.determineEvidence(contents, blockVariable, "summary")).isEmpty()) {
                dependency.addEvidence(EvidenceType.PRODUCT, PODSPEC, "summary", summary, Confidence.HIGHEST);
            }
            if (!(author = this.determineEvidence(contents, blockVariable, "authors?")).isEmpty()) {
                dependency.addEvidence(EvidenceType.VENDOR, PODSPEC, "author", author, Confidence.HIGHEST);
            }
            if (!(homepage = this.determineEvidence(contents, blockVariable, "homepage")).isEmpty()) {
                dependency.addEvidence(EvidenceType.VENDOR, PODSPEC, "homepage", homepage, Confidence.HIGHEST);
            }
            if (!(license = this.determineEvidence(contents, blockVariable, "licen[cs]es?")).isEmpty()) {
                dependency.setLicense(license);
            }
            if (builder != null) {
                try {
                    PurlIdentifier purl = new PurlIdentifier(builder.build(), homepage, Confidence.HIGHEST);
                    dependency.addSoftwareIdentifier(purl);
                }
                catch (MalformedPackageURLException ex) {
                    LOGGER.debug("Unable to generate purl for cocoapod", (Throwable)ex);
                    StringBuilder sb = new StringBuilder("pkg:cocoapods/");
                    sb.append(name);
                    if (!version.isEmpty()) {
                        sb.append("@").append(version);
                    }
                    GenericIdentifier id = new GenericIdentifier(sb.toString(), Confidence.HIGHEST);
                    dependency.addSoftwareIdentifier(id);
                }
            }
        }
        if (dependency.getVersion() != null && !dependency.getVersion().isEmpty()) {
            dependency.setDisplayFileName(String.format("%s:%s", dependency.getName(), dependency.getVersion()));
        } else {
            dependency.setDisplayFileName(dependency.getName());
        }
        this.setPackagePath(dependency);
    }

    private String determineEvidence(String contents, String blockVariable, String fieldPattern) {
        String value = "";
        Matcher arrayMatcher = Pattern.compile(String.format("\\s*?%s\\.%s\\s*?=\\s*?\\{\\s*?(.*?)\\s*?\\}", blockVariable, fieldPattern), 2).matcher(contents);
        if (arrayMatcher.find()) {
            value = arrayMatcher.group(1);
        } else {
            Matcher matcher = Pattern.compile(String.format("\\s*?%s\\.%s\\s*?=\\s*?(['\"])(.*?)\\1", blockVariable, fieldPattern), 2).matcher(contents);
            if (matcher.find()) {
                value = matcher.group(2);
            }
        }
        return value;
    }

    private void setPackagePath(Dependency dep) {
        File file = new File(dep.getFilePath());
        String parent = file.getParent();
        if (parent != null) {
            dep.setPackagePath(parent);
        }
    }
}

