/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;
import org.owasp.dependencycheck.utils.Settings;

@Mojo(name="aggregate", defaultPhase=LifecyclePhase.VERIFY, aggregator=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresOnline=true)
public class AggregateMojo
extends BaseDependencyCheckMojo {
    @Parameter(property="name", defaultValue="dependency-check:aggregate", required=true)
    private String name = "dependency-check:aggregate";

    @Override
    public void runCheck() throws MojoExecutionException, MojoFailureException {
        ExceptionCollection exCol;
        Engine engine;
        block17: {
            engine = this.loadEngine();
            if (engine == null) {
                return;
            }
            exCol = this.scanArtifacts(this.getProject(), engine);
            for (MavenProject childProject : this.getDescendants(this.getProject())) {
                ExceptionCollection ex = this.scanArtifacts(childProject, engine);
                if (ex == null) continue;
                if (exCol == null) {
                    exCol = ex;
                }
                exCol.getExceptions().addAll(ex.getExceptions());
                if (!ex.isFatal()) continue;
                exCol.setFatal(true);
            }
            try {
                engine.analyzeDependencies();
            }
            catch (ExceptionCollection ex) {
                String msg;
                if (exCol == null) {
                    exCol = ex;
                } else if (ex.isFatal()) {
                    exCol.setFatal(true);
                    exCol.getExceptions().addAll(ex.getExceptions());
                }
                if (exCol.isFatal()) {
                    msg = String.format("Fatal exception(s) analyzing %s", this.getProject().getName());
                    if (this.isFailOnError()) {
                        throw new MojoExecutionException(msg, (Exception)((Object)exCol));
                    }
                    this.getLog().error((CharSequence)msg);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Throwable)exCol);
                    }
                    return;
                }
                msg = String.format("Exception(s) analyzing %s", this.getProject().getName());
                if (!this.getLog().isDebugEnabled()) break block17;
                this.getLog().debug((CharSequence)msg, (Throwable)exCol);
            }
        }
        File outputDir = this.getCorrectOutputDirectory(this.getProject());
        if (outputDir == null) {
            outputDir = new File(this.getProject().getBuild().getDirectory());
        }
        try {
            this.writeReports(engine, this.getProject(), outputDir);
        }
        catch (ReportException ex) {
            if (exCol == null) {
                exCol = new ExceptionCollection("Error writing aggregate report", (Throwable)ex);
            } else {
                exCol.addException((Throwable)ex);
            }
            if (this.isFailOnError()) {
                throw new MojoExecutionException("One or more exceptions occurred during dependency-check analysis", (Exception)((Object)exCol));
            }
            this.getLog().debug((CharSequence)"One or more exceptions occurred during dependency-check analysis", (Throwable)exCol);
        }
        this.showSummary(this.getProject(), engine.getDependencies());
        this.checkForFailure(engine.getDependencies());
        engine.cleanup();
        Settings.cleanup();
    }

    protected Set<MavenProject> getDescendants(MavenProject project) {
        if (project == null) {
            return Collections.emptySet();
        }
        HashSet<MavenProject> descendants = new HashSet<MavenProject>();
        int size = 0;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Collecting descendants of %s", project.getName()));
        }
        for (String m : project.getModules()) {
            for (MavenProject mod : this.getReactorProjects()) {
                try {
                    File mpp = new File(project.getBasedir(), m);
                    if ((mpp = mpp.getCanonicalFile()).compareTo(mod.getBasedir()) != 0 || !descendants.add(mod) || !this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)String.format("Decendent module %s added", mod.getName()));
                }
                catch (IOException ex) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)"Unable to determine module path", (Throwable)ex);
                }
            }
        }
        do {
            size = descendants.size();
            for (MavenProject p : this.getReactorProjects()) {
                if (project.equals((Object)p.getParent()) || descendants.contains(p.getParent())) {
                    if (descendants.add(p) && this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)String.format("Decendent %s added", p.getName()));
                    }
                    for (MavenProject modTest : this.getReactorProjects()) {
                        if (p.getModules() == null || !p.getModules().contains(modTest.getName()) || !descendants.add(modTest) || !this.getLog().isDebugEnabled()) continue;
                        this.getLog().debug((CharSequence)String.format("Decendent %s added", modTest.getName()));
                    }
                }
                HashSet<MavenProject> addedDescendants = new HashSet<MavenProject>();
                for (MavenProject dec : descendants) {
                    for (String mod : dec.getModules()) {
                        try {
                            File mpp = new File(dec.getBasedir(), mod);
                            if ((mpp = mpp.getCanonicalFile()).compareTo(p.getBasedir()) != 0) continue;
                            addedDescendants.add(p);
                        }
                        catch (IOException ex) {
                            if (!this.getLog().isDebugEnabled()) continue;
                            this.getLog().debug((CharSequence)"Unable to determine module path", (Throwable)ex);
                        }
                    }
                }
                for (MavenProject addedDescendant : addedDescendants) {
                    if (!descendants.add(addedDescendant) || !this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)String.format("Decendent module %s added", addedDescendant.getName()));
                }
            }
        } while (size != 0 && size != descendants.size());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("%s has %d children", project, descendants.size()));
        }
        return descendants;
    }

    protected boolean isMultiModule(MavenProject mavenProject) {
        return "pom".equals(mavenProject.getPackaging());
    }

    protected Engine loadEngine() throws MojoExecutionException, MojoFailureException {
        Engine engine = null;
        try {
            engine = this.initializeEngine();
        }
        catch (DatabaseException ex) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Database connection error", (Throwable)ex);
            }
            String msg = "An exception occurred connecting to the local database. Please see the log file for more details.";
            if (this.isFailOnError()) {
                throw new MojoExecutionException("An exception occurred connecting to the local database. Please see the log file for more details.", (Exception)((Object)ex));
            }
            this.getLog().error((CharSequence)"An exception occurred connecting to the local database. Please see the log file for more details.", (Throwable)ex);
        }
        return engine;
    }

    public boolean canGenerateReport() {
        return true;
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public String getDescription(Locale locale) {
        return "Generates an aggregate report of all child Maven projects providing details on any published vulnerabilities within project dependencies. This report is a best effort and may contain false positives and false negatives.";
    }
}

