/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.matching.matcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.core.matching.matcher.Matcher;

public class StrictTransportSecurityMatcher
implements Matcher {
    private static final int DEFAULT_MAX_AGE = 15768000;
    private int maxAge = 15768000;

    public StrictTransportSecurityMatcher() {
    }

    public StrictTransportSecurityMatcher(int maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public boolean matches(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        if (WebContextHelper.isHttpsOrSecure(webContext)) {
            webContext.setResponseHeader("Strict-Transport-Security", "max-age=" + this.maxAge + " ; includeSubDomains");
        }
        return true;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxAge() {
        return this.maxAge;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "StrictTransportSecurityMatcher(maxAge=" + this.maxAge + ")";
    }
}

