/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.scribe.builder.api.DefaultApi20;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.OrcidJsonExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.model.Verb;
import org.scribe.utils.OAuthEncoder;

public class OrcidApi20
extends DefaultApi20 {
    private static final String AUTH_URL = "http://www.orcid.org/oauth/authorize/";
    private static final String TOKEN_URL = "https://api.orcid.org/oauth/token";

    public String getAccessTokenEndpoint() {
        return TOKEN_URL;
    }

    public String getAuthorizationUrl(OAuthConfig oAuthConfig) {
        return String.format("http://www.orcid.org/oauth/authorize/?client_id=%s&scope=%s&response_type=%s&redirect_uri=%s#show_login", oAuthConfig.getApiKey(), OAuthEncoder.encode((String)oAuthConfig.getScope()), "code", OAuthEncoder.encode((String)oAuthConfig.getCallback()));
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new OrcidJsonExtractor();
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }
}

