/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.scribe.builder.api.DefaultApi20;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.JsonTokenExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.model.Verb;
import org.scribe.utils.OAuthEncoder;
import org.scribe.utils.Preconditions;

public final class WordPressApi
extends DefaultApi20 {
    private static final String BASE_URL = "https://public-api.wordpress.com/oauth2/";
    private static final String AUTHORIZE_URL = "https://public-api.wordpress.com/oauth2/authorize?client_id=%s&redirect_uri=%s&response_type=code";

    public String getAccessTokenEndpoint() {
        return "https://public-api.wordpress.com/oauth2/token";
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid url as callback. WordPress does not support OOB");
        return String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()));
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new JsonTokenExtractor();
    }
}

