/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.creator;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuthService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OAuthProfileCreator
implements ProfileCreator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected OAuthConfiguration configuration;
    protected IndirectClient client;

    protected OAuthProfileCreator(OAuthConfiguration configuration, IndirectClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)client);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<UserProfile> create(Credentials credentials, WebContext context, SessionStore sessionStore) {
        try {
            Token token = this.getAccessToken(credentials);
            return this.retrieveUserProfileFromToken(context, token);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected abstract Token getAccessToken(Credentials var1);

    protected Optional<UserProfile> retrieveUserProfileFromToken(WebContext context, Token accessToken) {
        OAuthProfileDefinition profileDefinition = this.configuration.getProfileDefinition();
        String profileUrl = profileDefinition.getProfileUrl(accessToken, this.configuration);
        OAuthService service = this.configuration.buildService(context, this.client);
        String body = this.sendRequestForData(service, accessToken, profileUrl, profileDefinition.getProfileVerb());
        this.logger.info("UserProfile: " + body);
        if (body == null) {
            throw new HttpCommunicationException("No data found for accessToken: " + accessToken);
        }
        CommonProfile profile = this.configuration.getProfileDefinition().extractUserProfile(body);
        this.addTokenToProfile((UserProfile)profile, accessToken);
        return Optional.of(profile);
    }

    protected String sendRequestForData(OAuthService service, Token accessToken, String dataUrl, Verb verb) {
        String body;
        int code;
        this.logger.debug("accessToken: {} / dataUrl: {}", (Object)accessToken, (Object)dataUrl);
        long t0 = System.currentTimeMillis();
        OAuthRequest request = this.createOAuthRequest(dataUrl, verb);
        this.signRequest(service, accessToken, request);
        try {
            Response response = service.execute(request);
            code = response.getCode();
            body = response.getBody();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new HttpCommunicationException("Error getting body: " + e.getMessage());
        }
        long t1 = System.currentTimeMillis();
        this.logger.debug("Request took: " + (t1 - t0) + " ms for: " + dataUrl);
        this.logger.debug("response code: {} / response body: {}", (Object)code, (Object)body);
        if (code != 200) {
            throw new HttpCommunicationException(code, body);
        }
        return body;
    }

    protected abstract void signRequest(OAuthService var1, Token var2, OAuthRequest var3);

    protected OAuthRequest createOAuthRequest(String url, Verb verb) {
        return new OAuthRequest(verb, url);
    }

    protected abstract void addTokenToProfile(UserProfile var1, Token var2);

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

