/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.Assert;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.APITestContext;

public class RelationshipManagerTest
extends Assert {
    APITestContext ctx;
    private String ORGANIZATION = "ORGANIZATION";
    private String ORGANIZATION_UNIT = "ORGANIZATION_UNIT";
    private String DIVISION = "DIVISION";
    private String DEPARTMENT = "DEPARTMENT";
    private String PROJECT = "PROJECT";
    private String PEOPLE = "PEOPLE";

    public RelationshipManagerTest(APITestContext ctx) {
        this.ctx = ctx;
    }

    public void setCtx(APITestContext ctx) {
        this.ctx = ctx;
    }

    public APITestContext getCtx() {
        return this.ctx;
    }

    public void testMethods(String realmName) throws Exception {
        IdentitySessionFactory factory = this.ctx.getIdentitySessionFactory();
        IdentitySession session = factory.createIdentitySession(realmName);
        this.ctx.begin();
        User user1 = session.getPersistenceManager().createUser("user1");
        User user2 = session.getPersistenceManager().createUser("user2");
        User user3 = session.getPersistenceManager().createUser("user3");
        User user4 = session.getPersistenceManager().createUser("user4");
        Group group1 = session.getPersistenceManager().createGroup("group1", this.ORGANIZATION);
        Group group2 = session.getPersistenceManager().createGroup("group2", this.ORGANIZATION_UNIT);
        Group group3 = session.getPersistenceManager().createGroup("group3", this.ORGANIZATION_UNIT);
        Group group4 = session.getPersistenceManager().createGroup("group4", this.DEPARTMENT);
        Group group5 = session.getPersistenceManager().createGroup("group5", this.DEPARTMENT);
        session.getRelationshipManager().associateGroups(group1, group2);
        session.getRelationshipManager().associateGroups(group1, group3);
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)group2));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)group3));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)group4));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group2, (IdentityType)group1));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group2, (IdentityType)group3));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1), Arrays.asList(group2, group3)));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1, group2), Arrays.asList(group2, group3)));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group2, group3), Arrays.asList(group1)));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociatedByKeys(group1.getKey(), group2.getKey()));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociatedByKeys(group1.getKey(), group3.getKey()));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociatedByKeys(group1.getKey(), group4.getKey()));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociatedByKeys(group2.getKey(), group1.getKey()));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociatedByKeys(group2.getKey(), group3.getKey()));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociatedByKeys(Arrays.asList(group1.getKey()), Arrays.asList(group2.getKey(), group3.getKey())));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociatedByKeys(Arrays.asList(group1.getKey(), group2.getKey()), Arrays.asList(group2.getKey(), group3.getKey())));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociatedByKeys(Arrays.asList(group2.getKey(), group3.getKey()), Arrays.asList(group1.getKey())));
        session.getRelationshipManager().disassociateGroups(Arrays.asList(group1), Arrays.asList(group2, group3));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)group2));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)group3));
        session.getRelationshipManager().associateGroups(Arrays.asList(group1), Arrays.asList(group2, group3));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1), Arrays.asList(group2, group3)));
        session.getRelationshipManager().disassociateGroupsByKeys(Arrays.asList(group1.getKey()), Arrays.asList(group2.getKey(), group3.getKey()));
        session.getRelationshipManager().associateGroupsByKeys(Arrays.asList(group1.getKey()), Arrays.asList(group2.getKey(), group3.getKey()));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1), Arrays.asList(group2, group3)));
        session.getRelationshipManager().disassociateGroups(Arrays.asList(group1), Arrays.asList(group2, group3));
        session.getRelationshipManager().associateGroupsByKeys(group1.getKey(), group2.getKey());
        session.getRelationshipManager().associateGroupsByKeys(group1.getKey(), group3.getKey());
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1), Arrays.asList(group2, group3)));
        session.getRelationshipManager().disassociateGroups(Arrays.asList(group1), Arrays.asList(group2, group3));
        session.getRelationshipManager().associateUser(group1, user1);
        session.getRelationshipManager().associateUser(group1, user2);
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)user1));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)user2));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)user3));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group2, (IdentityType)user1));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group2, (IdentityType)user3));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1), Arrays.asList(user1, user2)));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1, group2), Arrays.asList(user1, user2)));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group2), Arrays.asList(user3)));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociatedByKeys(group1.getKey(), user1.getKey()));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociatedByKeys(group1.getKey(), user2.getKey()));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociatedByKeys(group1.getKey(), user3.getKey()));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociatedByKeys(group2.getKey(), user1.getKey()));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociatedByKeys(group2.getKey(), user3.getKey()));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociatedByKeys(Arrays.asList(group1.getKey()), Arrays.asList(user1.getKey(), user2.getKey())));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociatedByKeys(Arrays.asList(group1.getKey(), group2.getKey()), Arrays.asList(user1.getKey(), user2.getKey())));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociatedByKeys(Arrays.asList(group2.getKey(), group3.getKey()), Arrays.asList(user1.getKey())));
        session.getRelationshipManager().disassociateUsers(Arrays.asList(group1), Arrays.asList(user1, user2));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)user1));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)user2));
        session.getRelationshipManager().associateUsers(Arrays.asList(group1), Arrays.asList(user1, user2));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1), Arrays.asList(user1, user2)));
        session.getRelationshipManager().disassociateUsers(Arrays.asList(group1), Arrays.asList(user1, user2));
        session.getRelationshipManager().associateUsersByKeys(Arrays.asList(group1.getKey()), Arrays.asList(user1.getKey(), user2.getKey()));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1), Arrays.asList(user1, user2)));
        session.getRelationshipManager().disassociateUsersByKeys(Arrays.asList(group1.getKey()), Arrays.asList(user1.getKey(), user2.getKey()));
        session.getRelationshipManager().associateUserByKeys(group1.getKey(), user1.getKey());
        session.getRelationshipManager().associateUserByKeys(group1.getKey(), user2.getKey());
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1), Arrays.asList(user1, user2)));
        session.getRelationshipManager().disassociateUsers(Arrays.asList(group1), Arrays.asList(user1, user2));
        session.getRelationshipManager().associateUserByKeys(group1.getKey(), user1.getKey());
        session.getRelationshipManager().associateUserByKeys(group2.getKey(), user1.getKey());
        session.getRelationshipManager().associateUserByKeys(group3.getKey(), user1.getKey());
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1, group2, group3), Arrays.asList(user1)));
        session.getRelationshipManager().disassociateGroups(user1);
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group1, (IdentityType)user1));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group2, (IdentityType)user1));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated((IdentityType)group3, (IdentityType)user1));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1, group2, group3), Arrays.asList(user1)));
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(user1).size());
        this.ctx.commit();
        this.ctx.begin();
        session.getRelationshipManager().associateUsers(Arrays.asList(group1), Arrays.asList(user1, user2, user3));
        session.getRelationshipManager().associateUsers(Arrays.asList(group3), Arrays.asList(user2, user3));
        session.getRelationshipManager().associateGroups(Arrays.asList(group2), Arrays.asList(group3, group4, group5));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1), Arrays.asList(user1, user2, user3)));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group2), Arrays.asList(group3, group4, group5)));
        RelationshipManagerTest.assertTrue((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group3), Arrays.asList(user2, user3)));
        this.ctx.commit();
        this.ctx.begin();
        RelationshipManagerTest.assertEquals((int)3, (int)session.getRelationshipManager().findAssociatedUsers(group1, false).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedUsers(group2, false).size());
        RelationshipManagerTest.assertEquals((int)3, (int)session.getRelationshipManager().findAssociatedUsers(group1, false, null).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedUsers(group2, false, null).size());
        RelationshipManagerTest.assertEquals((int)3, (int)session.getRelationshipManager().findAssociatedUsers(group1.getKey(), false, null).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedUsers(group2.getKey(), false, null).size());
        RelationshipManagerTest.assertEquals((int)3, (int)session.getRelationshipManager().findAssociatedGroups(group2, null, true, false).size());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findAssociatedGroups(group2, this.DEPARTMENT, true, false).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(group2, this.ORGANIZATION_UNIT, true, false).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(group2, this.ORGANIZATION, true, false).size());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findAssociatedGroups(group2.getKey(), this.DEPARTMENT, true, false, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(group2.getKey(), this.ORGANIZATION_UNIT, true, false, null).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(group2.getKey(), this.ORGANIZATION, true, false, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(group3, this.ORGANIZATION_UNIT, false, false).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(group4, this.ORGANIZATION_UNIT, false, false).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(group2, this.ORGANIZATION, false, false).size());
        RelationshipManagerTest.assertEquals((int)3, (int)session.getRelationshipManager().findAssociatedGroups(group2, null, true, false).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(group3.getKey(), this.ORGANIZATION_UNIT, false, false, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(group4.getKey(), this.ORGANIZATION_UNIT, false, false, null).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(group2.getKey(), this.ORGANIZATION, false, false, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user1).size());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findAssociatedGroups(user2).size());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findAssociatedGroups(user3).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(user4).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user1.getKey(), null).size());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findAssociatedGroups(user2.getKey(), null).size());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findAssociatedGroups(user3.getKey(), null).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(user4.getKey(), null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user1, this.ORGANIZATION).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(user1, this.ORGANIZATION_UNIT).size());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findAssociatedGroups(user2, (String)null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user2, this.ORGANIZATION).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user2, this.ORGANIZATION_UNIT).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user3, this.ORGANIZATION).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user3, this.ORGANIZATION_UNIT).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(user4, this.ORGANIZATION).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(user4, this.ORGANIZATION_UNIT).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user1.getKey(), this.ORGANIZATION, null).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(user1.getKey(), this.ORGANIZATION_UNIT, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user2.getKey(), this.ORGANIZATION, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user2.getKey(), this.ORGANIZATION_UNIT, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user3.getKey(), this.ORGANIZATION, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user3.getKey(), this.ORGANIZATION_UNIT, null).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(user4.getKey(), this.ORGANIZATION, null).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(user4.getKey(), this.ORGANIZATION_UNIT, null).size());
        session.getRelationshipManager().disassociateUsers(Arrays.asList(group1), Arrays.asList(user1, user2, user3));
        session.getRelationshipManager().disassociateUsers(Arrays.asList(group3), Arrays.asList(user2, user3));
        session.getRelationshipManager().disassociateGroups(Arrays.asList(group2), Arrays.asList(group3, group4));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group1), Arrays.asList(user1, user2, user3)));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group2), Arrays.asList(group3, group4, group5)));
        RelationshipManagerTest.assertFalse((boolean)session.getRelationshipManager().isAssociated(Arrays.asList(group3), Arrays.asList(user2, user3)));
        this.ctx.commit();
    }

    public void testCascade(String realmName) throws Exception {
        IdentitySessionFactory factory = this.ctx.getIdentitySessionFactory();
        IdentitySession session = factory.createIdentitySession(realmName);
        this.ctx.begin();
        User user1 = session.getPersistenceManager().createUser("user1");
        User user2 = session.getPersistenceManager().createUser("user2");
        User user3 = session.getPersistenceManager().createUser("user3");
        User user4 = session.getPersistenceManager().createUser("user4");
        User user5 = session.getPersistenceManager().createUser("user5");
        User user6 = session.getPersistenceManager().createUser("user6");
        User user7 = session.getPersistenceManager().createUser("user7");
        Group group1 = session.getPersistenceManager().createGroup("group1", this.ORGANIZATION);
        Group group2 = session.getPersistenceManager().createGroup("group2", this.ORGANIZATION);
        Group group3 = session.getPersistenceManager().createGroup("group3", this.ORGANIZATION);
        Group group4 = session.getPersistenceManager().createGroup("group4", this.ORGANIZATION);
        Group group5 = session.getPersistenceManager().createGroup("group5", this.ORGANIZATION);
        session.getRelationshipManager().associateGroups(group1, group2);
        session.getRelationshipManager().associateGroups(group1, group3);
        session.getRelationshipManager().associateGroups(group2, group4);
        session.getRelationshipManager().associateGroups(group2, group5);
        session.getRelationshipManager().associateGroups(group3, group1);
        session.getRelationshipManager().associateUser(group1, user1);
        session.getRelationshipManager().associateUser(group2, user2);
        session.getRelationshipManager().associateUser(group3, user3);
        session.getRelationshipManager().associateUser(group5, user4);
        session.getRelationshipManager().associateUser(group5, user5);
        Collection results = session.getRelationshipManager().findAssociatedGroups(group1, this.ORGANIZATION, true, true);
        RelationshipManagerTest.assertEquals((int)4, (int)results.size());
        RelationshipManagerTest.assertFalse((boolean)results.contains(group1));
        RelationshipManagerTest.assertTrue((boolean)results.contains(group2));
        RelationshipManagerTest.assertTrue((boolean)results.contains(group3));
        RelationshipManagerTest.assertTrue((boolean)results.contains(group4));
        RelationshipManagerTest.assertTrue((boolean)results.contains(group5));
        Collection results2 = session.getRelationshipManager().findAssociatedUsers(group1, true);
        RelationshipManagerTest.assertEquals((int)5, (int)results2.size());
        RelationshipManagerTest.assertFalse((boolean)results2.contains(user6));
        RelationshipManagerTest.assertFalse((boolean)results2.contains(user7));
        RelationshipManagerTest.assertTrue((boolean)results2.contains(user1));
        RelationshipManagerTest.assertTrue((boolean)results2.contains(user2));
        RelationshipManagerTest.assertTrue((boolean)results2.contains(user3));
        RelationshipManagerTest.assertTrue((boolean)results2.contains(user4));
        RelationshipManagerTest.assertTrue((boolean)results2.contains(user5));
    }

    public void testMergedRoleAssociations(String realmName) throws Exception {
        IdentitySessionFactory factory = this.ctx.getIdentitySessionFactory();
        IdentitySession session = factory.createIdentitySession(realmName);
        this.ctx.begin();
        User user1 = session.getPersistenceManager().createUser("user1");
        User user2 = session.getPersistenceManager().createUser("user2");
        User user3 = session.getPersistenceManager().createUser("user3");
        User user4 = session.getPersistenceManager().createUser("user4");
        Group group1 = session.getPersistenceManager().createGroup("group1", this.ORGANIZATION);
        Group group2 = session.getPersistenceManager().createGroup("group2", this.ORGANIZATION_UNIT);
        Group group3 = session.getPersistenceManager().createGroup("group3", this.ORGANIZATION_UNIT);
        Group group4 = session.getPersistenceManager().createGroup("group4", this.DEPARTMENT);
        Group group5 = session.getPersistenceManager().createGroup("group5", this.DEPARTMENT);
        session.getRelationshipManager().associateGroups(group1, group2);
        session.getRelationshipManager().associateGroups(group1, group3);
        session.getRelationshipManager().associateUser(group1, user1);
        session.getRelationshipManager().associateUser(group1, user2);
        session.getRoleManager().createRoleType("rt1");
        session.getRoleManager().createRoleType("rt2");
        session.getRoleManager().createRole("rt1", user1.getKey(), group1.getKey());
        session.getRoleManager().createRole("rt1", user3.getKey(), group1.getKey());
        session.getRoleManager().createRole("rt1", user4.getKey(), group1.getKey());
        session.getRoleManager().createRole("rt2", user3.getKey(), group1.getKey());
        session.getRoleManager().createRole("rt1", user3.getKey(), group2.getKey());
        session.getRoleManager().createRole("rt2", user2.getKey(), group3.getKey());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findRelatedGroups(user2, null, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user2, (IdentitySearchCriteria)null).size());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findAssociatedUsers(group1, false, null).size());
        RelationshipManagerTest.assertEquals((int)4, (int)session.getRelationshipManager().findRelatedUsers(group1, null).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedUsers(group2, false, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findRelatedUsers(group2, null).size());
        RelationshipManagerTest.assertEquals((int)0, (int)session.getRelationshipManager().findAssociatedGroups(user3, (IdentitySearchCriteria)null).size());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findRelatedGroups(user3, null, null).size());
        RelationshipManagerTest.assertEquals((int)1, (int)session.getRelationshipManager().findAssociatedGroups(user2, (IdentitySearchCriteria)null).size());
        RelationshipManagerTest.assertEquals((int)2, (int)session.getRelationshipManager().findRelatedGroups(user2, null, null).size());
        this.ctx.commit();
    }
}

