/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.saml.v2.protocol;

import java.net.URI;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.protocol.NameIDPolicyType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestedAuthnContextType;
import org.picketlink.identity.federation.saml.v2.protocol.ScopingType;

public class AuthnRequestType
extends RequestAbstractType {
    private static final long serialVersionUID = 1L;
    protected SubjectType subject;
    protected NameIDPolicyType nameIDPolicy;
    protected ConditionsType conditions;
    protected RequestedAuthnContextType requestedAuthnContext;
    protected ScopingType scoping;
    protected Boolean forceAuthn = Boolean.FALSE;
    protected Boolean isPassive = Boolean.FALSE;
    protected URI protocolBinding;
    protected Integer assertionConsumerServiceIndex;
    protected URI assertionConsumerServiceURL;
    protected Integer attributeConsumingServiceIndex;
    protected String providerName;
    protected boolean unsolicitedResponse;

    public AuthnRequestType(String id, XMLGregorianCalendar instant) {
        super(id, instant);
    }

    public SubjectType getSubject() {
        return this.subject;
    }

    public void setSubject(SubjectType value) {
        this.subject = value;
    }

    public NameIDPolicyType getNameIDPolicy() {
        return this.nameIDPolicy;
    }

    public void setNameIDPolicy(NameIDPolicyType value) {
        this.nameIDPolicy = value;
    }

    public ConditionsType getConditions() {
        return this.conditions;
    }

    public void setConditions(ConditionsType value) {
        this.conditions = value;
    }

    public RequestedAuthnContextType getRequestedAuthnContext() {
        return this.requestedAuthnContext;
    }

    public void setRequestedAuthnContext(RequestedAuthnContextType value) {
        this.requestedAuthnContext = value;
    }

    public ScopingType getScoping() {
        return this.scoping;
    }

    public void setScoping(ScopingType value) {
        this.scoping = value;
    }

    public Boolean isForceAuthn() {
        return this.forceAuthn;
    }

    public void setForceAuthn(Boolean value) {
        this.forceAuthn = value;
    }

    public Boolean isIsPassive() {
        return this.isPassive;
    }

    public void setIsPassive(Boolean value) {
        this.isPassive = value;
    }

    public URI getProtocolBinding() {
        return this.protocolBinding;
    }

    public void setProtocolBinding(URI value) {
        this.protocolBinding = value;
    }

    public Integer getAssertionConsumerServiceIndex() {
        return this.assertionConsumerServiceIndex;
    }

    public void setAssertionConsumerServiceIndex(Integer value) {
        this.assertionConsumerServiceIndex = value;
    }

    public URI getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public void setAssertionConsumerServiceURL(URI value) {
        this.assertionConsumerServiceURL = value;
    }

    public Integer getAttributeConsumingServiceIndex() {
        return this.attributeConsumingServiceIndex;
    }

    public void setAttributeConsumingServiceIndex(Integer value) {
        this.attributeConsumingServiceIndex = value;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String value) {
        this.providerName = value;
    }

    public URI getSenderURL() {
        URI assertionConsumerServiceURL = this.getAssertionConsumerServiceURL();
        if (assertionConsumerServiceURL != null) {
            return assertionConsumerServiceURL;
        }
        NameIDType issuer = this.getIssuer();
        try {
            if (issuer != null) {
                return URI.create(issuer.getValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not resolve sender URL using the Issuer value [" + issuer.getValue() + "].", e);
        }
        throw new RuntimeException("Could not resolve sender URL. AuthnRequest must have a value for AssertionConsumerServiceURL or Issuer.");
    }

    public boolean isUnsolicitedResponse() {
        return this.unsolicitedResponse;
    }

    public void setUnsolicitedResponse(boolean unsolicitedResponse) {
        this.unsolicitedResponse = unsolicitedResponse;
    }
}

