/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.storage;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.storage.annotations.Stored;

public class X509CertificateStorage
implements CredentialStorage {
    private Date effectiveDate = new Date();
    private Date expiryDate;
    private String base64Cert;

    public X509CertificateStorage() {
    }

    public X509CertificateStorage(X509Certificate certificate) {
        try {
            this.base64Cert = Base64.encodeBytes((byte[])certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new IdentityManagementException("Could not get Base64 representation for X509 Certificate.", e);
        }
    }

    @Override
    @Stored
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Override
    @Stored
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Stored
    public String getBase64Cert() {
        return this.base64Cert;
    }

    public void setBase64Cert(String base64Cert) {
        this.base64Cert = base64Cert;
    }
}

