/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.encoder;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.picketlink.idm.credential.encoder.PasswordEncoder;
import org.picketlink.idm.credential.util.BCrypt;

public class PBKDF2PasswordEncoder
implements PasswordEncoder {
    private final byte[] salt;
    private final int keyLength;
    private final int iterationCount;
    public static final String ALGO = "PBKDF2WithHmacSHA1";

    public PBKDF2PasswordEncoder(byte[] salt, int iterationCount, int keyLength) {
        this.salt = salt;
        this.iterationCount = iterationCount;
        this.keyLength = keyLength;
    }

    @Override
    public String encode(String rawPassword) {
        return this.encode(rawPassword, this.generateSalt().getBytes(), true);
    }

    public String encode(String rawPassword, byte[] salt, boolean appendSalt) {
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ALGO);
            PBEKeySpec keySpec = new PBEKeySpec(rawPassword.toCharArray(), salt, this.iterationCount, this.keyLength);
            try {
                SecretKey secretKey = secretKeyFactory.generateSecret(keySpec);
                if (appendSalt) {
                    return new String(secretKey.getEncoded()) + ":" + this.toHex(salt);
                }
                return new String(secretKey.getEncoded());
            }
            catch (InvalidKeySpecException ikse) {
                throw new RuntimeException(ikse);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    @Override
    public boolean verify(String rawPassword, String encodedPassword) {
        int saltIndex = encodedPassword.lastIndexOf(":");
        if (saltIndex != -1) {
            byte[] salt = this.fromHex(encodedPassword.substring(saltIndex + 1));
            return this.encode(rawPassword, salt, true).equals(encodedPassword);
        }
        return this.encode(rawPassword, this.salt, false).equals(encodedPassword);
    }

    protected byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }

    protected String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    protected String generateSalt() {
        return BCrypt.gensalt();
    }
}

