/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.util;

import org.picketlink.common.reflection.Reflections;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;

public class IdentityTypeUtil {
    private static final String ID_SEPARATOR = ":";

    public static IdentityType resolveIdentityType(String descriptor, Object parent, PartitionManager partitionManager) {
        Class identityTypeClass;
        String type = IdentityTypeUtil.getIdentityType(descriptor);
        String partitionId = IdentityTypeUtil.getPartitionId(descriptor);
        String identityTypeId = IdentityTypeUtil.getIdentityTypeId(descriptor);
        Partition partition = partitionManager.lookupById(Partition.class, partitionId);
        if (partition == null) {
            throw new IdentityManagementException("No partition [" + partitionId + "] found for " + "referenced IdentityType [" + identityTypeId + "].");
        }
        try {
            identityTypeClass = Reflections.classForName((String)type, (ClassLoader[])new ClassLoader[]{parent.getClass().getClassLoader()});
        }
        catch (ClassNotFoundException e) {
            throw new IdentityManagementException("Could not instantiate referenced identity type [" + type + "].", (Throwable)e);
        }
        IdentityManager identityManager = partitionManager.createIdentityManager(partition);
        IdentityType identityType = (IdentityType)identityManager.lookupById(identityTypeClass, identityTypeId);
        if (identityType == null) {
            throw new IdentityManagementException("Referenced IdentityType [" + identityTypeId + "] from " + "" + "relationship " + "[" + parent.getClass() + "] does not exists in any store.");
        }
        return identityType;
    }

    public static String formatId(IdentityType identityType) {
        return identityType.getClass().getName() + ID_SEPARATOR + identityType.getPartition().getId() + ID_SEPARATOR + identityType.getId();
    }

    public static String getPartitionId(String descriptor) {
        String[] referencedIds = IdentityTypeUtil.getReferencedIds(descriptor);
        if (referencedIds != null) {
            return referencedIds[1];
        }
        throw new IdentityManagementException("No Partition id for descriptor [" + descriptor + "].");
    }

    public static String getIdentityType(String descriptor) {
        String[] referencedIds = IdentityTypeUtil.getReferencedIds(descriptor);
        if (referencedIds != null) {
            return referencedIds[0];
        }
        throw new IdentityManagementException("No type defined for descriptor [" + descriptor + "].");
    }

    public static String getIdentityTypeId(String descriptor) {
        String[] referencedIds = IdentityTypeUtil.getReferencedIds(descriptor);
        if (referencedIds != null) {
            return referencedIds[2];
        }
        throw new IdentityManagementException("No IdentityType id for descriptor [" + descriptor + "].");
    }

    public static String[] getReferencedIds(String referencedId) {
        if (referencedId != null) {
            String[] ids = referencedId.split(ID_SEPARATOR);
            if (ids.length < 2) {
                throw new IdentityManagementException("Wrong format for referenced identitytype id.");
            }
            return ids;
        }
        return null;
    }
}

