/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public abstract class RegionInterceptor
implements MutationInterceptor {
    private ClassTree currentClass;
    private Map<MethodTree, List<Region>> cache;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
        this.cache = new IdentityHashMap<MethodTree, List<Region>>();
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return mutations.stream().filter(this.buildPredicate().negate()).collect(Collectors.toList());
    }

    private Predicate<MutationDetails> buildPredicate() {
        return a -> {
            int instruction = a.getInstructionIndex();
            MethodTree method = this.currentClass.method(a.getId().getLocation()).get();
            List regions = this.cache.computeIfAbsent(method, this::computeRegions);
            return regions.stream().anyMatch(r -> instruction >= method.instructions().indexOf(r.start) && instruction <= method.instructions().indexOf(r.end));
        };
    }

    protected abstract List<Region> computeRegions(MethodTree var1);

    @Override
    public void end() {
        this.currentClass = null;
        this.cache = null;
    }
}

