/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.classpath.CodeSource;
import org.pitest.classpath.ProjectClassPaths;
import org.pitest.coverage.execute.CoverageOptions;
import org.pitest.coverage.execute.DefaultCoverageGenerator;
import org.pitest.mutationtest.HistoryStore;
import org.pitest.mutationtest.MutationResultListenerFactory;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.config.SettingsFactory;
import org.pitest.mutationtest.incremental.NullHistoryStore;
import org.pitest.mutationtest.incremental.NullWriterFactory;
import org.pitest.mutationtest.incremental.ObjectOutputStreamHistoryStore;
import org.pitest.mutationtest.incremental.WriterFactory;
import org.pitest.mutationtest.tooling.AnalysisResult;
import org.pitest.mutationtest.tooling.JarCreatingJarFinder;
import org.pitest.mutationtest.tooling.KnownLocationJavaAgentFinder;
import org.pitest.mutationtest.tooling.MutationCoverage;
import org.pitest.mutationtest.tooling.MutationStrategies;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureParameter;
import org.pitest.process.ArgLineParser;
import org.pitest.process.LaunchOptions;
import org.pitest.util.Log;
import org.pitest.util.PitError;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Timings;
import org.pitest.util.Verbosity;

public class EntryPoint {
    public AnalysisResult execute(File baseDir, ReportOptions data, PluginServices plugins, Map<String, String> environmentVariables) {
        SettingsFactory settings = new SettingsFactory(data, plugins);
        return this.execute(baseDir, data, settings, environmentVariables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisResult execute(File baseDir, ReportOptions data, SettingsFactory settings, Map<String, String> environmentVariables) {
        this.updateData(data, settings);
        if (data.getVerbosity() == Verbosity.VERBOSE) {
            Log.getLogger().info("Project base directory is " + data.getProjectBase());
            Log.getLogger().info("---------------------------------------------------------------------------");
            Log.getLogger().info("Enabled (+) and disabled (-) features.");
            Log.getLogger().info("-----------------------------------------");
            settings.describeFeatures(this.asInfo("+"), this.asInfo("-"));
            Log.getLogger().info("---------------------------------------------------------------------------");
        }
        settings.checkRequestedFeatures();
        this.checkMatrixMode(data);
        ClassPath cp = data.getClassPath();
        JarCreatingJarFinder jac = new JarCreatingJarFinder((ClassByteArraySource)new ClassPathByteArraySource(cp));
        KnownLocationJavaAgentFinder ja = new KnownLocationJavaAgentFinder(jac.getJarLocation().get());
        ResultOutputStrategy reportOutput = settings.getOutputStrategy();
        MutationResultListenerFactory reportFactory = settings.createListener();
        CoverageOptions coverageOptions = settings.createCoverageOptions();
        LaunchOptions launchOptions = new LaunchOptions(ja, settings.getJavaExecutable(), this.createJvmArgs(data), environmentVariables).usingClassPathJar(data.useClasspathJar());
        ProjectClassPaths cps = data.getMutationClassPaths();
        CodeSource code = settings.createCodeSource(cps);
        Timings timings = new Timings();
        DefaultCoverageGenerator coverageDatabase = new DefaultCoverageGenerator(baseDir, coverageOptions, launchOptions, code, settings.createCoverageExporter(), timings, data.getVerbosity());
        Optional<WriterFactory> maybeWriter = data.createHistoryWriter();
        WriterFactory historyWriter = maybeWriter.orElse(new NullWriterFactory());
        HistoryStore history = this.makeHistoryStore(data, maybeWriter);
        MutationStrategies strategies = new MutationStrategies(settings.createEngine(), history, coverageDatabase, reportFactory, settings.getResultInterceptor(), settings.createCoverageTransformer(code), reportOutput, settings.createVerifier().create(code));
        MutationCoverage report = new MutationCoverage(strategies, baseDir, code, data, settings, timings);
        try {
            AnalysisResult analysisResult = AnalysisResult.success(report.runReport());
            return analysisResult;
        }
        catch (IOException e) {
            AnalysisResult analysisResult = AnalysisResult.fail(e);
            return analysisResult;
        }
        finally {
            jac.close();
            ja.close();
            historyWriter.close();
        }
    }

    private List<String> createJvmArgs(ReportOptions data) {
        ArrayList<String> args = new ArrayList<String>(data.getJvmArgs());
        args.addAll(ArgLineParser.split(data.getArgLine()));
        return args;
    }

    private void updateData(ReportOptions data, SettingsFactory settings) {
        settings.createUpdater().updateConfig(null, data);
    }

    private HistoryStore makeHistoryStore(ReportOptions data, Optional<WriterFactory> historyWriter) {
        Optional<Reader> reader = data.createHistoryReader();
        if (!reader.isPresent() && !historyWriter.isPresent()) {
            return new NullHistoryStore();
        }
        return new ObjectOutputStreamHistoryStore(historyWriter.orElse(new NullWriterFactory()), reader);
    }

    private void checkMatrixMode(ReportOptions data) {
        if (data.isFullMutationMatrix() && !data.getOutputFormats().contains("XML")) {
            throw new PitError("Full mutation matrix is only supported in the output format XML.");
        }
    }

    private Consumer<Feature> asInfo(String leader) {
        return a -> {
            Log.getLogger().info(String.format("%1$-16s", leader + a.name()) + a.description());
            for (FeatureParameter each : a.params()) {
                Log.getLogger().info(String.format("%1$-18s", "  [" + each.name() + "]") + each.description());
            }
        };
    }
}

