/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.process;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.process.JavaAgent;
import org.pitest.process.JavaProcess;
import org.pitest.process.ProcessArgs;
import org.pitest.util.ManifestUtils;

public class WrappingProcess {
    private final int port;
    private final ProcessArgs processArgs;
    private final Class<?> minionClass;
    private JavaProcess process;

    public WrappingProcess(int port, ProcessArgs args, Class<?> minionClass) {
        this.port = port;
        this.processArgs = args;
        this.minionClass = minionClass;
    }

    public void start() throws IOException {
        String[] args = new String[]{"" + this.port};
        ProcessBuilder processBuilder = this.createProcessBuilder(this.processArgs.getJavaExecutable(), this.processArgs.getJvmArgs(), this.minionClass, Arrays.asList(args), this.processArgs.getJavaAgentFinder(), this.processArgs.getLaunchClassPath());
        this.setClassPathInEnvironment(processBuilder);
        this.configureProcessBuilder(processBuilder, this.processArgs.getWorkingDir(), this.processArgs.getEnvironmentVariables());
        Process process = processBuilder.start();
        this.process = new JavaProcess(process, this.processArgs.getStdout(), this.processArgs.getStdErr());
    }

    public boolean isAlive() {
        return this.process.isAlive();
    }

    private void setClassPathInEnvironment(ProcessBuilder processBuilder) {
        if (!this.processArgs.useClasspathJar()) {
            processBuilder.environment().put("CLASSPATH", this.processArgs.getLaunchClassPath());
        }
    }

    private void configureProcessBuilder(ProcessBuilder processBuilder, File workingDirectory, Map<String, String> environmentVariables) {
        processBuilder.directory(workingDirectory);
        Map<String, String> environment = processBuilder.environment();
        for (Map.Entry<String, String> entry : environmentVariables.entrySet()) {
            environment.put(entry.getKey(), entry.getValue());
        }
    }

    public void destroy() {
        this.process.destroy();
    }

    private ProcessBuilder createProcessBuilder(String javaProc, List<String> args, Class<?> mainClass, List<String> programArgs, JavaAgent javaAgent, String classPath) {
        List<String> cmd = this.createLaunchArgs(javaProc, javaAgent, args, mainClass, programArgs, classPath);
        WrappingProcess.removeClassPathProperties(cmd);
        this.removeJacocoAgent(cmd);
        return new ProcessBuilder(cmd);
    }

    private void removeJacocoAgent(List<String> cmd) {
        WrappingProcess.removeFromClassPath(cmd, line -> line.startsWith("-javaagent") && line.contains("jacoco"));
    }

    private static void removeClassPathProperties(List<String> cmd) {
        WrappingProcess.removeFromClassPath(cmd, s -> s.startsWith("-Djava.class.path"));
    }

    private static void removeFromClassPath(List<String> cmd, Predicate<String> match) {
        for (int i = cmd.size() - 1; i >= 0; --i) {
            if (!match.test(cmd.get(i))) continue;
            cmd.remove(i);
        }
    }

    private List<String> createLaunchArgs(String javaProcess, JavaAgent agentJarLocator, List<String> args, Class<?> mainClass, List<String> programArgs, String classPath) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(javaProcess);
        this.createClasspathJar(classPath, cmd);
        WrappingProcess.addPITJavaAgent(agentJarLocator, cmd);
        cmd.addAll(args);
        WrappingProcess.addLaunchJavaAgents(cmd);
        cmd.add(mainClass.getName());
        cmd.addAll(programArgs);
        return cmd;
    }

    private void createClasspathJar(String classPath, List<String> cmd) {
        if (this.processArgs.useClasspathJar()) {
            try {
                cmd.add("-classpath");
                cmd.add(ManifestUtils.createClasspathJarFile((String)classPath).getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create jar to contain classpath", e);
            }
        }
    }

    private static void addPITJavaAgent(JavaAgent agentJarLocator, List<String> cmd) {
        Optional<String> jarLocation = agentJarLocator.getJarLocation();
        jarLocation.ifPresent(l -> cmd.add("-javaagent:" + l));
    }

    private static void addLaunchJavaAgents(List<String> cmd) {
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        List agents = FCollection.filter(rt.getInputArguments(), (Predicate)Prelude.or((Predicate[])new Predicate[]{WrappingProcess.isJavaAgentParam(), WrappingProcess.isEnvironmentSetting()}));
        cmd.addAll(agents);
    }

    private static Predicate<String> isEnvironmentSetting() {
        return a -> a.startsWith("-D");
    }

    private static Predicate<String> isJavaAgentParam() {
        return a -> a.toLowerCase().startsWith("-javaagent");
    }

    public JavaProcess getProcess() {
        return this.process;
    }
}

