/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.math.BigInteger;
import java.util.Optional;
import org.pitest.classinfo.ClassHash;
import org.pitest.classinfo.ClassIdentifier;
import org.pitest.classinfo.ClassInfoBuilder;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.ClassPointer;
import org.pitest.classinfo.HierarchicalClassId;

public final class ClassInfo
implements ClassHash {
    private final ClassIdentifier id;
    private final ClassPointer outerClass;
    private final ClassPointer superClass;

    public ClassInfo(ClassPointer superClass, ClassPointer outerClass, ClassInfoBuilder builder) {
        this(superClass, outerClass, builder.id);
    }

    public ClassInfo(ClassPointer superClass, ClassPointer outerClass, ClassIdentifier id) {
        this.superClass = superClass;
        this.outerClass = outerClass;
        this.id = id;
    }

    @Override
    public ClassIdentifier getId() {
        return this.id;
    }

    @Override
    public ClassName getName() {
        return this.id.getName();
    }

    public Optional<ClassInfo> getOuterClass() {
        return this.outerClass.fetch();
    }

    public Optional<ClassInfo> getSuperClass() {
        return this.getParent();
    }

    public boolean descendsFrom(Class<?> clazz) {
        return this.descendsFrom(ClassName.fromClass(clazz));
    }

    @Override
    public HierarchicalClassId getHierarchicalId() {
        return new HierarchicalClassId(this.id, this.getDeepHash());
    }

    @Override
    public BigInteger getDeepHash() {
        Optional<ClassInfo> outer;
        BigInteger hash = this.getHash();
        Optional<ClassInfo> parent = this.getParent();
        if (parent.isPresent()) {
            hash = hash.add(parent.get().getHash());
        }
        if ((outer = this.getOuterClass()).isPresent()) {
            hash = hash.add(outer.get().getHash());
        }
        return hash;
    }

    public BigInteger getHash() {
        return BigInteger.valueOf(this.id.getHash());
    }

    private Optional<ClassInfo> getParent() {
        if (this.superClass == null) {
            return Optional.empty();
        }
        return this.superClass.fetch();
    }

    private boolean descendsFrom(ClassName clazz) {
        if (!this.getSuperClass().isPresent()) {
            return false;
        }
        if (this.getSuperClass().get().getName().equals((Object)clazz)) {
            return true;
        }
        return this.getSuperClass().get().descendsFrom(clazz);
    }

    public String toString() {
        return this.id.getName().asJavaName();
    }
}

