/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.defensive;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.build.intercept.RegionInterceptor;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotWrite;

public class UnmodifiableCollections
extends RegionInterceptor {
    static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    static final SequenceMatcher<AbstractInsnNode> DEFENSIVE_RETURN = QueryStart.any(AbstractInsnNode.class).then(OpcodeMatchers.INVOKESTATIC.and(InstructionMatchers.methodCallTo(ClassName.fromClass(Collections.class), n -> n.startsWith("unmodifiable"))).and(UnmodifiableCollections.store(MUTATED_INSTRUCTION.write()))).then(OpcodeMatchers.ARETURN.or(OpcodeMatchers.PUTFIELD)).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction().or(InstructionMatchers.isA(LabelNode.class))));

    @Override
    protected List<Region> computeRegions(MethodTree method) {
        Context context = Context.start();
        return DEFENSIVE_RETURN.contextMatches(method.instructions(), context).stream().map(c -> c.retrieve(MUTATED_INSTRUCTION.read()).get()).map(n -> new Region((AbstractInsnNode)n, (AbstractInsnNode)n)).collect(Collectors.toList());
    }

    private static Match<AbstractInsnNode> store(SlotWrite<AbstractInsnNode> slot) {
        return (c, n) -> Result.result(true, c.store(slot, n));
    }
}

